/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.AppendingPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static NumericDocValues getNormValues(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNormValues(field);
        }
        FieldInfo fi = MultiFields.getMergedFieldInfos(r).fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        boolean anyReal = false;
        final NumericDocValues[] values = new NumericDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            NumericDocValues v = context.reader().getNormValues(field);
            if (v == null) {
                v = DocValues.emptyNumeric();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        assert (anyReal);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts);
                return values[subIndex].get(docID - starts[subIndex]);
            }
        };
    }

    public static NumericDocValues getNumericValues(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNumericDocValues(field);
        }
        boolean anyReal = false;
        final NumericDocValues[] values = new NumericDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            NumericDocValues v = context.reader().getNumericDocValues(field);
            if (v == null) {
                v = DocValues.emptyNumeric();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts);
                return values[subIndex].get(docID - starts[subIndex]);
            }
        };
    }

    public static Bits getDocsWithField(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getDocsWithField(field);
        }
        boolean anyReal = false;
        boolean anyMissing = false;
        Bits[] values = new Bits[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            Bits v = context.reader().getDocsWithField(field);
            if (v == null) {
                v = new Bits.MatchNoBits(context.reader().maxDoc());
                anyMissing = true;
            } else {
                anyReal = true;
                if (!(v instanceof Bits.MatchAllBits)) {
                    anyMissing = true;
                }
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        if (!anyMissing) {
            return new Bits.MatchAllBits(r.maxDoc());
        }
        return new MultiBits(values, starts, false);
    }

    public static BinaryDocValues getBinaryValues(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getBinaryDocValues(field);
        }
        boolean anyReal = false;
        final BinaryDocValues[] values = new BinaryDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            BinaryDocValues v = context.reader().getBinaryDocValues(field);
            if (v == null) {
                v = DocValues.emptyBinary();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts);
                return values[subIndex].get(docID - starts[subIndex]);
            }
        };
    }

    public static SortedNumericDocValues getSortedNumericValues(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedNumericDocValues(field);
        }
        boolean anyReal = false;
        final SortedNumericDocValues[] values = new SortedNumericDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            SortedNumericDocValues v = context.reader().getSortedNumericDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedNumeric();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new SortedNumericDocValues(){
            SortedNumericDocValues current;

            @Override
            public void setDocument(int doc) {
                int subIndex = ReaderUtil.subIndex(doc, starts);
                this.current = values[subIndex];
                this.current.setDocument(doc - starts[subIndex]);
            }

            @Override
            public long valueAt(int index) {
                return this.current.valueAt(index);
            }

            @Override
            public int count() {
                return this.current.count();
            }
        };
    }

    public static SortedDocValues getSortedValues(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedDocValues(field);
        }
        boolean anyReal = false;
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        TermsEnum[] enums = new TermsEnum[values.length];
        for (int i = 0; i < values.length; ++i) {
            enums[i] = values[i].termsEnum();
        }
        OrdinalMap mapping = new OrdinalMap(r.getCoreCacheKey(), enums);
        return new MultiSortedDocValues(values, starts, mapping);
    }

    public static SortedSetDocValues getSortedSetValues(IndexReader r, String field) throws IOException {
        List<AtomicReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedSetDocValues(field);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            AtomicReaderContext context = leaves.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        TermsEnum[] enums = new TermsEnum[values.length];
        for (int i = 0; i < values.length; ++i) {
            enums[i] = values[i].termsEnum();
        }
        OrdinalMap mapping = new OrdinalMap(r.getCoreCacheKey(), enums);
        return new MultiSortedSetDocValues(values, starts, mapping);
    }

    public static class MultiSortedSetDocValues
    extends SortedSetDocValues {
        public final int[] docStarts;
        public final SortedSetDocValues[] values;
        public final OrdinalMap mapping;
        int currentSubIndex;

        MultiSortedSetDocValues(SortedSetDocValues[] values, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (values.length == mapping.segmentToGlobalOrds.length);
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public long nextOrd() {
            long segmentOrd = this.values[this.currentSubIndex].nextOrd();
            if (segmentOrd == -1L) {
                return segmentOrd;
            }
            return this.mapping.segmentToGlobalOrds[this.currentSubIndex].get(segmentOrd);
        }

        @Override
        public void setDocument(int docID) {
            this.currentSubIndex = ReaderUtil.subIndex(docID, this.docStarts);
            this.values[this.currentSubIndex].setDocument(docID - this.docStarts[this.currentSubIndex]);
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }
    }

    public static class MultiSortedDocValues
    extends SortedDocValues {
        public final int[] docStarts;
        public final SortedDocValues[] values;
        public final OrdinalMap mapping;

        MultiSortedDocValues(SortedDocValues[] values, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (values.length == mapping.segmentToGlobalOrds.length);
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public int getOrd(int docID) {
            int subIndex = ReaderUtil.subIndex(docID, this.docStarts);
            int segmentOrd = this.values[subIndex].getOrd(docID - this.docStarts[subIndex]);
            return segmentOrd == -1 ? segmentOrd : (int)this.mapping.segmentToGlobalOrds[subIndex].get(segmentOrd);
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }
    }

    public static class OrdinalMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
        final Object owner;
        final MonotonicAppendingLongBuffer globalOrdDeltas;
        final AppendingPackedLongBuffer firstSegments;
        final LongValues[] segmentToGlobalOrds;
        final long ramBytesUsed;

        public OrdinalMap(Object owner, TermsEnum[] subs, float acceptableOverheadRatio) throws IOException {
            this.owner = owner;
            this.globalOrdDeltas = new MonotonicAppendingLongBuffer(0.0f);
            this.firstSegments = new AppendingPackedLongBuffer(0.0f);
            MonotonicAppendingLongBuffer[] ordDeltas = new MonotonicAppendingLongBuffer[subs.length];
            for (int i = 0; i < ordDeltas.length; ++i) {
                ordDeltas[i] = new MonotonicAppendingLongBuffer(acceptableOverheadRatio);
            }
            long[] ordDeltaBits = new long[subs.length];
            long[] segmentOrds = new long[subs.length];
            ReaderSlice[] slices = new ReaderSlice[subs.length];
            MultiTermsEnum.TermsEnumIndex[] indexes = new MultiTermsEnum.TermsEnumIndex[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = new ReaderSlice(0, 0, i);
                indexes[i] = new MultiTermsEnum.TermsEnumIndex(subs[i], i);
            }
            MultiTermsEnum mte = new MultiTermsEnum(slices);
            mte.reset(indexes);
            long globalOrd = 0L;
            while (mte.next() != null) {
                MultiTermsEnum.TermsEnumWithSlice[] matches = mte.getMatchArray();
                for (int i = 0; i < mte.getMatchCount(); ++i) {
                    int segmentIndex = matches[i].index;
                    long segmentOrd = matches[i].terms.ord();
                    long delta = globalOrd - segmentOrd;
                    if (i == 0) {
                        this.firstSegments.add(segmentIndex);
                        this.globalOrdDeltas.add(delta);
                    }
                    while (segmentOrds[segmentIndex] <= segmentOrd) {
                        int n = segmentIndex;
                        ordDeltaBits[n] = ordDeltaBits[n] | delta;
                        ordDeltas[segmentIndex].add(delta);
                        int n2 = segmentIndex;
                        segmentOrds[n2] = segmentOrds[n2] + 1L;
                    }
                }
                ++globalOrd;
            }
            this.firstSegments.freeze();
            this.globalOrdDeltas.freeze();
            for (int i = 0; i < ordDeltas.length; ++i) {
                ordDeltas[i].freeze();
            }
            this.segmentToGlobalOrds = new LongValues[subs.length];
            long ramBytesUsed = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds);
            for (int i = 0; i < ordDeltas.length; ++i) {
                final MonotonicAppendingLongBuffer deltas = ordDeltas[i];
                if (ordDeltaBits[i] == 0L) {
                    this.segmentToGlobalOrds[i] = LongValues.IDENTITY;
                    continue;
                }
                int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i]);
                long monotonicBits = deltas.ramBytesUsed() * 8L;
                long packedBits = (long)bitsRequired * deltas.size();
                if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                    int size = (int)deltas.size();
                    final PackedInts.Mutable newDeltas = PackedInts.getMutable(size, bitsRequired, acceptableOverheadRatio);
                    AbstractAppendingLongBuffer.Iterator it = deltas.iterator();
                    for (int ord = 0; ord < size; ++ord) {
                        newDeltas.set(ord, it.next());
                    }
                    assert (!it.hasNext());
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + newDeltas.get((int)ord);
                        }
                    };
                    ramBytesUsed += newDeltas.ramBytesUsed();
                } else {
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + deltas.get(ord);
                        }
                    };
                    ramBytesUsed += deltas.ramBytesUsed();
                }
                ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i]);
            }
            this.ramBytesUsed = ramBytesUsed;
        }

        public OrdinalMap(Object owner, TermsEnum[] subs) throws IOException {
            this(owner, subs, 0.25f);
        }

        public LongValues getGlobalOrds(int segmentIndex) {
            return this.segmentToGlobalOrds[segmentIndex];
        }

        public long getFirstSegmentOrd(long globalOrd) {
            return globalOrd - this.globalOrdDeltas.get(globalOrd);
        }

        public int getFirstSegmentNumber(long globalOrd) {
            return (int)this.firstSegments.get(globalOrd);
        }

        public long getValueCount() {
            return this.globalOrdDeltas.size();
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }
}

