/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rest.InvocationContext;

public class ParseNestedBoolean
implements Function<HttpResponse, Boolean>,
InvocationContext<ParseNestedBoolean> {
    private final ParseJson<Map<String, Map<String, Boolean>>> json;

    @Inject
    ParseNestedBoolean(ParseJson<Map<String, Map<String, Boolean>>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public Boolean apply(HttpResponse response) {
        Map map = (Map)this.json.apply(response);
        if (map == null || map.isEmpty()) {
            throw new HttpResponseException("Unexpected JSON format returned.", null, response);
        }
        return (Boolean)Iterables.get(((Map)Iterables.get(map.values(), (int)0)).values(), (int)0);
    }

    public ParseNestedBoolean setContext(HttpRequest request) {
        return this;
    }
}

