/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
define(["./defined-2a4f2d00","./Check-e5651467","./freezeObject-a51e076f","./defaultValue-29c9b1af","./Math-7782f09e","./Cartesian2-ba70b51f","./defineProperties-c817531e","./Transforms-5119c07b","./RuntimeError-51c34ab4","./WebGLConstants-90dbfe2f","./ComponentDatatype-418b1c61","./when-1faa3867","./AttributeCompression-5601f533","./IndexDatatype-2bcfc06b","./IntersectionTests-35b85442","./Plane-475170f0","./createTaskProcessorWorker","./EllipsoidTangentPlane-0decb876","./OrientedBoundingBox-2b5c2949","./EllipsoidalOccluder-e6218e4e","./TerrainEncoding-114aa591"],function(w,e,t,i,ce,ge,n,me,s,r,h,u,o,xe,a,p,d,f,ve,we,Ce){"use strict";var ye={clipTriangleAtAxisAlignedThreshold:function(e,t,i,n,s,r){var h,u,o;w.defined(r)?r.length=0:r=[],o=t?(h=i<e,u=n<e,s<e):(h=e<i,u=e<n,e<s);var a,p,d,f,l,c,g=h+u+o;return 1===g?h?(a=(e-i)/(n-i),p=(e-i)/(s-i),r.push(1),r.push(2),1!==p&&(r.push(-1),r.push(0),r.push(2),r.push(p)),1!==a&&(r.push(-1),r.push(0),r.push(1),r.push(a))):u?(d=(e-n)/(s-n),f=(e-n)/(i-n),r.push(2),r.push(0),1!==f&&(r.push(-1),r.push(1),r.push(0),r.push(f)),1!==d&&(r.push(-1),r.push(1),r.push(2),r.push(d))):o&&(l=(e-s)/(i-s),c=(e-s)/(n-s),r.push(0),r.push(1),1!==c&&(r.push(-1),r.push(2),r.push(1),r.push(c)),1!==l&&(r.push(-1),r.push(2),r.push(0),r.push(l))):2===g?h||i===e?u||n===e?o||s===e||(p=(e-i)/(s-i),d=(e-n)/(s-n),r.push(2),r.push(-1),r.push(0),r.push(2),r.push(p),r.push(-1),r.push(1),r.push(2),r.push(d)):(c=(e-s)/(n-s),a=(e-i)/(n-i),r.push(1),r.push(-1),r.push(2),r.push(1),r.push(c),r.push(-1),r.push(0),r.push(1),r.push(a)):(f=(e-n)/(i-n),l=(e-s)/(i-s),r.push(0),r.push(-1),r.push(1),r.push(0),r.push(f),r.push(-1),r.push(2),r.push(0),r.push(l)):3!==g&&(r.push(0),r.push(1),r.push(2)),r},computeBarycentricCoordinates:function(e,t,i,n,s,r,h,u,o){var a=i-h,p=h-s,d=r-u,f=n-u,l=1/(d*a+p*f),c=t-u,g=e-h,m=(d*g+p*c)*l,x=(-f*g+a*c)*l,v=1-m-x;return w.defined(o)?(o.x=m,o.y=x,o.z=v,o):new ge.Cartesian3(m,x,v)},computeLineSegmentLineSegmentIntersection:function(e,t,i,n,s,r,h,u,o){var a=(u-r)*(i-e)-(h-s)*(n-t);if(0!=a){var p=((h-s)*(t-r)-(u-r)*(e-s))/a,d=((i-e)*(t-r)-(n-t)*(e-s))/a;return 0<=p&&p<=1&&0<=d&&d<=1?(w.defined(o)||(o=new ge.Cartesian2),o.x=e+p*(i-e),o.y=t+p*(n-t),o):void 0}}},Be=32767,be=16383,Ie=[],Ae=[],Te=[],ze=new ge.Cartographic,Ve=new ge.Cartesian3,Me=[],Ne=[],Ee=[],Oe=[],He=[],Re=new ge.Cartesian3,Fe=new me.BoundingSphere,Pe=new ve.OrientedBoundingBox,Se=new ge.Cartesian2,Ue=new ge.Cartesian3;function ke(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}ke.prototype.clone=function(e){return w.defined(e)||(e=new ke),e.uBuffer=this.uBuffer,e.vBuffer=this.vBuffer,e.heightBuffer=this.heightBuffer,e.normalBuffer=this.normalBuffer,e.index=this.index,e.first=this.first,e.second=this.second,e.ratio=this.ratio,e},ke.prototype.initializeIndexed=function(e,t,i,n,s){this.uBuffer=e,this.vBuffer=t,this.heightBuffer=i,this.normalBuffer=n,this.index=s,this.first=void 0,this.second=void 0,this.ratio=void 0},ke.prototype.initializeFromClipResult=function(e,t,i){var n=t+1;return-1!==e[t]?i[e[t]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=i[e[n]],++n,this.second=i[e[n]],++n,this.ratio=e[n],++n),n},ke.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},ke.prototype.isIndexed=function(){return w.defined(this.index)},ke.prototype.getH=function(){return w.defined(this.index)?this.heightBuffer[this.index]:ce.CesiumMath.lerp(this.first.getH(),this.second.getH(),this.ratio)},ke.prototype.getU=function(){return w.defined(this.index)?this.uBuffer[this.index]:ce.CesiumMath.lerp(this.first.getU(),this.second.getU(),this.ratio)},ke.prototype.getV=function(){return w.defined(this.index)?this.vBuffer[this.index]:ce.CesiumMath.lerp(this.first.getV(),this.second.getV(),this.ratio)};var l=new ge.Cartesian2,c=-1,g=[new ge.Cartesian3,new ge.Cartesian3],m=[new ge.Cartesian3,new ge.Cartesian3];function x(e,t){var i=g[++c],n=m[c];return i=o.AttributeCompression.octDecode(e.first.getNormalX(),e.first.getNormalY(),i),n=o.AttributeCompression.octDecode(e.second.getNormalX(),e.second.getNormalY(),n),Ve=ge.Cartesian3.lerp(i,n,e.ratio,Ve),ge.Cartesian3.normalize(Ve,Ve),o.AttributeCompression.octEncode(Ve,t),--c,t}ke.prototype.getNormalX=function(){return w.defined(this.index)?this.normalBuffer[2*this.index]:(l=x(this,l)).x},ke.prototype.getNormalY=function(){return w.defined(this.index)?this.normalBuffer[2*this.index+1]:(l=x(this,l)).y};var v=[];function De(e,t,i,n,s,r,h,u,o){if(0!==h.length){for(var a=0,p=0;p<h.length;)p=v[a++].initializeFromClipResult(h,p,u);for(var d=0;d<a;++d){var f=v[d];if(f.isIndexed())f.newIndex=r[f.index],f.uBuffer=e,f.vBuffer=t,f.heightBuffer=i,o&&(f.normalBuffer=n);else{var l=f.getKey();if(w.defined(r[l]))f.newIndex=r[l];else{var c=e.length;e.push(f.getU()),t.push(f.getV()),i.push(f.getH()),o&&(n.push(f.getNormalX()),n.push(f.getNormalY())),f.newIndex=c,r[l]=c}}}3===a?(s.push(v[0].newIndex),s.push(v[1].newIndex),s.push(v[2].newIndex)):4===a&&(s.push(v[0].newIndex),s.push(v[1].newIndex),s.push(v[2].newIndex),s.push(v[0].newIndex),s.push(v[2].newIndex),s.push(v[3].newIndex))}}return v.push(new ke),v.push(new ke),v.push(new ke),v.push(new ke),d(function(e,t){var i=e.isEastChild,n=e.isNorthChild,s=i?be:0,r=i?Be:be,h=n?be:0,u=n?Be:be,o=Me,a=Ne,p=Ee,d=He;o.length=0,a.length=0,p.length=0,d.length=0;var f=Oe;f.length=0;var l={},c=e.vertices,g=e.indices;g=g.subarray(0,e.skirtIndex);var m,x,v,w,C,y=Ce.TerrainEncoding.clone(e.encoding),B=y.hasVertexNormals,b=e.exaggeration,I=0,A=e.vertexCountWithoutSkirts,T=e.minimumHeight,z=e.maximumHeight,V=new Array(A),M=new Array(A),N=new Array(A),E=B?new Array(2*A):void 0;for(v=x=0;x<A;++x,v+=2){var O=y.decodeTextureCoordinates(c,x,Se);if(m=y.decodeHeight(c,x)/b,w=ce.CesiumMath.clamp(O.x*Be|0,0,Be),C=ce.CesiumMath.clamp(O.y*Be|0,0,Be),N[x]=ce.CesiumMath.clamp((m-T)/(z-T)*Be|0,0,Be),w<20&&(w=0),C<20&&(C=0),Be-w<20&&(w=Be),Be-C<20&&(C=Be),V[x]=w,M[x]=C,B){var H=y.getOctEncodedNormal(c,x,Ue);E[v]=H.x,E[v+1]=H.y}(i&&be<=w||!i&&w<=be)&&(n&&be<=C||!n&&C<=be)&&(l[x]=I,o.push(w),a.push(C),p.push(N[x]),B&&(d.push(E[v]),d.push(E[v+1])),++I)}var R=[];R.push(new ke),R.push(new ke),R.push(new ke);var F,P=[];for(P.push(new ke),P.push(new ke),P.push(new ke),x=0;x<g.length;x+=3){var S=g[x],U=g[x+1],k=g[x+2],D=V[S],X=V[U],K=V[k];R[0].initializeIndexed(V,M,N,E,S),R[1].initializeIndexed(V,M,N,E,U),R[2].initializeIndexed(V,M,N,E,k);var L=ye.clipTriangleAtAxisAlignedThreshold(be,i,D,X,K,Ie);(F=0)>=L.length||(F=P[0].initializeFromClipResult(L,F,R))>=L.length||(F=P[1].initializeFromClipResult(L,F,R))>=L.length||(F=P[2].initializeFromClipResult(L,F,R),De(o,a,p,d,f,l,ye.clipTriangleAtAxisAlignedThreshold(be,n,P[0].getV(),P[1].getV(),P[2].getV(),Ae),P,B),F<L.length&&(P[2].clone(P[1]),P[2].initializeFromClipResult(L,F,R),De(o,a,p,d,f,l,ye.clipTriangleAtAxisAlignedThreshold(be,n,P[0].getV(),P[1].getV(),P[2].getV(),Ae),P,B)))}var W=i?-Be:0,Y=n?-Be:0,_=[],j=[],G=[],J=[],Z=Number.MAX_VALUE,q=-Z,Q=Te;Q.length=0;var $=ge.Ellipsoid.clone(e.ellipsoid),ee=e.childRectangle,te=ee.north,ie=ee.south,ne=ee.east,se=ee.west;for(ne<se&&(ne+=ce.CesiumMath.TWO_PI),x=0;x<o.length;++x)w=(w=Math.round(o[x]))<=s?(_.push(x),0):r<=w?(G.push(x),Be):2*w+W,o[x]=w,C=(C=Math.round(a[x]))<=h?(j.push(x),0):u<=C?(J.push(x),Be):2*C+Y,a[x]=C,(m=ce.CesiumMath.lerp(T,z,p[x]/Be))<Z&&(Z=m),q<m&&(q=m),p[x]=m,ze.longitude=ce.CesiumMath.lerp(se,ne,w/Be),ze.latitude=ce.CesiumMath.lerp(ie,te,C/Be),ze.height=m,$.cartographicToCartesian(ze,Ve),Q.push(Ve.x),Q.push(Ve.y),Q.push(Ve.z);var re=me.BoundingSphere.fromVertices(Q,ge.Cartesian3.ZERO,3,Fe),he=ve.OrientedBoundingBox.fromRectangle(ee,Z,q,$,Pe),ue=new we.EllipsoidalOccluder($).computeHorizonCullingPointFromVertices(re.center,Q,3,re.center,Re),oe=q-Z,ae=new Uint16Array(o.length+a.length+p.length);for(x=0;x<o.length;++x)ae[x]=o[x];var pe=o.length;for(x=0;x<a.length;++x)ae[pe+x]=a[x];for(pe+=a.length,x=0;x<p.length;++x)ae[pe+x]=Be*(p[x]-Z)/oe;var de,fe=xe.IndexDatatype.createTypedArray(o.length,f);if(B){var le=new Uint8Array(d);t.push(ae.buffer,fe.buffer,le.buffer),de=le.buffer}else t.push(ae.buffer,fe.buffer);return{vertices:ae.buffer,encodedNormals:de,indices:fe.buffer,minimumHeight:Z,maximumHeight:q,westIndices:_,southIndices:j,eastIndices:G,northIndices:J,boundingSphere:re,orientedBoundingBox:he,horizonOcclusionPoint:ue}})});
