/*
 * Copyright (C) 2001-2016 Food and Agriculture Organization of the
 * United Nations (FAO-UN), United Nations World Food Programme (WFP)
 * and United Nations Environment Programme (UNEP)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * Contact: Jeroen Ticheler - FAO - Viale delle Terme di Caracalla 2,
 * Rome - Italy. email: geonetwork@osgeo.org
 */

(function() {
  goog.provide('gn_checkbox_with_nilreason');

  var module = angular.module('gn_checkbox_with_nilreason', []);

  /**
   *  Create a widget to handle 3 states checkbox
   */
  module.directive('gnCheckboxWithNilreason',
      ['$http', '$rootScope', '$filter', '$timeout',
        'gnSchemaManagerService', 'gnCurrentEdit',
       function($http, $rootScope, $filter, $timeout,
                gnSchemaManagerService, gnCurrentEdit) {

         return {
           restrict: 'A',
           scope: {
             value: '@gnCheckboxWithNilreason',
             label: '@',
             elementName: '@',
             elementRef: '@',
             tagName: '@',
             id: '@',
             nilreason: '@',
             labels: '@'
           },
           templateUrl: '../../catalog/components/edit/checkboxwithnilreason/' +
           'partials/checkboxwithnilreason.html',
           link: function(scope, element, attrs) {
             scope.status = scope.nilreason || scope.value;
             scope.radioLabels = attrs.labels ? angular.fromJson(attrs.labels) :
             {'true': 'true', 'false': 'false', 'unknown': 'unknown'};

             // Unique key for radio name to not mix between
             // directive instances in the same form
             scope.key = Math.random();

             var booleanElement = 'gco:Boolean',
             booleanElementNs = booleanElement.split(':')[0],
             elementNs = scope.tagName.split(':')[0];

             function build() {
               var attribute = '', isNil = scope.status === 'unknown';

               if (isNil) {
                 attribute = ' gco:nilReason="' + scope.status + '"';
               }

               var booleanXmlSnippet = (isNil) ? '' : '<' +
               booleanElement + '>' + scope.status +
               '</' + booleanElement + '>';

               scope.xmlSnippet = '<' + scope.tagName +
               ' xmlns:' + elementNs + '="' +
               gnSchemaManagerService.findNamespaceUri(elementNs,
                   gnCurrentEdit.schema) + '"' +
               ' xmlns:' + booleanElementNs + '="' +
               gnSchemaManagerService.findNamespaceUri(booleanElementNs,
                   gnCurrentEdit.schema) + '"' +
               attribute + '>' + booleanXmlSnippet + '</' + scope.tagName + '>';
             }

             scope.$watch('status', build);

             // Populate the field generated by the XSL form builder
             scope.$watch('xmlSnippet', function() {
               if (scope.id) {
                 // This is required on init to have the optionally
                 // templateFieldDirective initialized first so
                 // that the template is properly computed.
                 $timeout(function() {
                   $(scope.id).val(scope.xmlSnippet);
                   $(scope.id).change();
                 });
               }
             });

             build();
           }
         };
       }]);
})();
