/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CodeTableHandler
extends DefaultHandler {
    private Hashtable sets;
    private Hashtable charset;
    private Hashtable combiningchars;
    private Integer isocode;
    private Integer marc;
    private Character ucs;
    private boolean useAlt = false;
    private boolean iscombining;
    private Vector combining;
    private String tag;
    private StringBuffer data;
    private Locator locator;

    public Hashtable getCharSets() {
        return this.sets;
    }

    public Hashtable getCombiningChars() {
        return this.combiningchars;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXParseException {
        if (name.equals("characterSet")) {
            this.charset = new Hashtable();
            this.isocode = Integer.valueOf(atts.getValue("ISOcode"), 16);
            this.combining = new Vector();
        } else if (name.equals("marc")) {
            this.data = new StringBuffer();
        } else if (name.equals("codeTables")) {
            this.sets = new Hashtable();
            this.combiningchars = new Hashtable();
        } else if (name.equals("ucs")) {
            this.data = new StringBuffer();
        } else if (name.equals("alt")) {
            this.data = new StringBuffer();
        } else if (name.equals("isCombining")) {
            this.data = new StringBuffer();
        } else if (name.equals("code")) {
            this.iscombining = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.data != null) {
            this.data.append(ch, start, length);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXParseException {
        if (name.equals("characterSet")) {
            this.sets.put(this.isocode, this.charset);
            this.combiningchars.put(this.isocode, this.combining);
            this.combining = null;
            this.charset = null;
        } else if (name.equals("marc")) {
            this.marc = Integer.valueOf(this.data.toString(), 16);
        } else if (name.equals("ucs")) {
            if (this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
            } else {
                this.useAlt = true;
            }
        } else if (name.equals("alt")) {
            if (this.useAlt && this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
                this.useAlt = false;
            }
        } else if (name.equals("code")) {
            if (this.iscombining) {
                this.combining.add(this.marc);
            }
            this.charset.put(this.marc, this.ucs);
        } else if (name.equals("isCombining") && this.data.toString().equals("true")) {
            this.iscombining = true;
        }
        this.data = null;
    }

    public static void main(String[] args) {
        Hashtable charsets = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File("C:\\Documents and Settings\\ckeith\\Desktop\\Projects\\Code Tables\\codetables.xml");
            InputSource src = new InputSource(new FileInputStream(file));
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            System.out.println(saxUms.getCombiningChars());
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
        }
    }
}

