/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.BaseLdapPathAware;
import org.springframework.ldap.core.support.BaseLdapPathSource;
import org.springframework.util.StringUtils;

public class BaseLdapPathBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private ApplicationContext applicationContext;
    private DistinguishedName basePath;
    private String baseLdapPathSourceName;
    private int order = Integer.MAX_VALUE;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof BaseLdapPathAware) {
            BaseLdapPathAware baseLdapPathAware = (BaseLdapPathAware)bean;
            if (this.basePath != null) {
                baseLdapPathAware.setBaseLdapPath(this.basePath);
            } else {
                BaseLdapPathSource ldapPathSource = this.getBaseLdapPathSourceFromApplicationContext();
                baseLdapPathAware.setBaseLdapPath(ldapPathSource.getBaseLdapPath().immutableDistinguishedName());
            }
        }
        return bean;
    }

    BaseLdapPathSource getBaseLdapPathSourceFromApplicationContext() {
        if (StringUtils.hasLength((String)this.baseLdapPathSourceName)) {
            return (BaseLdapPathSource)this.applicationContext.getBean(this.baseLdapPathSourceName);
        }
        String[] definedContextSources = this.applicationContext.getBeanNamesForType(BaseLdapPathSource.class);
        if (definedContextSources.length < 1) {
            throw new NoSuchBeanDefinitionException("No BaseLdapPathSource implementation definition found");
        }
        if (definedContextSources.length > 1) {
            throw new NoSuchBeanDefinitionException("More than BaseLdapPathSource implementation definition found in current ApplicationContext");
        }
        return (BaseLdapPathSource)this.applicationContext.getBean(definedContextSources[0]);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBasePath(DistinguishedName basePath) {
        this.basePath = basePath.immutableDistinguishedName();
    }

    public void setBaseLdapPathSourceName(String contextSourceName) {
        this.baseLdapPathSourceName = contextSourceName;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

