/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.scalebar;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Font;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.List;
import org.mapfish.print.ChunkDrawer;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.config.layout.ScalebarBlock;
import org.mapfish.print.scalebar.BarScalebarDrawer;
import org.mapfish.print.scalebar.BarSubScalebarDrawer;
import org.mapfish.print.scalebar.Direction;
import org.mapfish.print.scalebar.Label;
import org.mapfish.print.scalebar.LineScalebarDrawer;
import org.mapfish.print.scalebar.Type;

public abstract class ScalebarDrawer
extends ChunkDrawer {
    protected final ScalebarBlock block;
    protected final List<Label> labels;
    protected final int barSize;
    private final int labelDistance;
    protected final int subIntervals;
    protected final float intervalWidth;
    private final Font pdfFont;
    private final float leftLabelMargin;
    private final float rightLabelMargin;
    private final float maxLabelWidth;
    private final float maxLabelHeight;

    public ScalebarDrawer(PDFCustomBlocks customBlocks, ScalebarBlock block, List<Label> labels, int barSize, int labelDistance, int subIntervals, float intervalWidth, Font pdfFont, float leftLabelMargin, float rightLabelMargin, float maxLabelWidth, float maxLabelHeight) {
        super(customBlocks);
        this.block = block;
        this.labels = labels;
        this.barSize = barSize;
        this.labelDistance = labelDistance;
        this.subIntervals = subIntervals;
        this.intervalWidth = intervalWidth;
        this.pdfFont = pdfFont;
        this.leftLabelMargin = leftLabelMargin;
        this.rightLabelMargin = rightLabelMargin;
        this.maxLabelWidth = maxLabelWidth;
        this.maxLabelHeight = maxLabelHeight;
    }

    public static ScalebarDrawer create(PDFCustomBlocks customBlocks, ScalebarBlock block, Type type, List<Label> labels, int barSize, int labelDistance, int subIntervals, float intervalWidth, Font pdfFont, float leftLabelMargin, float rightLabelMargin, float maxLabelWidth, float maxLabelHeight) {
        switch (type) {
            case BAR: {
                return new BarScalebarDrawer(customBlocks, block, labels, barSize, labelDistance, subIntervals, intervalWidth, pdfFont, leftLabelMargin, rightLabelMargin, maxLabelWidth, maxLabelHeight);
            }
            case BAR_SUB: {
                return new BarSubScalebarDrawer(customBlocks, block, labels, barSize, labelDistance, subIntervals, intervalWidth, pdfFont, leftLabelMargin, rightLabelMargin, maxLabelWidth, maxLabelHeight);
            }
            case LINE: {
                return new LineScalebarDrawer(customBlocks, block, labels, barSize, labelDistance, subIntervals, intervalWidth, pdfFont, leftLabelMargin, rightLabelMargin, maxLabelWidth, maxLabelHeight);
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderImpl(Rectangle rectangle, PdfContentByte dc) {
        dc.saveState();
        try {
            AffineTransform rotate = this.getRotationTransform(this.block.getBarDirection());
            AffineTransform labelTransform = AffineTransform.getTranslateInstance((double)rectangle.getLeft(), (double)rectangle.getBottom());
            labelTransform.concatenate(rotate);
            labelTransform.translate((double)this.leftLabelMargin, (double)this.maxLabelHeight);
            dc.transform(labelTransform);
            dc.setColorStroke(this.block.getColorVal());
            dc.setFontAndSize(this.pdfFont.getCalculatedBaseFont(false), this.pdfFont.getSize());
            this.drawLabels(dc);
            dc.restoreState();
            dc.saveState();
            AffineTransform lineTransform = AffineTransform.getTranslateInstance((double)rectangle.getLeft(), (double)rectangle.getBottom());
            lineTransform.concatenate(rotate);
            lineTransform.translate((double)this.leftLabelMargin, (double)((float)this.labelDistance + this.maxLabelHeight));
            dc.transform(lineTransform);
            dc.setLineWidth((float)this.block.getLineWidth());
            dc.setColorStroke(this.block.getColorVal());
            this.drawBar(dc);
        }
        finally {
            dc.restoreState();
        }
    }

    private AffineTransform getRotationTransform(Direction direction) {
        AffineTransform rotate;
        switch (direction) {
            case UP: {
                rotate = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case DOWN: {
                rotate = new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, this.getTotalWidth(), this.getTotalHeight());
                break;
            }
            case LEFT: {
                rotate = new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, this.getTotalHeight(), 0.0f);
                break;
            }
            case RIGHT: {
                rotate = new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.getTotalWidth());
                break;
            }
            default: {
                throw new RuntimeException("Unknown orientation: " + (Object)((Object)direction));
            }
        }
        return rotate;
    }

    private float getTotalWidth() {
        return this.intervalWidth * (float)this.block.getIntervals() + this.leftLabelMargin + this.rightLabelMargin;
    }

    private float getTotalHeight() {
        return (float)(this.barSize + this.labelDistance) + this.maxLabelHeight;
    }

    private void drawLabels(PdfContentByte dc) {
        float prevPos = this.getTotalWidth();
        for (int i = this.labels.size() - 1; i >= 0; --i) {
            float offsetV;
            float offsetH;
            Label label = this.labels.get(i);
            if (this.block.getTextDirection().getAngle() == this.block.getBarDirection().getAngle()) {
                offsetH = -label.width / 2.0f;
                offsetV = -this.maxLabelHeight;
            } else if (this.block.getTextDirection().getAngle() == -this.block.getBarDirection().getAngle()) {
                offsetH = label.width / 2.0f;
                offsetV = 0.0f;
            } else if (this.block.getTextDirection().getAngle() - this.block.getBarDirection().getAngle() < 0.0) {
                offsetH = label.width / 2.0f;
                offsetV = -label.height;
            } else {
                offsetH = -label.width / 2.0f;
                offsetV = 0.0f;
            }
            if (label.paperOffset + Math.abs(offsetH) <= prevPos - 1.0f) {
                dc.beginText();
                dc.showTextAligned(0, label.label, label.paperOffset + offsetH, offsetV, (float)(this.block.getBarDirection().getAngle() - this.block.getTextDirection().getAngle()));
                dc.endText();
                prevPos = label.paperOffset - Math.abs(offsetH);
                continue;
            }
            label.label = null;
        }
    }

    protected abstract void drawBar(PdfContentByte var1);
}

