/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;

public class TotalPageNum {
    private static final String SAMPLE_VALUE = "999";
    private PdfTemplate totalPageNum;
    private final BaseFont totalPageNumFont;
    private final float totalPageNumFontSize;
    private PdfContentByte dc;

    public TotalPageNum(PdfWriter writer, Font font) {
        this.dc = writer.getDirectContent();
        this.totalPageNumFont = font.getCalculatedBaseFont(false);
        this.totalPageNumFontSize = font.getSize();
    }

    public Chunk createPlaceHolder() throws BadElementException {
        float width = this.totalPageNumFont.getWidthPoint(SAMPLE_VALUE, this.totalPageNumFontSize);
        float height = this.totalPageNumFont.getAscentPoint(SAMPLE_VALUE, this.totalPageNumFontSize) - this.totalPageNumFont.getDescentPoint(SAMPLE_VALUE, this.totalPageNumFontSize);
        if (this.totalPageNum == null) {
            this.totalPageNum = this.dc.createTemplate(width, height);
        }
        Image image = Image.getInstance((PdfTemplate)this.totalPageNum);
        return new Chunk(image, 0.0f, 0.0f, true);
    }

    public void render(PdfWriter writer) {
        this.totalPageNum.beginText();
        this.totalPageNum.setFontAndSize(this.totalPageNumFont, this.totalPageNumFontSize);
        this.totalPageNum.setTextMatrix(0.0f, 0.0f);
        this.totalPageNum.showText(String.valueOf(writer.getPageNumber() - 1));
        this.totalPageNum.endText();
    }
}

