/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.PrintException;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.FileUtilities;
import org.pvalsecc.opts.GetOptions;
import org.pvalsecc.opts.InvalidOption;
import org.pvalsecc.opts.Option;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ShellMapPrinter {
    public static final Logger LOGGER = Logger.getLogger(ShellMapPrinter.class);
    public static final String DEFAULT_SPRING_CONTEXT = "mapfish-spring-application-context.xml";
    @Option(desc="Filename for the configuration (templates&CO)", mandatory=true)
    private String config = null;
    @Option(desc="The location of the description of what has to be printed. By default, STDIN")
    private String spec = null;
    @Option(desc="Used only if log4jConfig is not specified. 3 if you want everything, 2 if you want the debug information (stacktraces are shown), 1 for infos and 0 for only warnings and errors")
    private int verbose = 1;
    @Option(desc="The destination file. By default, STDOUT")
    private String output = null;
    @Option(desc="Get the config for the client form. Doesn't generate a PDF")
    private boolean clientConfig = false;
    @Option(desc="Referer address to use when doing queries")
    private String referer = null;
    @Option(desc="Cookie to use when doing queries")
    private String cookie = null;
    @Option(desc="Property file for the log4j configuration")
    private String log4jConfig = null;
    @Option(desc="Spring configuration file to use in addition to the default.  This allows overriding certain values if desired")
    private String springConfig = null;
    private AbstractXmlApplicationContext context;

    public ShellMapPrinter(String[] args) throws IOException {
        try {
            GetOptions.parse(args, this);
        }
        catch (InvalidOption invalidOption) {
            this.help(invalidOption.getMessage());
        }
        this.configureLogs();
        this.context = new ClassPathXmlApplicationContext(DEFAULT_SPRING_CONTEXT);
        if (this.springConfig != null) {
            this.context = new ClassPathXmlApplicationContext(new String[]{DEFAULT_SPRING_CONTEXT, this.springConfig});
        }
    }

    private void help(String message) {
        System.err.println(message);
        System.err.println();
        System.err.println("Usage:");
        System.err.println("  " + this.getClass().getName() + " " + GetOptions.getShortList(this));
        System.err.println("Params:");
        try {
            System.err.println(GetOptions.getLongList(this));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.err);
        }
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, JSONException, DocumentException, InterruptedException {
        MapPrinter printer = (MapPrinter)this.context.getBean(MapPrinter.class);
        printer.setYamlConfigFile(new File(this.config));
        OutputStream outFile = null;
        try {
            if (this.clientConfig) {
                outFile = this.getOutputStream("");
                OutputStreamWriter writer = new OutputStreamWriter(outFile, Charset.forName("UTF-8"));
                JSONWriter json = new JSONWriter((Writer)writer);
                json.object();
                printer.printClientConfig(json);
                json.endObject();
                writer.close();
            } else {
                InputStream inFile = this.getInputStream();
                PJsonObject jsonSpec = MapPrinter.parseSpec(FileUtilities.readWholeTextStream(inFile, "UTF-8"));
                outFile = this.getOutputStream(printer.getOutputFormat(jsonSpec).getFileSuffix());
                HashMap<String, String> headers = new HashMap<String, String>();
                if (this.referer != null) {
                    headers.put("Referer", this.referer);
                }
                if (this.cookie != null) {
                    headers.put("Cookie", this.cookie);
                }
                printer.print(jsonSpec, outFile, headers);
            }
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
            if (this.context != null) {
                this.context.destroy();
            }
        }
    }

    private void configureLogs() {
        if (this.log4jConfig != null) {
            PropertyConfigurator.configure((String)this.log4jConfig);
        } else {
            URL log4jProp;
            ClassLoader classLoader = ShellMapPrinter.class.getClassLoader();
            switch (this.verbose) {
                case 0: {
                    log4jProp = classLoader.getResource("shell-quiet-log4j.properties");
                    break;
                }
                case 1: {
                    log4jProp = classLoader.getResource("shell-info-log4j.properties");
                    break;
                }
                case 2: {
                    log4jProp = classLoader.getResource("shell-default-log4j.properties");
                    break;
                }
                case 3: {
                    log4jProp = classLoader.getResource("shell-verbose-log4j.properties");
                    break;
                }
                default: {
                    log4jProp = classLoader.getResource("shell-default-log4j.properties");
                }
            }
            PropertyConfigurator.configure((URL)log4jProp);
        }
    }

    private OutputStream getOutputStream(String suffix) throws FileNotFoundException {
        OutputStream outFile;
        if (this.output != null) {
            if (!this.output.endsWith("." + suffix)) {
                this.output = this.output + "." + suffix;
            }
            outFile = new FileOutputStream(this.output);
        } else {
            outFile = System.out;
        }
        return outFile;
    }

    private InputStream getInputStream() throws FileNotFoundException {
        InputStream file = this.spec != null ? new FileInputStream(this.spec) : System.in;
        return file;
    }

    public static void main(String[] args) throws IOException, JSONException, DocumentException, InterruptedException {
        ShellMapPrinter app = new ShellMapPrinter(args);
        try {
            app.run();
        }
        catch (PrintException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Cannot generate PDF", (Throwable)e);
            } else {
                LOGGER.error((Object)e.toString());
            }
            System.exit(-2);
        }
    }
}

