/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.repository.MetadataRepository;

public class LuceneIndexHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(final ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected HealthCheck.Result check() throws Exception {
                GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
                SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
                MetadataRepository metadataRepository = (MetadataRepository)gc.getBean(MetadataRepository.class);
                IndexAndTaxonomy indexAndTaxonomy = searchMan.getNewIndexReader(null);
                GeonetworkMultiReader reader = indexAndTaxonomy.indexReader;
                try {
                    MatchAllDocsQuery query = new MatchAllDocsQuery();
                    TopDocs hits = new IndexSearcher((IndexReader)reader).search((Query)query, 1);
                    if (hits.totalHits > 1 || metadataRepository.count() == 0L) {
                        HealthCheck.Result result = HealthCheck.Result.healthy();
                        return result;
                    }
                    HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Lucene search for 1 record returned " + hits.totalHits + " hits."));
                    return result;
                }
                catch (Throwable e) {
                    HealthCheck.Result result = HealthCheck.Result.unhealthy((Throwable)e);
                    return result;
                }
                finally {
                    searchMan.releaseIndexReader(indexAndTaxonomy);
                }
            }
        };
    }
}

