/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Arrays;
import java.util.List;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.SchematronCriteriaEvaluator;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.XPathCriteriaEvaluator;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public enum SchematronCriteriaType {
    GROUP(new SchematronCriteriaEvaluator(){

        @Override
        public boolean accepts(ApplicationContext applicationContext, String value, int metadataId, Element metadata, List<Namespace> metadataNamespaces) {
            String[] values = value.split(",");
            Integer[] ids = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ids[i] = Integer.valueOf(values[i]);
            }
            Specification<? extends AbstractMetadata> correctOwnerDraft = MetadataSpecs.isOwnedByOneOfFollowingGroups(Arrays.asList(ids));
            Specification<? extends AbstractMetadata> correctIdDraft = MetadataSpecs.hasMetadataId(metadataId);
            Specifications finalSpecDraft = Specifications.where(correctIdDraft).and(correctOwnerDraft);
            Specification<? extends AbstractMetadata> correctOwner = MetadataSpecs.isOwnedByOneOfFollowingGroups(Arrays.asList(ids));
            Specification<? extends AbstractMetadata> correctId = MetadataSpecs.hasMetadataId(metadataId);
            Specifications finalSpec = Specifications.where(correctId).and(correctOwner);
            return ((MetadataRepository)applicationContext.getBean(MetadataRepository.class)).count((Specification)finalSpec) + ((MetadataDraftRepository)applicationContext.getBean(MetadataDraftRepository.class)).count((Specification)finalSpecDraft) > 0L;
        }

        @Override
        public boolean accepts(ApplicationContext applicationContext, String value, Element metadata, List<Namespace> metadataNamespaces, Integer metadataGroupOwner) {
            String[] values = value.split(",");
            Integer[] ids = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ids[i] = Integer.valueOf(values[i]);
            }
            return Arrays.asList(ids).contains(metadataGroupOwner);
        }
    }),
    USER_MAIN_PROFILE(new SchematronCriteriaEvaluator(){

        @Override
        public boolean accepts(ApplicationContext applicationContext, String value, int metadataId, Element metadata, List<Namespace> metadataNamespaces) {
            Object principal;
            String[] values = value.split(",");
            List<String> profiles = Arrays.asList(values);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && (principal = authentication.getPrincipal()) instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)principal;
                UserRepository userRepo = (UserRepository)applicationContext.getBean(UserRepository.class);
                User user = userRepo.findOneByUsername(userDetails.getUsername());
                if (profiles.contains(user.getProfile().name())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean accepts(ApplicationContext applicationContext, String value, Element metadata, List<Namespace> metadataNamespaces, Integer metadataGroupOwner) {
            return this.accepts(applicationContext, value, -1, metadata, metadataNamespaces);
        }
    }),
    ALWAYS_ACCEPT(new SchematronCriteriaEvaluator(){

        @Override
        public boolean accepts(ApplicationContext applicationContext, String value, int metadataId, Element metadata, List<Namespace> metadataNamespaces) {
            return true;
        }

        @Override
        public boolean accepts(ApplicationContext applicationContext, String value, Element metadata, List<Namespace> metadataNamespaces, Integer metadataGroupOwner) {
            return true;
        }
    }),
    XPATH(XPathCriteriaEvaluator.INSTANCE);

    private final SchematronCriteriaEvaluator evaluator;

    private SchematronCriteriaType(SchematronCriteriaEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public boolean accepts(ApplicationContext applicationContext, String value, int metadataId, Element metadata, List<Namespace> metadataNamespaces) {
        return this.evaluator.accepts(applicationContext, value, metadataId, metadata, metadataNamespaces);
    }

    public boolean accepts(ApplicationContext applicationContext, String value, Element metadata, List<Namespace> metadataNamespaces, Integer groupOwnerId) {
        return this.evaluator.accepts(applicationContext, value, metadata, metadataNamespaces, groupOwnerId);
    }
}

