/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.fao.geonet.domain.XmlEmbeddable;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

@Embeddable
@XmlRootElement
public class ISODate
implements Cloneable,
Comparable<ISODate>,
Serializable,
XmlEmbeddable {
    private static final String DEFAULT_DATE_TIME = "3000-01-01T00:00:00.000Z";
    @XmlTransient
    private static Pattern gsYear = Pattern.compile("([0-9]{4})(-([0-2][0-9]):([0-5][0-9])([A-Z]))?");
    @XmlTransient
    private static Pattern gsYearMonth = Pattern.compile("([0-9]{4})-([0-1][0-9])(-([0-2][0-9]):([0-5][0-9])([A-Z]))?");
    @XmlTransient
    private static Pattern htmlFormat = Pattern.compile("([a-zA-Z]{3}) ([a-zA-Z]{3}) ([0-9]{2}) ([0-9]{4}) ([0-2][0-9]):([0-5][0-9]):([0-5][0-9]) (.+)");
    @XmlTransient
    private boolean _shortDate;
    @XmlTransient
    private boolean _shortDateYear;
    @XmlTransient
    private boolean _shortDateYearMonth;
    @XmlTransient
    private Calendar _calendar = Calendar.getInstance();

    public ISODate() {
    }

    public ISODate(long time, boolean shortDate) {
        this._calendar.setTimeInMillis(time);
        this._shortDate = shortDate;
    }

    public ISODate(long time) {
        this._calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this._calendar.setTimeInMillis(time);
        this._shortDate = false;
    }

    public ISODate(@Nonnull String isoDate) {
        this.setDateAndTime(isoDate);
    }

    public static String parseISODateTime(String stringToParse) {
        String newDateTime = ISODate.parseISODateTimes(stringToParse, null);
        if (newDateTime.equals(DEFAULT_DATE_TIME)) {
            return null;
        }
        return newDateTime;
    }

    public static String parseISODateTimes(String input1, String input2) {
        DateTime odt1;
        DateTimeFormatter dto = ISODateTimeFormat.dateTime();
        PeriodFormatter p = ISOPeriodFormat.standard();
        String odt = "";
        try {
            DateTime idt = ISODate.parseBasicOrFullDateTime(input1);
            odt1 = dto.parseDateTime(idt.toString()).withZone(DateTimeZone.forID((String)"UTC"));
            odt = odt1.toString();
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.domain", (Object)("Error parsing ISO DateTimes, error: " + e.getMessage()), (Throwable)e);
            return DEFAULT_DATE_TIME;
        }
        if (input2 == null || input2.equals("")) {
            return odt;
        }
        try {
            boolean minus = false;
            if (input2.startsWith("-P")) {
                input2 = input2.substring(1);
                minus = true;
            }
            if (input2.startsWith("P")) {
                Period ip = p.parsePeriod(input2);
                DateTime odt2 = !minus ? odt1.plus(ip.toStandardDuration().getMillis()) : odt1.minus(ip.toStandardDuration().getMillis());
                odt = odt + "|" + odt2.toString();
            } else {
                DateTime idt = ISODate.parseBasicOrFullDateTime(input2);
                DateTime odt2 = dto.parseDateTime(idt.toString()).withZone(DateTimeZone.forID((String)"UTC"));
                odt = odt + "|" + odt2.toString();
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.domain", (Object)("Error parsing ISO DateTimes, error: " + e.getMessage()), (Throwable)e);
            return odt + "|" + DEFAULT_DATE_TIME;
        }
        return odt;
    }

    public static DateTime parseBasicOrFullDateTime(String input1) throws Exception {
        DateTime idt;
        DateTimeFormatter bd = ISODateTimeFormat.basicDate();
        DateTimeFormatter bt = ISODateTimeFormat.basicTime();
        DateTimeFormatter bdt = ISODateTimeFormat.basicDateTime();
        DateTimeFormatter dtp = ISODateTimeFormat.dateTimeParser();
        if (input1.length() == 8 && !input1.startsWith("T")) {
            idt = bd.parseDateTime(input1);
        } else if (input1.startsWith("T") && !input1.contains(":")) {
            idt = bt.parseDateTime(input1);
        } else if (input1.contains("T") && !input1.contains(":") && !input1.contains("-")) {
            idt = bdt.parseDateTime(input1);
        } else {
            Matcher matcher = gsYearMonth.matcher(input1);
            if (matcher.matches()) {
                String year = matcher.group(1);
                String month = matcher.group(2);
                String minute = "00";
                String hour = "00";
                String timezone = "Z";
                if (matcher.group(4) != null) {
                    minute = matcher.group(5);
                    hour = matcher.group(4);
                    timezone = matcher.group(6);
                }
                idt = ISODate.generateDate(year, month, minute, hour, timezone);
            } else {
                matcher = gsYear.matcher(input1);
                if (matcher.matches()) {
                    String year = matcher.group(1);
                    String month = "01";
                    String minute = "00";
                    String hour = "00";
                    String timezone = "Z";
                    if (matcher.group(3) != null) {
                        minute = matcher.group(4);
                        hour = matcher.group(3);
                        timezone = matcher.group(5);
                    }
                    idt = ISODate.generateDate(year, month, minute, hour, timezone);
                } else {
                    matcher = htmlFormat.matcher(input1);
                    if (matcher.matches()) {
                        String month;
                        switch (month = matcher.group(2)) {
                            case "Jan": {
                                month = "1";
                                break;
                            }
                            case "Feb": {
                                month = "2";
                                break;
                            }
                            case "Mar": {
                                month = "3";
                                break;
                            }
                            case "Apr": {
                                month = "4";
                                break;
                            }
                            case "May": {
                                month = "5";
                                break;
                            }
                            case "Jun": {
                                month = "6";
                                break;
                            }
                            case "Jul": {
                                month = "7";
                                break;
                            }
                            case "Aug": {
                                month = "8";
                                break;
                            }
                            case "Sep": {
                                month = "9";
                                break;
                            }
                            case "Oct": {
                                month = "10";
                                break;
                            }
                            case "Nov": {
                                month = "11";
                                break;
                            }
                            default: {
                                month = "12";
                            }
                        }
                        String day = matcher.group(3);
                        String year = matcher.group(4);
                        String hour = matcher.group(5);
                        String minute = matcher.group(6);
                        String second = matcher.group(7);
                        String timezone = matcher.group(8);
                        idt = ISODate.generateDate(year, month, day, second, minute, hour, timezone);
                    } else {
                        idt = dtp.parseDateTime(input1);
                    }
                }
            }
        }
        return idt;
    }

    private static DateTime generateDate(String year, String month, String day, String second, String minute, String hour, String timezone) {
        Calendar c = Calendar.getInstance();
        c.set(1, Integer.valueOf(year));
        c.set(2, Integer.valueOf(month) - 1);
        c.set(5, Integer.valueOf(day));
        c.set(13, Integer.valueOf(second));
        c.set(14, 0);
        c.set(11, Integer.valueOf(hour));
        c.set(12, Integer.valueOf(minute));
        TimeZone zone = TimeZone.getTimeZone(timezone);
        c.setTimeZone(zone);
        return new DateTime(c.getTimeInMillis());
    }

    private static DateTime generateDate(String year, String month, String minute, String hour, String timezone) {
        return ISODate.generateDate(year, month, "1", "00", minute, hour, timezone);
    }

    public ISODate clone() {
        try {
            ISODate clone = (ISODate)super.clone();
            clone._calendar = (Calendar)this._calendar.clone();
            clone._shortDate = this._shortDate;
            clone._shortDateYear = this._shortDateYear;
            clone._shortDateYearMonth = this._shortDateYearMonth;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return new ISODate(this._calendar.getTimeInMillis(), this._shortDate);
        }
    }

    public long timeDifferenceInSeconds(ISODate date) {
        return this.getTimeInSeconds() - date.getTimeInSeconds();
    }

    @Transient
    public String getDateAsString() {
        if (this._shortDateYearMonth) {
            return this.getYears() + "-" + this.pad(this.getMonths());
        }
        if (this._shortDateYear) {
            return this.getYears() + "";
        }
        return this.getYears() + "-" + this.pad(this.getMonths()) + "-" + this.pad(this.getDays());
    }

    public String toString() {
        return this.getDateAndTime();
    }

    public Date toDate() {
        return (Date)this._calendar.getTime().clone();
    }

    @Transient
    public long getTimeInSeconds() {
        return this._calendar.getTimeInMillis() / 1000L;
    }

    @XmlValue
    public String getDateAndTime() {
        if (this._shortDate || this._shortDateYearMonth || this._shortDateYear) {
            return this.getDateAsString();
        }
        return this.getDateAsString() + "T" + this.getTimeAsString();
    }

    public void setDateAndTime(String isoDate) {
        String[] parts;
        String timeAndDate = isoDate;
        if (timeAndDate == null) {
            throw new IllegalArgumentException("date string is null");
        }
        int indexOfT = timeAndDate.indexOf(84);
        if (indexOfT > -1) {
            boolean timeZoneInfo;
            String afterT = timeAndDate.substring(indexOfT + 1);
            boolean bl = timeZoneInfo = afterT.contains("+") || afterT.contains("-") || afterT.toUpperCase().endsWith("Z");
            if (timeZoneInfo) {
                timeAndDate = ISODate.parseISODateTime(timeAndDate);
            }
        }
        if ((parts = timeAndDate.toUpperCase().split("T", 2)).length == 1) {
            if (parts[0].contains(":")) {
                this.parseTime(parts[0]);
            } else {
                this.parseDate(parts[0]);
            }
        } else {
            if (!parts[0].trim().isEmpty()) {
                this.parseDate(parts[0]);
            }
            if (!parts[1].trim().isEmpty()) {
                this.parseTime(parts[1]);
            }
        }
    }

    @Transient
    public boolean isDateOnly() {
        return this._shortDate;
    }

    @Transient
    public boolean isDateYearOnly() {
        return this._shortDateYear;
    }

    @Transient
    public boolean isDateYearMonthOnly() {
        return this._shortDateYearMonth;
    }

    @Transient
    public int getYears() {
        return this._calendar.get(1);
    }

    @Transient
    public int getDays() {
        return this._calendar.get(5);
    }

    @Transient
    public int getMonths() {
        return this._calendar.get(2) + 1;
    }

    @Transient
    public int getHours() {
        return this._calendar.get(11);
    }

    @Transient
    public int getMinutes() {
        return this._calendar.get(12);
    }

    @Transient
    public int getSeconds() {
        return this._calendar.get(13);
    }

    public int hashCode() {
        return this.getTimeAsString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISODate other = (ISODate)obj;
        return this.getTimeAsString().equals(other.getTimeAsString());
    }

    private void parseDate(@Nonnull String isoDate) {
        try {
            int day;
            int year;
            String[] parts = isoDate.split("-|/");
            if (parts.length == 0 || parts.length > 3) {
                throw new IllegalArgumentException("Invalid ISO date : " + isoDate);
            }
            this._shortDate = parts.length == 3;
            this._shortDateYearMonth = parts.length == 2;
            boolean bl = this._shortDateYear = parts.length == 1;
            if (parts[0].length() < 4) {
                int shortYear = Integer.parseInt(parts[0]);
                String thisYear = String.valueOf(Calendar.getInstance().get(1));
                int century = Integer.parseInt(thisYear.substring(0, 2)) * 100;
                int yearInCentury = Integer.parseInt(thisYear.substring(2));
                year = shortYear <= yearInCentury ? century + shortYear : century - 100 + shortYear;
            } else {
                year = Integer.parseInt(parts[0]);
            }
            int month = this._shortDate || this._shortDateYearMonth ? Integer.parseInt(parts[1]) : 12;
            if (this._shortDate) {
                day = parts[2].toLowerCase().endsWith("z") ? Integer.parseInt(parts[2].substring(0, parts[2].length() - 1)) : Integer.parseInt(parts[2]);
            } else {
                this._calendar.set(year, month - 1, 1);
                day = this._calendar.getActualMaximum(5);
            }
            this._shortDate = true;
            int hour = 0;
            int minute = 0;
            int second = 0;
            this._calendar.set(year, month - 1, day, hour, minute, second);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ISO date : " + isoDate, e);
        }
    }

    private void parseTime(@Nonnull String isoDate) {
        try {
            String[] parts = isoDate.split(":");
            if (parts.length == 1 || parts.length > 3) {
                throw new IllegalArgumentException("Invalid ISO date : " + isoDate);
            }
            int hour = Integer.parseInt(parts[0]);
            int minute = Integer.parseInt(parts[1]);
            int second = 0;
            if (parts.length == 3) {
                String secondsToParse = parts[2];
                int indexOfZ = secondsToParse.toUpperCase().indexOf(90);
                if (indexOfZ > -1) {
                    secondsToParse = secondsToParse.substring(0, indexOfZ);
                    this._calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                }
                second = (int)Float.parseFloat(secondsToParse);
            }
            this._calendar.set(11, hour);
            this._calendar.set(12, minute);
            this._calendar.set(13, second);
            this._shortDate = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ISO date : " + isoDate, e);
        }
    }

    @Transient
    public String getTimeAsString() {
        return this.pad(this.getHours()) + ":" + this.pad(this.getMinutes()) + ":" + this.pad(this.getSeconds());
    }

    private String pad(int value) {
        if (value > 9) {
            return Integer.toString(value);
        }
        return "0" + value;
    }

    @Override
    public int compareTo(ISODate o) {
        return this._calendar.compareTo(o._calendar);
    }

    @Override
    public void addToXml(Element element) {
        if (this.isDateOnly()) {
            element.addContent(this.getDateAsString());
        } else {
            element.addContent(this.getDateAndTime());
        }
    }
}

