/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources.handlers;

import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.services.resources.handlers.IResourceRemoveHandler;
import org.fao.geonet.services.resources.handlers.ResourceHandlerException;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.dao.EmptyResultDataAccessException;

public class DefaultResourceRemoveHandler
implements IResourceRemoveHandler {
    @Override
    public void onDelete(ServiceContext context, Element params, int metadataId, String fileName, String access) throws ResourceHandlerException {
        try {
            FilePathChecker.verify((String)fileName);
            this.doDelete(context, metadataId, fileName);
            this.storeFileUploadDeleteRequest(context, metadataId, fileName);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (Object)("DefaultResourceRemoveHandler (onDelete): " + ex.getMessage()), (Throwable)ex);
            throw new ResourceHandlerException(ex);
        }
    }

    private void storeFileUploadDeleteRequest(ServiceContext context, int metadataId, String fileName) {
        MetadataFileUploadRepository repo = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
        try {
            MetadataFileUpload metadataFileUpload = repo.findByMetadataIdAndFileNameNotDeleted(metadataId, fileName);
            metadataFileUpload.setDeletedDate(new ISODate().toString());
            repo.save((Object)metadataFileUpload);
        }
        catch (EmptyResultDataAccessException ex) {
            Log.warning((String)"geonetwork.resources", (Object)("Delete file upload request: No upload request for (metadataid, file): (" + metadataId + "," + fileName + ")"));
        }
    }

    @Override
    public void onDelete(ServiceContext context, HttpServletRequest request, int metadataId, String fileName, String access) throws ResourceHandlerException {
        try {
            FilePathChecker.verify((String)fileName);
            this.doDelete(context, metadataId, fileName);
            this.storeFileUploadDeleteRequest(context, metadataId, fileName);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (Object)("DefaultResourceRemoveHandler (onDelete): " + ex.getMessage()), (Throwable)ex);
            throw new ResourceHandlerException(ex);
        }
    }

    private void doDelete(ServiceContext context, int metadataId, String fileName) throws Exception {
        Store store = (Store)context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        String uuid = metadataUtils.getMetadataUuid(Integer.toString(metadataId));
        store.delResource(context, uuid, fileName);
    }
}

