/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.nio.file.Path;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.Utils;
import org.fao.geonet.services.metadata.ShowViewBaseService;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class View
extends ShowViewBaseService {
    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
        super.init(appPath, params);
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Namespace gmdNs;
        Element elMd;
        Element elCurrTab;
        UserSession session = context.getUserSession();
        boolean witholdWithheldElements = Util.getParam((Element)params, (String)"hide_withheld", (boolean)false);
        if (witholdWithheldElements) {
            XmlSerializer.getThreadLocal((boolean)true).setForceFilterEditOperation(witholdWithheldElements);
        }
        if ((elCurrTab = params.getChild("currTab")) != null) {
            session.setProperty("metadata.show", (Object)elCurrTab.getText());
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        String id = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
        if (!this.skipPopularity) {
            String skip = Util.getParam((Element)params, (String)"skipPopularity", (String)"n");
            this.skipPopularity = skip.equals("y");
        }
        if (id == null) {
            throw new MetadataNotFoundEx("Metadata not found.");
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        boolean addEditing = false;
        if (!this.skipInfo) {
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            elMd = dm.getMetadata(context, id, addEditing, withValidationErrors, keepXlinkAttributes);
        } else {
            elMd = dm.getMetadataNoInfo(context, id);
        }
        if (elMd == null) {
            throw new MetadataNotFoundEx(id);
        }
        if (this.addRefs) {
            elMd = dm.enumerateTree(elMd);
        }
        if (elMd.getAttribute("schemaLocation", Csw.NAMESPACE_XSI) == null && (gmdNs = elMd.getNamespace("gmd")) != null && gmdNs.getURI().equals("http://www.isotc211.org/2005/gmd")) {
            String schemaLocation = elMd.getNamespace("srv") != null ? " http://www.isotc211.org/2005/srv http://schemas.opengis.net/iso/19139/20060504/srv/srv.xsd" : "http://www.isotc211.org/2005/gmd http://www.isotc211.org/2005/gmd/gmd.xsd";
            Attribute schemaLocationA = new Attribute("schemaLocation", schemaLocation, Csw.NAMESPACE_XSI);
            elMd.setAttribute(schemaLocationA);
        }
        if (!this.skipPopularity) {
            dm.increasePopularity(context, id);
        }
        return elMd;
    }
}

