/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.mef.Importer;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Insert
extends NotInReadOnlyModeService {
    private Path stylePath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xsl/conversion/import");
    }

    public Element serviceSpecificExec(Element params, final ServiceContext context) throws Exception {
        boolean hasCategory;
        String uuid;
        String schema;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        String data = Util.getParam((Element)params, (String)"data");
        String group = Util.getParam((Element)params, (String)"group");
        MetadataType metadataType = MetadataType.lookup((String)Util.getParam((Element)params, (String)"template", (String)"n"));
        String style = Util.getParam((Element)params, (String)"styleSheet", (String)"_none_");
        boolean validate = Util.getParam((Element)params, (String)"validate", (String)"off").equals("on");
        Element xml = Xml.loadString((String)data, (boolean)false);
        if (!style.equals("_none_")) {
            FilePathChecker.verify((String)style);
            xml = Xml.transform((Element)xml, (Path)this.stylePath.resolve(style));
        }
        if ((schema = Util.getParam((Element)params, (String)"schema", null)) == null && (schema = dataMan.autodetectSchema(xml)) == null) {
            throw new BadParameterEx("Can't detect schema for metadata automatically.", (Object)"schema is unknown");
        }
        if (validate) {
            DataManager.validateExternalMetadata((String)schema, (Element)xml, (ServiceContext)context, (Integer)Integer.parseInt(group));
        }
        if (metadataType == MetadataType.SUB_TEMPLATE) {
            uuid = UUID.randomUUID().toString();
        } else {
            uuid = dataMan.extractUUID(schema, xml);
            if (uuid.length() == 0) {
                uuid = UUID.randomUUID().toString();
                xml = dataMan.setUUID(schema, uuid, xml);
            }
        }
        String uuidAction = Util.getParam((Element)params, (String)"uuidAction", (String)"nothing");
        String date = new ISODate().toString();
        ArrayList id = new ArrayList();
        ArrayList<Element> md = new ArrayList<Element>();
        md.add(xml);
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        HashMap sourceTranslations = Maps.newHashMap();
        Importer.importRecord((String)uuid, (MEFLib.UuidAction)MEFLib.UuidAction.parse((String)uuidAction), md, (String)schema, (int)0, (String)((SettingManager)gc.getBean(SettingManager.class)).getSiteId(), (String)((SettingManager)gc.getBean(SettingManager.class)).getSiteName(), (Map)sourceTranslations, (ServiceContext)context, id, (String)date, (String)date, (String)group, (MetadataType)metadataType);
        int iId = Integer.parseInt((String)id.get(0));
        dm.setTemplate(iId, metadataType, null);
        dm.activateWorkflowIfConfigured(context, (String)id.get(0), group);
        final String category = Util.getParam((Element)params, (String)"category", (String)"");
        final String extra = Util.getParam((Element)params, (String)"extra", null);
        boolean bl = hasCategory = !category.equals("_none_") && !category.trim().isEmpty();
        if (hasCategory || extra != null) {
            ((IMetadataManager)context.getBean(IMetadataManager.class)).update(iId, (Updater)new Updater<Metadata>(){

                public void apply(@Nonnull Metadata metadata) {
                    if (hasCategory) {
                        Element categs = new Element("categories");
                        categs.addContent((Content)new Element("category").setAttribute("name", category));
                        Importer.addCategoriesToMetadata((AbstractMetadata)metadata, (Element)categs, (ServiceContext)context);
                    }
                    if (extra != null) {
                        metadata.getDataInfo().setExtra(extra);
                    }
                }
            });
        }
        dm.indexMetadata((String)id.get(0), true, null);
        Element response = new Element("response");
        response.addContent((Content)new Element("id").setText(String.valueOf(iId)));
        response.addContent((Content)new Element("uuid").setText(String.valueOf(dm.getMetadataUuid((String)id.get(0)))));
        return response;
    }
}

