/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.utils.Log;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class SearchSuggestion
implements Service {
    static final String RECORDS_FIELD_VALUES = "RECORDS_FIELD_VALUES";
    static final String INDEX_TERM_VALUES = "INDEX_TERM_VALUES";
    static final String PARAM_ORIGIN = "origin";
    static final String PARAM_FIELD = "field";
    static final String PARAM_Q = "q";
    static final String PARAM_MAX_NUMBER_OF_TERMS = "maxNumberOfTerms";
    static final String PARAM_THRESHOLD = "threshold";
    static final String PARAM_SORT_BY = "sortBy";
    static final String ELEM_ITEMS = "items";
    static final String ELEM_ITEM = "item";
    static final String ATT_TERM = "term";
    static final String ATT_FREQ = "freq";
    static final String CONFIG_PARAM_MAX_NUMBER_OF_TERMS = "max_number_of_terms";
    static final String CONFIG_PARAM_DEFAULT_SEARCH_FIELD = "default_search_field";
    static final String CONFIG_PARAM_THRESHOLD = "threshold";
    private static final String SUMMARY_FACET_CONFIG_KEY = "suggestions";
    private Integer _maxNumberOfTerms;
    private Integer _threshold;
    private String _defaultSearchField = "any";
    private ServiceConfig _config;
    private int _defaultSize = 100;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this._threshold = Integer.valueOf(config.getValue("threshold"));
        String maxNumberOfTerms = config.getValue(CONFIG_PARAM_MAX_NUMBER_OF_TERMS);
        this._maxNumberOfTerms = Integer.valueOf(maxNumberOfTerms);
        this._defaultSearchField = config.getValue(CONFIG_PARAM_DEFAULT_SEARCH_FIELD);
        this._config = config;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String fieldName = Util.getParam((Element)params, (String)PARAM_FIELD, (String)this._defaultSearchField);
        int size = Util.getParam((Element)params, (String)"size", (int)this._defaultSize);
        String searchValue = Util.getParam((Element)params, (String)PARAM_Q, (String)"");
        final String searchValueWithoutWildcard = searchValue.replaceAll("[*?]", "");
        String origin = Util.getParam((Element)params, (String)PARAM_ORIGIN, (String)"");
        int maxNumberOfTerms = Util.getParam((Element)params, (String)PARAM_MAX_NUMBER_OF_TERMS, (int)this._maxNumberOfTerms);
        int threshold = Util.getParam((Element)params, (String)"threshold", (int)this._threshold);
        String sortBy = Util.getParam((Element)params, (String)PARAM_SORT_BY, (String)SORT_BY_OPTION.FREQUENCY.toString());
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Autocomplete on field: '" + fieldName + "'\tsearching: '" + searchValue + "'\tthreshold: '" + threshold + "'\tsize: '" + size + "'\tmaxNumberOfTerms: '" + maxNumberOfTerms + "'\tsortBy: '" + sortBy + "'\tfrom: '" + origin + "'"));
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager sm = (SearchManager)gc.getBean(SearchManager.class);
        Element suggestionsResponse = new Element(ELEM_ITEMS);
        TreeSet<Object> listOfSuggestions = sortBy.equalsIgnoreCase(SORT_BY_OPTION.STARTSWITHFIRST.toString()) ? new TreeSet<SearchManager.TermFrequency>(new StartsWithComparator(searchValueWithoutWildcard)) : (sortBy.equalsIgnoreCase(SORT_BY_OPTION.ALPHA.toString()) ? new TreeSet() : new TreeSet<SearchManager.TermFrequency>(new FrequencyComparator()));
        if (origin.equals("") || origin.equals(RECORDS_FIELD_VALUES)) {
            LuceneSearcher searcher = (LuceneSearcher)sm.newSearcher(SearcherType.LUCENE, "lucene.xsl");
            searcher.getSuggestionForFields(context, fieldName, searchValue, this._config, maxNumberOfTerms, threshold, listOfSuggestions);
        }
        if (origin.equals(INDEX_TERM_VALUES) || listOfSuggestions.size() == 0 && origin.equals("")) {
            listOfSuggestions.addAll(sm.getTermsFequency(fieldName, searchValue, maxNumberOfTerms, threshold, context));
        }
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("  Found: " + listOfSuggestions.size() + " suggestions from " + origin + "."));
        }
        suggestionsResponse.setAttribute(new Attribute(PARAM_ORIGIN, origin));
        Collection<Object> collectionOfSuggestions = sortBy.equalsIgnoreCase(SORT_BY_OPTION.STARTSWITHONLY.toString()) ? Collections2.filter(listOfSuggestions, (Predicate)new Predicate<SearchManager.TermFrequency>(){

            public boolean apply(SearchManager.TermFrequency term) {
                return StringUtils.startsWithIgnoreCase((String)term.getTerm(), (String)searchValueWithoutWildcard);
            }
        }) : listOfSuggestions;
        int count = 0;
        for (SearchManager.TermFrequency termFrequency : collectionOfSuggestions) {
            Element md = new Element(ELEM_ITEM);
            md.setAttribute(ATT_TERM, termFrequency.getTerm());
            md.setAttribute(ATT_FREQ, termFrequency.getFrequency() + "");
            suggestionsResponse.addContent((Content)md);
            if (++count < size) continue;
            break;
        }
        return suggestionsResponse;
    }

    public static class FrequencyComparator
    implements Comparator<SearchManager.TermFrequency> {
        @Override
        public int compare(SearchManager.TermFrequency term1, SearchManager.TermFrequency term2) {
            return ComparisonChain.start().compare(term2.getFrequency(), term1.getFrequency()).compare((Comparable)((Object)term1.getTerm()), (Comparable)((Object)term2.getTerm())).result();
        }
    }

    public static class StartsWithComparator
    implements Comparator<SearchManager.TermFrequency> {
        private String prefix = "";

        public StartsWithComparator(String prefix) {
            this.prefix = prefix;
        }

        public int startsWith(String str) {
            return StringUtils.startsWithIgnoreCase((String)str, (String)this.prefix) ? -1 : 1;
        }

        @Override
        public int compare(SearchManager.TermFrequency term1, SearchManager.TermFrequency term2) {
            return ComparisonChain.start().compare(this.startsWith(term1.getTerm()), this.startsWith(term2.getTerm())).compare((Comparable)((Object)term1.getTerm()), (Comparable)((Object)term2.getTerm())).result();
        }
    }

    static enum SORT_BY_OPTION {
        FREQUENCY,
        ALPHA,
        STARTSWITHFIRST,
        STARTSWITHONLY;

    }
}

