/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.base.Optional;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.fao.geonet.Constants;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.Functions;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TRenderContext;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateException;
import org.fao.geonet.api.records.formatters.groovy.template.TextBlock;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.xml.sax.Attributes;

class TNodeTranslate
extends TNode {
    private final Translator translator;

    public TNodeTranslate(SystemInfo info, TextContentParser textContentParser, String qName, Attributes attributes, String key) throws IOException {
        super(info, textContentParser, qName, attributes);
        String context;
        String[] parts = key.split(">");
        String type = parts.length > 1 ? parts[1] : null;
        String string = context = parts.length > 2 ? parts[2] : null;
        if (parts[0].equalsIgnoreCase("codelist")) {
            this.translator = new CodeListTranslator(type, textContentParser, context);
        } else if (parts[0].equalsIgnoreCase("node")) {
            this.translator = new NodeTranslator(type, textContentParser, context);
        } else if (parts[0].equalsIgnoreCase("default") || parts[0].trim().isEmpty()) {
            this.translator = new DefaultTranslator(type, textContentParser);
        } else {
            throw new TemplateException("Translate type: '" + parts[0] + "' is not one of the recognized type: ['', 'default', 'node', 'codelist']");
        }
    }

    @Override
    protected Optional<String> canRender(TRenderContext context) {
        return Optional.absent();
    }

    @Override
    public void setTextContent(String text) throws IOException {
        if (text.isEmpty()) {
            return;
        }
        try {
            this.addChild(new Node(this.info, this.textContentParser, text));
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    private class Node
    extends TNode {
        private final String text;

        public Node(SystemInfo info, TextContentParser parser, String text) throws IOException {
            super(info, parser, "", EMPTY_ATTRIBUTES);
            this.text = text;
        }

        @Override
        protected Optional<String> canRender(TRenderContext context) {
            return Optional.absent();
        }

        @Override
        public void render(TRenderContext context) throws IOException {
            TextBlock block = this.textContentParser.parse(this.text);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            block.render(new TRenderContext(stream, context.getModel(true)));
            try {
                TNodeTranslate.this.translator.translate(new String(stream.toByteArray(), Constants.CHARSET)).render(context);
            }
            catch (Exception e) {
                throw new TemplateException(e);
            }
        }
    }

    private static class DefaultTranslator
    implements Translator {
        private final String file;
        private final TextContentParser textContentParser;

        private DefaultTranslator(String file, TextContentParser parser) {
            this.file = file;
            this.textContentParser = parser;
        }

        @Override
        public TextBlock translate(String text) throws Exception {
            Functions functions = TransformationContext.getContext().getFunctions();
            String translation = functions.translate(text, this.file);
            return this.textContentParser.parse(translation);
        }
    }

    private static class NodeTranslator
    implements Translator {
        private final String type;
        private final String context;
        private final TextContentParser textContentParser;

        private NodeTranslator(String type, TextContentParser parser, String context) {
            this.type = type;
            this.context = context;
            this.textContentParser = parser;
        }

        @Override
        public TextBlock translate(String text) throws Exception {
            Functions functions = TransformationContext.getContext().getFunctions();
            String translation = functions.nodeTranslation(text, this.context, this.type);
            return this.textContentParser.parse(translation);
        }
    }

    private static class CodeListTranslator
    implements Translator {
        private final String type;
        private final String context;
        private final TextContentParser textContentParser;

        private CodeListTranslator(String type, TextContentParser parser, String context) {
            this.type = type;
            this.context = context;
            this.textContentParser = parser;
        }

        @Override
        public TextBlock translate(String text) throws Exception {
            Functions functions = TransformationContext.getContext().getFunctions();
            String translation = functions.codelistTranslation(text, this.context, this.type);
            return this.textContentParser.parse(translation);
        }
    }

    private static interface Translator {
        public TextBlock translate(String var1) throws Exception;
    }
}

