/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.template.AttributesFiltered;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeFactoryByAttName;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeRepeatIter;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeRepeatMap;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;

@Component
public class TNodeFactoryRepeat
extends TNodeFactoryByAttName {
    public static final String REPEAT = "repeat";
    public static final String ONLY_CHILDREN = "repeat-only-children";
    private static final Pattern MAP_PATTERN = Pattern.compile("\\s*\\(\\s*(\\S+)\\s*,\\s*(\\S+)\\s*\\)");

    protected TNodeFactoryRepeat() {
        super(REPEAT, null);
    }

    public TNodeFactoryRepeat(SystemInfo info, TextContentParser contentParser) {
        super(REPEAT, info);
        this.textContentParser = contentParser;
    }

    @Override
    public TNode create(String localName, String qName, Attributes attributes) throws IOException {
        String value = this.getValue(attributes, REPEAT);
        boolean onlyChildren = this.getBooleanAttribute(attributes, ONLY_CHILDREN, false);
        String[] parts = value.split("\\s+in\\s+");
        AttributesFiltered attributesFiltered = new AttributesFiltered(attributes, REPEAT, ONLY_CHILDREN);
        String key = parts[1];
        Objects.requireNonNull(key);
        String contextName = parts[0];
        Objects.requireNonNull(contextName);
        Matcher mapMatcher = MAP_PATTERN.matcher(contextName);
        SystemInfo info = SystemInfo.getInfo((SystemInfo)this.testingInfo);
        if (mapMatcher.matches()) {
            return new TNodeRepeatMap(info, this.textContentParser, onlyChildren, qName, attributesFiltered, key, mapMatcher.group(1), mapMatcher.group(2));
        }
        return new TNodeRepeatIter(info, this.textContentParser, onlyChildren, qName, attributesFiltered, key, contextName);
    }
}

