/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import org.fao.geonet.api.records.formatters.cache.CacheConfig;
import org.fao.geonet.api.records.formatters.cache.ConfigurableCacheConfig;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.api.records.formatters.cache.PersistentStore;
import org.fao.geonet.api.records.formatters.cache.PersistentStoreRunnable;
import org.fao.geonet.api.records.formatters.cache.StoreInfo;
import org.fao.geonet.api.records.formatters.cache.StoreInfoAndData;
import org.fao.geonet.api.records.formatters.cache.StoreInfoAndDataLoadResult;
import org.fao.geonet.api.records.formatters.cache.Validator;
import org.fao.geonet.domain.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class FormatterCache {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final PersistentStore persistentStore;
    private final Cache<Key, StoreInfoAndData> memoryCache;
    private final Multimap<Integer, Pair<Key, StoreInfoAndData>> mdIdIndex = ArrayListMultimap.create();
    private final ExecutorService executor;
    private final BlockingQueue<Pair<Key, StoreInfoAndDataLoadResult>> storeRequests;
    @Autowired
    private CacheConfig cacheConfig;

    public FormatterCache(PersistentStore persistentStore, int memoryCacheSize, int maxStoreRequests) {
        this(persistentStore, memoryCacheSize, maxStoreRequests, new ConfigurableCacheConfig());
    }

    public FormatterCache(PersistentStore persistentStore, int memoryCacheSize, int maxStoreRequests, CacheConfig cacheConfig, ExecutorService executor) {
        this.persistentStore = persistentStore;
        this.memoryCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemoveFromIndexListener()).maximumSize((long)memoryCacheSize).build();
        this.cacheConfig = cacheConfig;
        this.storeRequests = new ArrayBlockingQueue<Pair<Key, StoreInfoAndDataLoadResult>>(maxStoreRequests);
        this.executor = executor;
        this.executor.submit(this.createPersistentStoreRunnable(this.storeRequests, this.persistentStore));
    }

    public FormatterCache(PersistentStore persistentStore, int memoryCacheSize, int maxStoreRequests, CacheConfig config) {
        this(persistentStore, memoryCacheSize, maxStoreRequests, config, FormatterCache.defaultExecutor());
    }

    private static ExecutorService defaultExecutor() {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory();
        threadFactory.setDaemon(true);
        threadFactory.setThreadNamePrefix("FormatterCache-");
        return Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    @VisibleForTesting
    PersistentStoreRunnable createPersistentStoreRunnable(BlockingQueue<Pair<Key, StoreInfoAndDataLoadResult>> storeRequests, PersistentStore store) {
        return new PersistentStoreRunnable(storeRequests, store);
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    public void remove(Key key) throws IOException, SQLException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.memoryCache.invalidate((Object)key);
            this.persistentStore.remove(key);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] get(Key key, Validator validator, Callable<StoreInfoAndDataLoadResult> loader, boolean writeToStoreInCurrentThread) throws Exception {
        StoreInfoAndData cached;
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            if (!this.cacheConfig.allowCaching(key)) {
                byte[] byArray = loader.call().data;
                return byArray;
            }
            cached = (StoreInfoAndData)this.memoryCache.getIfPresent((Object)key);
            boolean invalid = false;
            if (cached != null && !validator.isCacheVersionValid(cached)) {
                cached = null;
                invalid = true;
            }
            if (!invalid && cached == null) {
                cached = this.loadFromPersistentCache(key, validator);
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.lock.writeLock();
        if (cached == null) {
            try {
                writeLock.lock();
                StoreInfoAndDataLoadResult loaded = loader.call();
                cached = loaded;
                this.push(key, loaded, writeToStoreInCurrentThread);
            }
            finally {
                writeLock.unlock();
            }
        }
        return cached.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(Key key, StoreInfoAndDataLoadResult cached, boolean writeToStoreInCurrentThread) throws IOException, SQLException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.memoryCache.put((Object)key, (Object)cached);
            this.mdIdIndex.put((Object)key.mdId, (Object)Pair.read((Object)key, (Object)cached));
            if (writeToStoreInCurrentThread) {
                this.createPersistentStoreRunnable(this.storeRequests, this.persistentStore).processStoreRequest((Pair<Key, StoreInfoAndDataLoadResult>)Pair.read((Object)key, (Object)cached));
            } else if (!this.executor.isShutdown()) {
                this.storeRequests.put((Pair<Key, StoreInfoAndDataLoadResult>)Pair.read((Object)key, (Object)cached));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreInfoAndData loadFromPersistentCache(Key key, Validator validator) throws IOException, SQLException {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            StoreInfo info = this.persistentStore.getInfo(key);
            if (info != null && validator.isCacheVersionValid(info)) {
                StoreInfoAndData storeInfoAndData = this.persistentStore.get(key);
                return storeInfoAndData;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getPublished(Key key) throws IOException, SQLException {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            byte[] byArray = this.persistentStore.getPublished(key);
            return byArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPublished(int metadataId, boolean published) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.persistentStore.setPublished(metadataId, published);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll(int metadataId) throws IOException, SQLException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            Collection storeInfoAndDatas = this.mdIdIndex.removeAll((Object)metadataId);
            for (Pair storeInfoAndData : storeInfoAndDatas) {
                Key key = (Key)storeInfoAndData.one();
                this.memoryCache.invalidate((Object)key);
                this.persistentStore.remove(key);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void clear() throws IOException, SQLException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.memoryCache.invalidateAll();
            this.persistentStore.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    private class RemoveFromIndexListener
    implements RemovalListener<Key, StoreInfoAndData> {
        private RemoveFromIndexListener() {
        }

        public void onRemoval(RemovalNotification<Key, StoreInfoAndData> notification) {
            FormatterCache.this.mdIdIndex.remove((Object)((Key)notification.getKey()).mdId, notification.getValue());
        }
    }
}

