/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jeeves.server.dispatchers.guiservices.XmlFile;
import org.fao.geonet.domain.Pair;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;

public class SchemaLocalization {
    public final String schema;
    private final Map<String, XmlFile> schemaInfo;
    private final ApplicationContext context;
    private final Map<String, ImmutableTable<String, String, Element>> labelIndex = Maps.newHashMap();
    private final Map<String, ImmutableTable<String, String, Element>> codeListIndex = Maps.newHashMap();

    public SchemaLocalization(ApplicationContext context, String schema, Map<String, XmlFile> schemaInfo) {
        this.schema = schema;
        this.schemaInfo = schemaInfo;
        this.context = context;
    }

    public Element getLabels(String lang) throws Exception {
        return this.getXml("labels.xml", lang);
    }

    public Element getCodelists(String lang) throws Exception {
        return this.getXml("codelists.xml", lang);
    }

    public Element getStrings(String lang) throws Exception {
        return this.getXml("strings.xml", lang);
    }

    public synchronized ImmutableTable<String, String, Element> getLabelIndex(String lang) throws Exception {
        ImmutableTable index = this.labelIndex.get(lang);
        if (index == null) {
            ImmutableTable.Builder indexBuilder = ImmutableTable.builder();
            Element labels = this.getLabels(lang);
            HashSet added = Sets.newHashSet();
            List children = labels.getChildren("element");
            for (Element element : children) {
                Pair key;
                String name = element.getAttributeValue("name");
                String parent = element.getAttributeValue("context");
                if (parent == null) {
                    parent = "";
                }
                if (added.contains(key = Pair.read((Object)name, (Object)parent))) continue;
                indexBuilder.put((Object)name, (Object)parent, (Object)element);
                added.add(key);
            }
            index = indexBuilder.build();
            this.labelIndex.put(lang, (ImmutableTable<String, String, Element>)index);
        }
        return index;
    }

    public ImmutableTable<String, String, Element> getCodeListIndex(String lang) throws Exception {
        ImmutableTable index = this.codeListIndex.get(lang);
        if (index == null) {
            ImmutableTable.Builder indexBuilder = ImmutableTable.builder();
            Element codelistEls = this.getCodelists(lang);
            HashSet added = Sets.newHashSet();
            List children = codelistEls.getChildren("codelist");
            for (Element codelist : children) {
                String codelistName = this.extractCodeListNameFromXml(codelist);
                List codes = codelist.getChildren("entry");
                for (Element codeEl : codes) {
                    String code = codeEl.getChildText("code");
                    Pair key = Pair.read((Object)codelistName, (Object)code);
                    if (added.contains(key)) continue;
                    indexBuilder.put((Object)codelistName, (Object)code, (Object)codeEl);
                    added.add(key);
                }
            }
            index = indexBuilder.build();
            this.codeListIndex.put(lang, (ImmutableTable<String, String, Element>)index);
        }
        return index;
    }

    private String extractCodeListNameFromXml(Element child) {
        String codeListNameFromLabel = child.getAttributeValue("name");
        int endOfPrefix = codeListNameFromLabel.indexOf(":");
        if (endOfPrefix > 0) {
            codeListNameFromLabel = codeListNameFromLabel.substring(endOfPrefix + 1);
        }
        return codeListNameFromLabel;
    }

    private Element getXml(String key, String lang) throws JDOMException, IOException {
        return this.schemaInfo.get(key).getXml(this.context, lang, false);
    }
}

