/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import net.sf.json.JSONObject;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.services.metadata.BatchOpsMetadataReindexer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordIndexing")
@ReadWriteController
public class MetadataIndexApi {
    @Autowired
    DataManager dataManager;

    @ApiOperation(value="Index a set of records", notes="Index a set of records provided either by a bucket or a list of uuids", nickname="indexSelection")
    @RequestMapping(value={"/index"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Record indexed."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @ResponseBody
    public JSONObject index(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        UserSession session = ApiUtils.getUserSession(httpSession);
        SelectionManager selectionManager = SelectionManager.getManager((UserSession)serviceContext.getUserSession());
        Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        HashSet ids = Sets.newHashSet();
        int index = 0;
        for (String uuid : records) {
            try {
                String metadataId = this.dataManager.getMetadataId(uuid);
                if (metadataId == null) continue;
                ids.add(Integer.valueOf(metadataId));
            }
            catch (Exception e) {
                try {
                    ids.add(Integer.valueOf(uuid));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        index = ids.size();
        new BatchOpsMetadataReindexer(this.dataManager, ids).process(false);
        JSONObject res = new JSONObject();
        res.put((Object)"success", (Object)true);
        res.put((Object)"count", (Object)index);
        return res;
    }
}

