/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.InspireValidationRunnable;
import org.fao.geonet.api.records.editing.InspireValidatorUtils;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterApi;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.events.history.RecordValidationTriggeredEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.ThreadPool;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"})
@Controller(value="inspire")
@PreAuthorize(value="hasRole('Editor')")
@ReadWriteController
public class InspireValidationApi {
    @Autowired
    SettingManager settingManager;
    @Autowired
    InspireValidatorUtils inspireValidatorUtils;
    @Autowired
    LanguageUtils languageUtils;
    String supportedSchemaRegex = "(iso19139|iso19115-3).*";
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private ThreadPool threadPool;

    @ApiOperation(value="Get test suites available.", notes="TG13, TG2, ...", nickname="getTestSuites")
    @RequestMapping(value={"/{metadataUuid}/validate/inspire/testsuites"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="List of testsuites available."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public Map<String, String[]> getTestSuites(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid) {
        return this.inspireValidatorUtils.getTestsuites();
    }

    @ApiOperation(value="Submit a record to the INSPIRE service for validation.", notes="User MUST be able to edit the record to validate it. An INSPIRE endpoint must be configured in Settings. This activates an asyncronous process, this method does not return any report. This method returns an id to be used to get the report.", nickname="submitValidate")
    @RequestMapping(value={"/{metadataUuid}/validate/inspire"}, method={RequestMethod.PUT}, produces={"text/plain"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Check status of the report."), @ApiResponse(code=404, message="Metadata not found."), @ApiResponse(code=500, message="Service unavailable."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public String validateRecord(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Test suite to run", required=false) @RequestParam String testsuite, HttpServletResponse response, @ApiParam(hidden=true) @ApiIgnore HttpServletRequest request, @ApiParam(hidden=true) @ApiIgnore NativeWebRequest nativeRequest, @ApiParam(hidden=true) @ApiIgnore HttpSession session) throws Exception {
        ServiceContext context;
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        new RecordValidationTriggeredEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), null).publish((ApplicationContext)appContext);
        if (metadata == null) {
            response.setStatus(404);
            return "";
        }
        String schema = metadata.getDataInfo().getSchemaId();
        if (!schema.matches(this.supportedSchemaRegex)) {
            response.setStatus(406);
            return String.format("INSPIRE validator does not support records in schema '%'. Schema must match expression '%' and have an ISO19139 formatter.", schema, this.supportedSchemaRegex);
        }
        String id = String.valueOf(metadata.getId());
        String URL2 = this.settingManager.getValue("system/inspire/remotevalidation/url");
        Element md = (Element)ApiUtils.getUserSession(session).getProperty("metadata.editing" + id);
        if (md == null) {
            response.setStatus(404);
            return String.format("Metadata with id '%s' not found in session. To be validated, the record must be in edition session.", id);
        }
        if (!schema.equals("iso19139")) {
            try {
                context = ApiUtils.createServiceContext(request);
                Key key = new Key(metadata.getId(), "eng", FormatType.xml, "iso19139", true, FormatterWidth._100);
                FormatterApi formatterApi = new FormatterApi();
                formatterApi.getClass();
                FormatterApi.FormatMetadata formatMetadata = formatterApi.new FormatterApi.FormatMetadata(context, key, nativeRequest);
                byte[] data = formatMetadata.call().data;
                md = Xml.loadString((String)new String(data, StandardCharsets.UTF_8), (boolean)false);
            }
            catch (Exception e) {
                response.setStatus(404);
                return String.format("Metadata with id '%s' is in schema '%s'. No iso19139 formatter found. Error is %s", id, schema, e.getMessage());
            }
        } else {
            EditLib editLib = ((DataManager)appContext.getBean(DataManager.class)).getEditLib();
            editLib.removeEditingInfo(md);
            editLib.contractElements(md);
        }
        md.detach();
        context = ApiUtils.createServiceContext(request);
        Attribute schemaLocAtt = this.schemaManager.getSchemaLocation("iso19139", context);
        if (schemaLocAtt != null && md.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
            md.setAttribute(schemaLocAtt);
            md.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
            md.addNamespaceDeclaration(schemaLocAtt.getNamespace());
        }
        InputStream metadataToTest = this.convertElement2InputStream(md);
        String testId = this.inspireValidatorUtils.submitFile(context, URL2, metadataToTest, testsuite, metadata.getUuid());
        this.threadPool.runTask((Runnable)new InspireValidationRunnable(context, URL2, testId, metadata.getId()));
        return testId;
    }

    private InputStream convertElement2InputStream(Element md) throws TransformerFactoryConfigurationError, TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLOutputter xmlOutput = new XMLOutputter();
        try {
            xmlOutput.output(new Document(md), (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.error((String)"jeeves.service", (Object)"Error in conversion of document before sending", (Throwable)e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    @ApiOperation(value="Check the status of validation with the INSPIRE service.", notes="User MUST be able to edit the record to validate it. An INSPIRE endpoint must be configured in Settings. If the process is complete an object with status is returned. ", nickname="checkValidateStatus")
    @RequestMapping(value={"/{testId}/validate/inspire"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Report ready."), @ApiResponse(code=201, message="Report not ready."), @ApiResponse(code=404, message="Report id not found."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public Map<String, String> checkValidation(@ApiParam(value="Test identifier", required=true) @PathVariable String testId, HttpServletRequest request, @ApiParam(hidden=true) @ApiIgnore HttpServletResponse response, @ApiParam(hidden=true) @ApiIgnore HttpSession session) throws Exception {
        String URL2 = this.settingManager.getValue("system/inspire/remotevalidation/url");
        ServiceContext context = ApiUtils.createServiceContext(request);
        try {
            if (this.inspireValidatorUtils.isReady(context, URL2, testId)) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("status", this.inspireValidatorUtils.isPassed(context, URL2, testId));
                values.put("report", this.inspireValidatorUtils.getReportUrl(URL2, testId));
                response.setStatus(200);
                return values;
            }
        }
        catch (ResourceNotFoundException e) {
            response.setStatus(404);
            return new HashMap<String, String>();
        }
        catch (Exception e) {
            response.setStatus(500);
            return new HashMap<String, String>();
        }
        response.setStatus(201);
        return new HashMap<String, String>();
    }
}

