/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fao.geonet.Constants;

public class Sha1Encoder {
    private static final String HEXES = "0123456789abcdef";

    public static String encodeString(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(input.getBytes(Constants.ENCODING));
            return Sha1Encoder.getHex(md.digest());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }
}

