/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.notifier;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.fao.geonet.domain.MetadataNotifier;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.notifier.MetadataNotifierClientException;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class MetadataNotifierClient {
    @Autowired
    SettingManager settingManager;
    @Autowired
    GeonetHttpRequestFactory requestFactory;

    public void webUpdate(MetadataNotifier notifier, String metadataXml, String metadataUuid) throws MetadataNotifierClientException {
        List<BasicNameValuePair> data = Arrays.asList(new BasicNameValuePair("action", "update"), new BasicNameValuePair("uuid", metadataUuid), new BasicNameValuePair("XMLFile", metadataXml));
        this.execute(notifier, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final MetadataNotifier notifier, List<? extends NameValuePair> data) throws MetadataNotifierClientException {
        try {
            HttpPost method = new HttpPost(notifier.getUrl());
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data, StandardCharsets.UTF_8);
            final RequestConfig.Builder configBuilder = RequestConfig.custom();
            configBuilder.setMaxRedirects(3);
            method.addHeader("Accept-Charset", StandardCharsets.UTF_8.name());
            method.setEntity((HttpEntity)entity);
            final boolean authenticationEnabled = StringUtils.isNotBlank((String)notifier.getUsername()) && notifier.getPassword() != null && notifier.getPassword().length > 0;
            configBuilder.setAuthenticationEnabled(authenticationEnabled);
            method.setConfig(configBuilder.build());
            final String requestHost = method.getURI().getHost();
            ClientHttpResponse response = this.requestFactory.execute((HttpUriRequest)method, (Function)new Function<HttpClientBuilder, Void>(){

                @Nullable
                public Void apply(@Nullable HttpClientBuilder requestBuilder) {
                    CredentialsProvider provider = Lib.net.setupProxy(MetadataNotifierClient.this.settingManager, requestBuilder, requestHost);
                    if (authenticationEnabled) {
                        Log.debug((String)"MetadataNotifierClient", (Object)("webUpdate: SET USER -> " + notifier.getUsername()));
                        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(notifier.getUsername(), String.copyValueOf(notifier.getPassword())));
                        configBuilder.setAuthenticationEnabled(true);
                    }
                    return null;
                }
            });
            try {
                if (response.getStatusCode() != HttpStatus.OK) {
                    throw new MetadataNotifierClientException("Method failed: " + response.getStatusText());
                }
                try {
                    InputStream instream = response.getBody();
                    IOUtils.closeQuietly((InputStream)instream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (IOException e) {
            throw new MetadataNotifierClientException(e);
        }
    }

    public void webDelete(MetadataNotifier notifier, String metadataUuid) throws MetadataNotifierClientException {
        List<BasicNameValuePair> data = Arrays.asList(new BasicNameValuePair("action", "delete"), new BasicNameValuePair("uuid", metadataUuid), new BasicNameValuePair("XMLFile", ""));
        this.execute(notifier, data);
    }
}

