/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.SpatialOperator;

public class FullScanFilter
extends SpatialFilter {
    private Set<String> _matches;

    public FullScanFilter(Query query, int numHits, Geometry geom, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor) throws IOException {
        super(query, numHits, geom, sourceAccessor);
    }

    protected FullScanFilter(Query query, int numHits, Envelope bounds, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor) throws IOException {
        super(query, numHits, bounds, sourceAccessor);
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        final OpenBitSet bits = new OpenBitSet((long)context.reader().maxDoc());
        final Set<String> matches = this.loadMatches();
        new IndexSearcher((IndexReader)context.reader()).search(this._query, new Collector(){
            private int docBase;
            private AtomicReader reader;

            public void setScorer(Scorer scorer) {
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public final void collect(int doc) {
                try {
                    Document document = this.reader.document(doc, FullScanFilter.this._fieldsToLoad);
                    if (matches.contains(document.get("_id"))) {
                        bits.set((long)(this.docBase + doc));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void setNextReader(AtomicReaderContext context) throws IOException {
                this.docBase = context.docBase;
                this.reader = context.reader();
            }
        });
        return bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Set<String> loadMatches() throws IOException {
        if (this._matches == null) {
            FeatureSource _featureSource = (FeatureSource)this.sourceAccessor.one();
            FeatureCollection features = _featureSource.getFeatures(this.createFilter((FeatureSource<SimpleFeatureType, SimpleFeature>)_featureSource));
            HashSet<String> matches = new HashSet<String>();
            try (FeatureIterator iterator = features.features();){
                Name idColumn = SpatialIndexWriter.findIdColumn((FeatureSource<SimpleFeatureType, SimpleFeature>)_featureSource);
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    matches.add((String)feature.getAttribute(idColumn));
                }
            }
            this._matches = matches;
        }
        return this._matches;
    }

    public SpatialOperator createGeomFilter(FilterFactory2 filterFactory, PropertyName geomPropertyName, Literal geomExpression) {
        return filterFactory.disjoint((Expression)geomPropertyName, (Expression)geomExpression);
    }
}

