/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.log;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.fao.geonet.kernel.search.log.SearchRequestParam;
import org.fao.geonet.utils.Log;

public enum LuceneQueryParamType {
    TERM{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof TermQuery) {
                TermQuery termQuery = (TermQuery)query;
                String term = termQuery.getTerm().field();
                if (!1.isExcludedField(term)) {
                    SearchRequestParam param = new SearchRequestParam().setTermField(term).setTermText(termQuery.getTerm().text()).setQueryType(this);
                    ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                    list.add(param);
                    return Optional.of(list);
                }
                return Optional.absent();
            }
            return Optional.absent();
        }
    }
    ,
    ConstantScoreQuery{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof ConstantScoreQuery) {
                ConstantScoreQuery termQuery = (ConstantScoreQuery)query;
                BooleanQuery booleanQuery = (BooleanQuery)termQuery.getQuery();
                ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                if (booleanQuery != null) {
                    for (BooleanClause clause : booleanQuery.clauses()) {
                        TermQuery tQuery;
                        String term;
                        Query q = clause.getQuery();
                        if (!(q instanceof TermQuery) || 2.isExcludedField(term = (tQuery = (TermQuery)q).getTerm().field())) continue;
                        SearchRequestParam param = new SearchRequestParam().setTermField(tQuery.getTerm().field()).setTermText(tQuery.getTerm().text()).setQueryType(this);
                        list.add(param);
                    }
                } else {
                    Filter filter = termQuery.getFilter();
                    if (filter instanceof MultiTermQueryWrapperFilter) {
                        MultiTermQueryWrapperFilter f = (MultiTermQueryWrapperFilter)filter;
                        SearchRequestParam param = new SearchRequestParam().setTermField(f.getField()).setTermText(f.toString()).setQueryType(this);
                        list.add(param);
                    }
                }
                return Optional.of(list);
            }
            return Optional.absent();
        }
    }
    ,
    DRILLDOWN{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof DrillDownQuery) {
                if (Log.isDebugEnabled((String)"geonetwork.search-logger")) {
                    Log.debug((String)"geonetwork.search-logger", (Object)"DrillDownQuery can not be logged. You should DrillDownQuery#rewrite and send this to the logger.");
                }
                return Optional.absent();
            }
            return Optional.absent();
        }
    }
    ,
    FUZZY{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof FuzzyQuery) {
                FuzzyQuery fuzzyQuery = (FuzzyQuery)query;
                String term = fuzzyQuery.getTerm().field();
                if (!4.isExcludedField(term)) {
                    SearchRequestParam param = new SearchRequestParam().setTermField(fuzzyQuery.getTerm().field()).setTermText(fuzzyQuery.getTerm().text()).setQueryType(this).setSimilarity(((double)fuzzyQuery.getMaxEdits() - 1.0) / 10.0);
                    ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                    list.add(param);
                    return Optional.of(list);
                }
                return Optional.absent();
            }
            return Optional.absent();
        }
    }
    ,
    PREFIX{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof PrefixQuery) {
                PrefixQuery prefixQuery = (PrefixQuery)query;
                String field = prefixQuery.getPrefix().field();
                if (!5.isExcludedField(field)) {
                    String text = prefixQuery.getPrefix().text();
                    SearchRequestParam param = new SearchRequestParam().setTermField(field).setTermText(text).setQueryType(this);
                    ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                    list.add(param);
                    return Optional.of(list);
                }
                return Optional.absent();
            }
            return Optional.absent();
        }
    }
    ,
    MATCH_ALL_DOCS{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof MatchAllDocsQuery) {
                HashSet terms = new HashSet();
                query.extractTerms(terms);
                String fields = LuceneQueryParamType.concatTermsField(terms.toArray(new Term[terms.size()]), null);
                String texts = LuceneQueryParamType.concatTermsText(new Term[terms.size()], null);
                SearchRequestParam param = new SearchRequestParam().setTermField(fields).setTermText(texts).setQueryType(this);
                ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                list.add(param);
                return Optional.of(list);
            }
            return Optional.absent();
        }
    }
    ,
    WILDCARD{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof WildcardQuery) {
                WildcardQuery wildcardQuery = (WildcardQuery)query;
                String field = wildcardQuery.getTerm().field();
                if (!7.isExcludedField(field)) {
                    String text = wildcardQuery.getTerm().text();
                    SearchRequestParam param = new SearchRequestParam().setTermField(field).setTermText(text).setQueryType(this);
                    ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                    list.add(param);
                    return Optional.of(list);
                }
                return Optional.absent();
            }
            return Optional.absent();
        }
    }
    ,
    PHRASE{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof PhraseQuery) {
                Term[] terms = ((PhraseQuery)query).getTerms();
                String fields = LuceneQueryParamType.concatTermsField(terms, null);
                String texts = LuceneQueryParamType.concatTermsText(terms, null);
                SearchRequestParam param = new SearchRequestParam().setTermField(fields).setTermText(texts).setQueryType(this);
                ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                list.add(param);
                return Optional.of(list);
            }
            return Optional.absent();
        }
    }
    ,
    RANGE{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof TermRangeQuery) {
                TermRangeQuery rangeQuery = (TermRangeQuery)query;
                SearchRequestParam param = new SearchRequestParam();
                if (rangeQuery.getLowerTerm() != null) {
                    param.setLowerText(rangeQuery.getLowerTerm().utf8ToString());
                }
                if (rangeQuery.getUpperTerm() != null) {
                    param.setUpperText(rangeQuery.getUpperTerm().utf8ToString());
                }
                param.setTermField(rangeQuery.getField());
                param.setQueryType(this);
                ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                list.add(param);
                return Optional.of(list);
            }
            return Optional.absent();
        }
    }
    ,
    NUMERIC_RANGE{

        @Override
        protected Optional<List<SearchRequestParam>> createTypeFrom(Query query) {
            if (query instanceof NumericRangeQuery) {
                NumericRangeQuery numericRangeQuery = (NumericRangeQuery)query;
                SearchRequestParam param = new SearchRequestParam().setLowerText(numericRangeQuery.getMin().toString()).setUpperText(numericRangeQuery.getMax().toString()).setTermField(numericRangeQuery.getField());
                ArrayList<SearchRequestParam> list = new ArrayList<SearchRequestParam>();
                list.add(param);
                return Optional.of(list);
            }
            return Optional.absent();
        }
    };

    public static final Pattern excludedFieldPattern;

    public static boolean isExcludedField(String field) {
        return excludedFieldPattern.matcher(field).matches();
    }

    public static Optional<List<SearchRequestParam>> createRequestParam(Query query) {
        for (LuceneQueryParamType luceneQueryParamType : LuceneQueryParamType.values()) {
            Optional<List<SearchRequestParam>> param = luceneQueryParamType.createTypeFrom(query);
            if (!param.isPresent()) continue;
            return param;
        }
        return Optional.absent();
    }

    private static String concatTermsField(Term[] terms, String separator) {
        if (terms == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Term t : terms) {
            sb.append(t.field()).append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String concatTermsText(Term[] terms, String separator) {
        if (terms == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Term t : terms) {
            sb.append(t.text()).append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected abstract Optional<List<SearchRequestParam>> createTypeFrom(Query var1);

    static {
        excludedFieldPattern = Pattern.compile("_op.*|_isTemplate|_locale|_owner|_groupOwner|_dummy|type");
    }
}

