/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.keyword;

import java.util.Set;
import org.fao.geonet.kernel.rdf.Where;
import org.fao.geonet.kernel.rdf.Wheres;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParamsBuilder;
import org.fao.geonet.kernel.search.keyword.KeywordSearchType;
import org.fao.geonet.kernel.search.keyword.SearchClause;
import org.jdom.Content;
import org.jdom.Element;

public class URISearchClause
implements SearchClause {
    KeywordSearchType searchType;
    boolean ignoreCase;
    private String uri;

    public URISearchClause(String uri) {
        this.uri = uri;
    }

    public URISearchClause(KeywordSearchType searchType, String keywordURI, boolean ignoreCase) {
        this.searchType = searchType;
        this.uri = keywordURI;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public Where toWhere(Set<String> langs) {
        if (this.searchType != null) {
            return this.searchType.toWhere("id", this.uri, this.ignoreCase);
        }
        return Wheres.ID(this.uri);
    }

    @Override
    public void addXmlParams(Element params) {
        params.addContent((Content)new Element("pUri").setText(this.uri));
        KeywordSearchParamsBuilder.addXmlParam(params, "pUri", this.uri);
        if (this.searchType != null) {
            KeywordSearchParamsBuilder.addXmlParam(params, "pTypeSearch", "" + this.searchType.ordinal());
        }
    }
}

