/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.keyword;

import java.util.Comparator;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.search.keyword.SortDirection;

public final class KeywordSort {
    private KeywordSort() {
    }

    public static Comparator<KeywordBean> defaultLabelSorter(final SortDirection direction) {
        return new Comparator<KeywordBean>(){

            @Override
            public int compare(KeywordBean kw1, KeywordBean kw2) {
                int comp = KeywordSort.normalizeDesc(kw1.getDefaultValue()).compareTo(KeywordSort.normalizeDesc(kw2.getDefaultValue()));
                if (comp == 0) {
                    comp = kw1.getUriCode().compareTo(kw2.getUriCode());
                }
                return direction.multiplier * comp;
            }

            public String toString() {
                return "Sort by Value " + (Object)((Object)direction);
            }
        };
    }

    public static Comparator<KeywordBean> defaultDefinitionSorter(final SortDirection direction) {
        return new Comparator<KeywordBean>(){

            @Override
            public int compare(KeywordBean kw1, KeywordBean kw2) {
                return direction.multiplier * KeywordSort.normalizeDesc(kw1.getDefaultDefinition()).compareToIgnoreCase(KeywordSort.normalizeDesc(kw2.getDefaultDefinition()));
            }

            public String toString() {
                return "Sort by Definition " + (Object)((Object)direction);
            }
        };
    }

    public static Comparator<KeywordBean> searchResultsSorter(String searchTerm, final SortDirection direction) {
        final Comparator<KeywordBean> defaultSorter = KeywordSort.defaultLabelSorter(direction);
        final String normSearchTerm = KeywordSort.normalizeDesc(searchTerm);
        return new Comparator<KeywordBean>(){

            @Override
            public int compare(KeywordBean kw1, KeywordBean kw2) {
                int sim2;
                String defValue1 = KeywordSort.normalizeDesc(kw1.getDefaultValue());
                String defValue2 = KeywordSort.normalizeDesc(kw2.getDefaultValue());
                int sim1 = KeywordSort.calcSim(defValue1, normSearchTerm);
                if (sim1 != (sim2 = KeywordSort.calcSim(defValue2, normSearchTerm))) {
                    return (sim2 *= 6 - Math.min(5, defValue2.length() - normSearchTerm.length())) - (sim1 *= 6 - Math.min(5, defValue1.length() - normSearchTerm.length()));
                }
                return defaultSorter.compare(kw1, kw2);
            }

            public String toString() {
                return "Prioritize: " + normSearchTerm + ", other order: " + (Object)((Object)direction);
            }
        };
    }

    private static int calcSim(String val, String normSearchTerm) {
        if (val.equals(normSearchTerm)) {
            return 100;
        }
        if (val.startsWith(normSearchTerm)) {
            return 1;
        }
        return 0;
    }

    public static String normalizeDesc(String rawDesc) {
        if (rawDesc == null) {
            return "";
        }
        String lowercase = rawDesc.toLowerCase();
        StringBuilder builder = new StringBuilder();
        block8: for (int i = 0; i < lowercase.length(); ++i) {
            char currChar = lowercase.charAt(i);
            switch (currChar) {
                case '\u00f2': 
                case '\u00f4': 
                case '\u00f6': {
                    builder.append('o');
                    continue block8;
                }
                case '\u00f9': 
                case '\u00fb': 
                case '\u00fc': {
                    builder.append('u');
                    continue block8;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': {
                    builder.append('e');
                    continue block8;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e4': {
                    builder.append('a');
                    continue block8;
                }
                case '\u00e7': {
                    builder.append('c');
                    continue block8;
                }
                case '\u00ec': 
                case '\u00ee': {
                    builder.append('i');
                    continue block8;
                }
                default: {
                    if (!Character.isAlphabetic(currChar) && !Character.isDigit(currChar)) continue block8;
                    builder.append(currChar);
                }
            }
        }
        return builder.toString().trim();
    }
}

