/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.classifier;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.search.classifier.AbstractTerm;

public class TermLabel
extends AbstractTerm {
    private String langCode;

    public TermLabel(ThesaurusFinder finder, String conceptScheme, String langCode) {
        super(finder, conceptScheme);
        this.langCode = langCode;
    }

    public void setIndexLabel(boolean indexLabel) {
        this.setLanguageToIndex(indexLabel ? this.langCode : null);
    }

    @Override
    public List<CategoryPath> classify(String value) {
        if (this.hasUriFor(value)) {
            return this.classifyUri(this.getUriFor(value));
        }
        return new ArrayList<CategoryPath>();
    }

    private boolean hasUriFor(String value) {
        Thesaurus thesaurus = this.getThesaurus();
        if (thesaurus == null) {
            return false;
        }
        return thesaurus.hasKeywordWithLabel(value, this.langCode);
    }

    private String getUriFor(String value) {
        Thesaurus thesaurus = this.getThesaurus();
        KeywordBean term = thesaurus.getKeywordWithLabel(value, this.langCode);
        return term.getUriCode();
    }
}

