/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.util.BytesRef;
import org.fao.geonet.kernel.search.LuceneConfig;

public class CaseInsensitiveFieldComparatorSource
extends FieldComparatorSource {
    private static final CaseInsensitiveFieldComparatorSource languageInsensitiveInstance = new CaseInsensitiveFieldComparatorSource(null);
    private String searchLang;

    public CaseInsensitiveFieldComparatorSource(String searchLang) {
        this.searchLang = searchLang;
    }

    public static CaseInsensitiveFieldComparatorSource languageInsensitiveInstance() {
        return languageInsensitiveInstance;
    }

    public FieldComparator<String> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new CaseInsensitiveFieldComparator(numHits, this.searchLang, fieldname);
    }

    public static final class CaseInsensitiveFieldComparator
    extends FieldComparator<String> {
        private static final SortedDocValues EMPTY_TERMS = new SortedDocValues(){

            public int getOrd(int docID) {
                return 0;
            }

            public BytesRef lookupOrd(int ord) {
                return null;
            }

            public int getValueCount() {
                return 0;
            }
        };
        private final String field;
        private String[] values;
        private SortedDocValues currentReaderValues;
        private String bottom;
        private String searchLang;
        private Collator collator;
        private SortedDocValues shadowValues;

        CaseInsensitiveFieldComparator(int numHits, String searchLang, String field) {
            this.values = new String[numHits];
            this.field = field;
            this.searchLang = searchLang;
            this.collator = Collator.getInstance();
        }

        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            return this.doCompare(val1, val2);
        }

        private int doCompare(String val1, String val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return 1;
            }
            if (val2 == null) {
                return -1;
            }
            return this.collator.compare(val1, val2);
        }

        public void setTopValue(String value) {
        }

        public int compareTop(int doc) throws IOException {
            return -1;
        }

        public int compareBottom(int doc) {
            String val2 = this.readerValue(doc);
            return this.doCompare(this.bottom, val2);
        }

        private String readerValue(int doc) {
            String term = null;
            int ord = this.shadowValues.getOrd(doc);
            if (ord != -1) {
                term = this.shadowValues.lookupOrd(ord).utf8ToString().trim();
            }
            if (term == null || term.isEmpty()) {
                ord = this.currentReaderValues.getOrd(doc);
                if (ord != -1) {
                    term = this.currentReaderValues.lookupOrd(ord).utf8ToString().trim();
                } else {
                    return null;
                }
            }
            return term;
        }

        public void copy(int slot, int doc) {
            String val;
            this.values[slot] = val = this.readerValue(doc);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public FieldComparator<String> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.field);
            this.shadowValues = this.searchLang != null ? FieldCache.DEFAULT.getTermsIndex(context.reader(), LuceneConfig.multilingualSortFieldName(this.field, this.searchLang)) : EMPTY_TERMS;
            return this;
        }

        public String value(int slot) {
            return this.values[slot];
        }
    }
}

