/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.runtime;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.a2j.codec.runtime.AsnBitString;
import org.jzkit.a2j.codec.runtime.AsnNull;
import org.jzkit.a2j.codec.runtime.ChoiceType;
import org.jzkit.a2j.codec.runtime.CodecStackInfo;
import org.jzkit.a2j.codec.runtime.SerializationManager;
import org.jzkit.a2j.codec.runtime.base_codec;
import org.jzkit.a2j.codec.util.OIDRegister;

public class BERInputStream
implements SerializationManager {
    private Stack encoding_info = new Stack();
    public int tag_class = -1;
    public int tag_value = -1;
    public int next_tag_class = -1;
    public int next_tag_number = -1;
    public boolean next_is_constructed = false;
    public boolean next_is_indefinite = false;
    public int next_length = -1;
    public boolean is_constructed = false;
    private BufferedInputStream in = null;
    private base_codec codec_hint = null;
    public String encoding = "US-ASCII";
    private static Log log = LogFactory.getLog(BERInputStream.class);
    private OIDRegister oid_register;

    public BERInputStream(InputStream from, OIDRegister oid_register) {
        this.in = new BufferedInputStream(from);
        this.oid_register = oid_register;
    }

    public BERInputStream(InputStream from, String encoding, OIDRegister oid_register) {
        this.in = new BufferedInputStream(from);
        this.encoding = encoding;
        this.oid_register = oid_register;
    }

    public BERInputStream(InputStream from, String encoding, int buffsize, OIDRegister oid_register) {
        this.in = new BufferedInputStream(from, buffsize);
        this.encoding = encoding;
        this.oid_register = oid_register;
    }

    public int getDirection() {
        return 1;
    }

    public int tag_codec(boolean is_constructed) throws IOException {
        if (this.next_tag_class < 0) {
            if (this.encoding_info.size() > 0 && !this.moreData()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("tag_codec returning -1 whilst expecting (" + this.tag_class + "," + this.tag_value + ") because there is no more data in the constructed type"));
                }
                this.tag_class = -1;
                return -1;
            }
            this.decodeNextTag();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for " + this.tag_class + " " + this.tag_value + " next = " + this.next_tag_class + " " + this.next_tag_number));
        }
        if (this.next_tag_class == this.tag_class && this.next_tag_number == this.tag_value) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.next_tag_class + "," + this.next_tag_number + "] cons=" + this.next_is_constructed + " len=" + this.next_length + " is indef:" + this.next_is_indefinite));
            }
            this.next_tag_class = -1;
            this.tag_class = -1;
            return this.next_length;
        }
        this.tag_class = -1;
        return -1;
    }

    private void decodeNextTag() throws IOException {
        byte c = (byte)this.read();
        c = (byte)(c & 0xFF);
        this.next_tag_class = c & 0xC0;
        this.next_is_constructed = (c & 0x20) != 0;
        this.next_tag_number = c & 0x1F;
        if (this.next_tag_number == 31) {
            this.next_tag_number = 0;
            do {
                c = (byte)this.read();
                this.next_tag_number <<= 7;
                this.next_tag_number |= c & 0x7F;
            } while ((c & 0x80) != 0);
        }
        this.next_length = this.decodeLengthOctets();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[class:" + this.next_tag_class + " tag:" + this.next_tag_number + " cons:" + this.next_is_constructed + " stack:" + this.encoding_info.size() + " len:" + this.next_length + "]"));
        }
    }

    private int decodeLengthOctets() throws IOException {
        int datalen;
        int lenpart = this.read();
        if ((lenpart & 0x80) == 0) {
            datalen = lenpart;
            this.next_is_indefinite = false;
        } else if ((lenpart & 0x7F) == 0) {
            this.next_is_indefinite = true;
            datalen = 0;
        } else {
            this.next_is_indefinite = false;
            lenpart = (byte)(lenpart & 0x7F);
            datalen = 0;
            while (true) {
                int n = lenpart;
                lenpart = (byte)(n - 1);
                if (n <= 0) break;
                datalen = datalen << 8 | (byte)this.read() & 0xFF;
            }
        }
        return datalen;
    }

    public byte[] octetstring_codec(Object instance, boolean is_constructed) throws IOException {
        byte[] retval = null;
        if (this.next_length == 0 && this.next_is_constructed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Indefinite length encoding of octetstring");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte current_octet = (byte)this.read();
            byte next_octet = (byte)this.read();
            while (current_octet != 0 && next_octet != 0) {
                baos.write(current_octet);
                current_octet = next_octet;
                next_octet = (byte)this.read();
            }
            retval = baos.toByteArray();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("definite length encoding of octetstring (" + this.next_length + ")"));
            }
            byte[] data = new byte[this.next_length];
            int bytes_left_to_read = this.next_length;
            int offset = 0;
            while (bytes_left_to_read > 0) {
                int bytes_read = this.read(data, offset, bytes_left_to_read);
                bytes_left_to_read -= bytes_read;
                offset += bytes_read;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Read " + bytes_read + " of " + this.next_length + " leaving " + bytes_left_to_read + " Next bytes will be at " + offset));
            }
            retval = data;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("octetstring_codec returns byte array of length=" + retval.length));
        }
        return retval;
    }

    public Boolean boolean_codec(Object instance, boolean is_constructed) throws IOException {
        Boolean retval = null;
        byte val = (byte)this.read();
        retval = val != 0 ? Boolean.TRUE : Boolean.FALSE;
        return retval;
    }

    public BigInteger integer_codec(Object instance, boolean is_constructed) throws IOException {
        byte[] data = new byte[this.next_length];
        int bytes_left_to_read = this.next_length;
        int offset = 0;
        while (bytes_left_to_read > 0) {
            int bytes_read = this.read(data, offset, bytes_left_to_read);
            bytes_left_to_read -= bytes_read;
            offset += bytes_read;
        }
        return new BigInteger(data);
    }

    public int[] oid_codec(Object instance, boolean is_constructed) throws IOException {
        int[] retval = new int[this.next_length + 1];
        byte[] decode_buffer = new byte[this.next_length];
        int pos = 2;
        int bytes_left_to_read = this.next_length;
        int offset = 0;
        while (bytes_left_to_read > 0) {
            int bytes_read = this.read(decode_buffer, offset, bytes_left_to_read);
            bytes_left_to_read -= bytes_read;
            offset += bytes_read;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(decode_buffer);
        byte octet = (byte)bais.read();
        if (octet >= 80) {
            retval[0] = 2;
            retval[1] = octet - 80;
        } else if (octet >= 40) {
            retval[0] = 1;
            retval[1] = octet - 40;
        } else {
            retval[0] = 0;
            retval[1] = octet;
        }
        while (bais.available() > 0) {
            retval[pos++] = this.decodeBase128Int(bais);
        }
        int[] result = new int[pos];
        System.arraycopy(retval, 0, result, 0, pos);
        return result;
    }

    public byte[] any_codec(Object instance, boolean is_constructed) throws IOException {
        byte[] data = null;
        if (this.next_length > 0 && this.next_is_constructed) {
            data = new byte[this.next_length];
            int bytes_left_to_read = this.next_length;
            int offset = 0;
            while (bytes_left_to_read > 0) {
                int bytes_read = this.read(data, offset, bytes_left_to_read);
                bytes_left_to_read -= bytes_read;
                offset += bytes_read;
            }
        } else if (this.next_length == 0) {
            StringWriter w = new StringWriter();
            byte current_octet = (byte)this.read();
            byte next_octet = (byte)this.read();
            while (current_octet != 0 && next_octet != 0) {
                w.write(current_octet);
                current_octet = next_octet;
                next_octet = (byte)this.read();
            }
            data = w.toString().getBytes();
        } else {
            throw new IOException("Problem decoding any");
        }
        return data;
    }

    public AsnBitString bitstring_codec(Object instance, boolean is_constructed) throws IOException {
        AsnBitString abs = (AsnBitString)instance;
        int unused = this.read();
        if (this.next_length > 0) {
            byte[] data = new byte[this.next_length - 1];
            data = new byte[this.next_length - 1];
            int bytes_left_to_read = this.next_length - 1;
            int offset = 0;
            while (bytes_left_to_read > 0) {
                int bytes_read = this.read(data, offset, bytes_left_to_read);
                bytes_left_to_read -= bytes_read;
                offset += bytes_read;
            }
            abs = new AsnBitString(data, unused);
        }
        return abs;
    }

    public AsnNull null_codec(Object instance, boolean is_constructed) throws IOException {
        Object retval = null;
        if (this.next_length != 0) {
            throw new IOException("Unexpected length encoding of null");
        }
        return new AsnNull();
    }

    public Object choice(Object current_instance, Object[][] choice_info, String name) throws IOException {
        ChoiceType retval = (ChoiceType)current_instance;
        if (log.isDebugEnabled()) {
            log.debug((Object)("1.... choice_codec (" + name + ") current = " + retval + " number of options=" + choice_info.length));
        }
        Object result = null;
        for (int i = 0; i < choice_info.length && result == null; ++i) {
            Integer tagmode = (Integer)choice_info[i][0];
            Integer tagclass = (Integer)choice_info[i][1];
            Integer tagnumber = (Integer)choice_info[i][2];
            base_codec codec_to_use = (base_codec)choice_info[i][3];
            if (log.isDebugEnabled()) {
                log.debug((Object)("choice Trying [" + i + "] : " + tagmode + " " + tagclass + " " + tagnumber + " " + codec_to_use));
            }
            if (tagmode.equals(SerializationManager.TAGMODE_NONE)) {
                result = codec_to_use.serialize(this, result, true, (String)choice_info[i][4]);
            } else if (tagmode.equals(SerializationManager.IMPLICIT)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("implicit  tagging, so simply calling codec for " + (String)choice_info[i][4]));
                }
                result = this.implicit_tag(codec_to_use, result, tagclass, tagnumber, true, (String)choice_info[i][4]);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("explicit tagging, so simply calling codec for " + (String)choice_info[i][4]));
                }
                if (this.constructedBegin(tagclass, tagnumber)) {
                    result = codec_to_use.serialize(this, result, false, (String)choice_info[i][4]);
                    this.constructedEnd();
                }
            }
            if (result == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Choice codec matched on choice " + i));
            }
            retval.o = result;
            retval.which = i;
        }
        if (result == null) {
            retval = null;
        }
        return retval;
    }

    public boolean sequenceBegin() throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = 0;
            this.tag_value = 16;
        }
        return this.constructedBegin(this.tag_class, this.tag_value);
    }

    public boolean sequenceEnd() throws IOException {
        return this.constructedEnd();
    }

    public boolean constructedBegin(int tagclass, int tagnumber) throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = tagclass;
            this.tag_value = tagnumber;
        }
        if (this.tag_codec(true) >= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CONS [" + this.encoding_info.size() + "] (" + this.tag_class + "," + this.tag_value + ") " + tagclass + " len=" + this.next_length));
                log.debug((Object)"{");
            }
            CodecStackInfo csi = new CodecStackInfo();
            csi.content_length = this.next_length;
            csi.bytes_processed = 0;
            csi.is_constructed = this.next_is_constructed;
            csi.is_indefinite_length = this.next_is_indefinite;
            this.encoding_info.push(csi);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"tag_codec returned < 0");
        }
        return false;
    }

    public boolean constructedEnd() throws IOException {
        CodecStackInfo csi = (CodecStackInfo)this.encoding_info.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"}");
        }
        if (csi.is_indefinite_length) {
            byte b1 = (byte)this.read();
            byte b2 = (byte)this.read();
            if (b1 == 0 && b2 == 0) {
                this.next_tag_class = -1;
                this.tag_class = -1;
            } else {
                throw new IOException("Expected indefinite length terminating octets for constructed type, found other values");
            }
        }
        if (this.encoding_info.size() > 0) {
            CodecStackInfo curr = (CodecStackInfo)this.encoding_info.peek();
            curr.bytes_processed += csi.bytes_processed;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed End [" + this.encoding_info.size() + "] (" + csi.bytes_processed + " bytes)"));
        }
        return true;
    }

    public Object implicit_tag(base_codec c, Object current_instance, int tag_class, int tag_number, boolean is_optional, String name) throws IOException {
        Object retval = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("implicit_tag " + tag_class + "," + tag_number + " " + name));
        }
        this.implicit_settag(tag_class, tag_number);
        retval = c.serialize(this, current_instance, is_optional, name);
        return retval;
    }

    public Object explicit_tag(base_codec c, Object current_instance, int tag_class, int tag_number, boolean is_optional, String name) throws IOException {
        Object retval = current_instance;
        if (log.isDebugEnabled()) {
            log.debug((Object)("explicit_tag " + tag_class + "," + tag_number + " " + name));
        }
        if (this.constructedBegin(tag_class, tag_number)) {
            retval = c.serialize(this, retval, is_optional, name);
            this.constructedEnd();
        }
        return retval;
    }

    public ArrayList sequenceOf(ArrayList v, base_codec codec) throws IOException {
        if (v != null) {
            while (this.moreData()) {
                Object item_to_add = codec.serialize(this, null, true, "SequenceOf item");
                if (item_to_add == null) {
                    throw new IOException("Error expecting member of sequenceOf");
                }
                v.add(item_to_add);
            }
        }
        return v;
    }

    public void implicit_settag(int tagclass, int tagvalue) {
        if (this.tag_class < 0) {
            this.tag_class = tagclass;
            this.tag_value = tagvalue;
        }
    }

    public int read() throws IOException {
        int retval = this.in.read();
        if (retval == -1) {
            throw new IOException("Connection Closed");
        }
        if (this.encoding_info.size() > 0) {
            CodecStackInfo csi = (CodecStackInfo)this.encoding_info.peek();
            ++csi.bytes_processed;
        }
        return retval;
    }

    public int read(byte[] buffer, int offset, int max) throws IOException {
        int retval = this.in.read(buffer, offset, max);
        if (retval == -1) {
            throw new IOException("Connection Closed");
        }
        if (this.encoding_info.size() > 0) {
            CodecStackInfo csi = (CodecStackInfo)this.encoding_info.peek();
            csi.bytes_processed += retval;
        }
        return retval;
    }

    public boolean moreData() throws IOException {
        if (this.encoding_info.size() > 0) {
            CodecStackInfo csi = (CodecStackInfo)this.encoding_info.peek();
            if (log.isDebugEnabled()) {
                log.debug((Object)("moreData() Content length=" + csi.content_length + ", bytes_processed=" + csi.bytes_processed + ", constructed=" + csi.is_constructed + ", indefinite length encoding =" + csi.is_indefinite_length));
            }
            if (csi.content_length > 0) {
                return csi.bytes_processed < csi.content_length;
            }
            if (csi.is_indefinite_length) {
                this.in.mark(5);
                int i1 = this.in.read();
                int i2 = this.in.read();
                this.in.reset();
                return i1 != 0 || i2 != 0;
            }
        }
        return false;
    }

    private int decodeBase128Int(InputStream ins) throws IOException {
        int retval = 0;
        int octet = -128;
        while ((octet & 0x80) == 128) {
            octet = (byte)ins.read();
            retval = retval << 7 | octet & 0x7F;
        }
        return retval;
    }

    public base_codec getHintCodec() {
        return this.codec_hint;
    }

    public void setHintCodec(base_codec c) {
        this.codec_hint = c;
    }

    public String getCharsetEncoding() {
        return this.encoding;
    }

    public OIDRegister getOIDRegister() {
        return this.oid_register;
    }
}

