/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.fao.oaipmh.requests.ListRequest;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.responses.ResumptionToken;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public abstract class ListResponse
extends AbstractResponse {
    private ListRequest listReq;
    private ResumptionToken token;
    private Iterator<Element> iterator;

    public ListResponse() {
    }

    public ListResponse(ListRequest lr, Element response) {
        super(response);
        this.listReq = lr;
        this.build(response);
    }

    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        return this.token != null && !this.token.isTokenEmpty();
    }

    public Object next() throws IOException, OaiPmhException, JDOMException, SAXException, Exception {
        if (this.iterator.hasNext()) {
            return this.createObject(this.iterator.next());
        }
        if (this.token == null || this.token.isTokenEmpty()) {
            throw new RuntimeException("Iterator exausted");
        }
        this.build(this.listReq.resume(this.token));
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.createObject(this.iterator.next());
    }

    public abstract int getSize();

    public ResumptionToken getResumptionToken() {
        return this.token;
    }

    public void setResumptionToken(ResumptionToken token) {
        this.token = token;
    }

    protected abstract Object createObject(Element var1);

    protected abstract String getListElementName();

    private void build(Element response) {
        Element operElem = response.getChild(this.listReq.getVerb(), OaiPmh.Namespaces.OAI_PMH);
        Element resToken = operElem.getChild("resumptionToken", OaiPmh.Namespaces.OAI_PMH);
        this.token = resToken == null ? null : new ResumptionToken(resToken);
        this.iterator = operElem.getChildren(this.getListElementName(), OaiPmh.Namespaces.OAI_PMH).iterator();
    }
}

