/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.SqlJetSortingOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtreeIndexTable
extends SqlJetBtreeTable
implements ISqlJetBtreeIndexTable {
    private ISqlJetIndexDef indexDef;
    private List<String> columns;

    public SqlJetBtreeIndexTable(ISqlJetBtree btree, String indexName, boolean write) throws SqlJetException {
        super(btree, ((SqlJetBaseIndexDef)btree.getSchema().getIndex(indexName)).getPage(), write, true);
        this.indexDef = btree.getSchema().getIndex(indexName);
        this.adjustKeyInfo();
    }

    public SqlJetBtreeIndexTable(ISqlJetBtree btree, String indexName, List<String> columns, boolean write) throws SqlJetException {
        super(btree, ((SqlJetBaseIndexDef)btree.getSchema().getIndex(indexName)).getPage(), write, true);
        this.indexDef = btree.getSchema().getIndex(indexName);
        this.columns = columns;
        this.adjustKeyInfo();
    }

    public ISqlJetIndexDef getIndexDef() {
        return this.indexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookup(boolean next, Object ... values) throws SqlJetException {
        this.lock();
        try {
            long l = this.lookupSafe(next, false, false, values);
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private long lookupSafe(boolean next, boolean near, boolean last, Object ... values) throws SqlJetException {
        SqlJetEncoding encoding = this.btree.getDb().getOptions().getEncoding();
        ISqlJetBtreeRecord key = SqlJetBtreeRecord.getRecord(encoding, values);
        ISqlJetMemoryPointer k = key.getRawRecord();
        if (next) {
            if (!last) {
                this.next();
            } else {
                this.previous();
            }
        } else {
            int moved = this.cursorMoveTo(k, last);
            if (moved != 0) {
                if (!last) {
                    if (moved < 0) {
                        this.next();
                    }
                } else if (moved > 0) {
                    this.previous();
                }
            }
        }
        ISqlJetBtreeRecord record = this.getRecord();
        if (null == record) {
            return 0L;
        }
        if (!near && this.keyCompare(k, record.getRawRecord()) != 0) {
            return 0L;
        }
        return this.getKeyRowId(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cursorMoveTo(ISqlJetMemoryPointer pKey, boolean last) throws SqlJetException {
        int n;
        block7: {
            this.clearRecordCache();
            int nKey = pKey.remaining();
            if (!last) {
                return this.getCursor().moveTo(pKey, nKey, false);
            }
            SqlJetUnpackedRecord pIdxKey = null;
            if (pKey != null) {
                assert ((long)nKey == (long)nKey);
                pIdxKey = this.getKeyInfo().recordUnpack(nKey, pKey);
                if (pIdxKey == null) {
                    throw new SqlJetException(SqlJetErrorCode.NOMEM);
                }
                pIdxKey.getFlags().add(SqlJetUnpackedRecordFlags.INCRKEY);
            }
            try {
                n = this.getCursor().moveToUnpacked(pIdxKey, nKey, false);
                if (pKey == null) break block7;
            }
            catch (Throwable throwable) {
                if (pKey != null) {
                    SqlJetUnpackedRecord.delete(pIdxKey);
                }
                throw throwable;
            }
            SqlJetUnpackedRecord.delete(pIdxKey);
        }
        return n;
    }

    private int keyCompare(ISqlJetMemoryPointer key, ISqlJetMemoryPointer record) throws SqlJetException {
        SqlJetUnpackedRecord unpacked = this.getKeyInfo().recordUnpack(key.remaining(), key);
        Set<SqlJetUnpackedRecordFlags> flags = unpacked.getFlags();
        flags.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        flags.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(record.remaining(), record);
    }

    @Override
    public int compareKeys(Object[] firstKey, Object[] lastKey) throws SqlJetException {
        SqlJetEncoding encoding = this.btree.getDb().getOptions().getEncoding();
        ISqlJetMemoryPointer firstRec = SqlJetBtreeRecord.getRecord(encoding, firstKey).getRawRecord();
        ISqlJetMemoryPointer lastRec = SqlJetBtreeRecord.getRecord(encoding, lastKey).getRawRecord();
        SqlJetUnpackedRecord unpacked = this.getKeyInfo().recordUnpack(firstRec.remaining(), firstRec);
        unpacked.getFlags().add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(lastRec.remaining(), lastRec);
    }

    @Override
    public boolean checkKey(Object ... key) throws SqlJetException {
        if (this.eof()) {
            return false;
        }
        ISqlJetMemoryPointer keyRecord = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), key).getRawRecord();
        return 0 == this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    @Override
    protected void adjustKeyInfo() throws SqlJetException {
        if (null == this.getKeyInfo()) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
        if (this.indexDef != null) {
            if (null != this.columns) {
                this.getKeyInfo().setNField(this.columns.size());
            } else if (null != this.indexDef.getColumns()) {
                this.getKeyInfo().setNField(this.indexDef.getColumns().size());
                int i = 0;
                for (ISqlJetIndexedColumn column : this.indexDef.getColumns()) {
                    this.getKeyInfo().setSortOrder(i++, column.getSortingOrder() == SqlJetSortingOrder.DESC);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(long rowId, boolean append, Object ... key) throws SqlJetException {
        this.lock();
        try {
            ISqlJetMemoryPointer zKey = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), SqlJetUtility.addArrays(key, new Object[]{rowId})).getRawRecord();
            this.getCursor().insert(zKey, zKey.remaining(), SqlJetUtility.allocatePtr(0), 0, 0, append);
            this.clearRecordCache();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(long rowId, Object ... key) throws SqlJetException {
        this.lock();
        try {
            ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), key);
            ISqlJetMemoryPointer k = rec.getRawRecord();
            if (this.cursorMoveTo(k, false) < 0) {
                this.next();
            }
            do {
                ISqlJetBtreeRecord record;
                if (null == (record = this.getRecord())) {
                    boolean bl = false;
                    return bl;
                }
                if (this.keyCompare(k, record.getRawRecord()) != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (this.getKeyRowId(record) != rowId) continue;
                this.getCursor().delete();
                this.clearRecordCache();
                if (this.cursorMoveTo(k, false) < 0) {
                    this.next();
                }
                boolean bl = true;
                return bl;
            } while (this.next());
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private long getKeyRowId(ISqlJetBtreeRecord record) {
        if (null == record) {
            return 0L;
        }
        List<ISqlJetVdbeMem> fields = record.getFields();
        if (null == fields || 0 == fields.size()) {
            return 0L;
        }
        return fields.get(fields.size() - 1).intValue();
    }

    @Override
    public long getKeyRowId() throws SqlJetException {
        return this.getKeyRowId(this.getRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(ISqlJetSchema schema) throws SqlJetException {
        this.lock();
        try {
            this.btree.clearTable(this.rootPage, null);
            SqlJetBtreeDataTable dataTable = new SqlJetBtreeDataTable(this.btree, this.indexDef.getTableName(), false);
            try {
                dataTable.first();
                while (!dataTable.eof()) {
                    Object[] key = dataTable.getKeyForIndex(dataTable.getValues(), this.indexDef);
                    this.insert(dataTable.getRowId(), true, key);
                    dataTable.next();
                }
            }
            finally {
                dataTable.close();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int compareKey(Object[] key) throws SqlJetException {
        if (this.eof()) {
            return 1;
        }
        ISqlJetMemoryPointer keyRecord = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), key).getRawRecord();
        return this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookupNear(boolean next, Object[] key) throws SqlJetException {
        this.lock();
        try {
            long l = this.lookupSafe(next, true, false, key);
            return l;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookupLastNear(Object[] key) throws SqlJetException {
        this.lock();
        try {
            long l = this.lookupSafe(false, true, true, key);
            return l;
        }
        finally {
            this.unlock();
        }
    }
}

