/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspireatom;

import javax.transaction.Transactional;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.csw.common.util.Xml;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class InspireAtomService {
    @Autowired
    private InspireAtomFeedRepository _repository;

    public Element retrieveFeed(ServiceContext context, int metadataId) throws Exception {
        InspireAtomFeed feed = this._repository.findByMetadataId(metadataId);
        String atomUrl = feed.getAtomUrl();
        if (StringUtils.isEmpty((String)atomUrl)) {
            throw new Exception("Metadata has no atom feed");
        }
        String feedValue = InspireAtomUtil.retrieveRemoteAtomFeedDocument(context, atomUrl);
        if (StringUtils.isEmpty((String)feedValue)) {
            feedValue = feed.getAtom();
        }
        return Xml.loadString((String)feedValue, (boolean)false);
    }

    public Element retrieveFeed(ServiceContext context, InspireAtomFeed feed) throws Exception {
        return this.retrieveFeed(context, feed.getMetadataId());
    }

    public String retrieveDatasetUuidFromIdentifierNs(String datasetIdCode, String datasetIdNs) {
        return this._repository.retrieveDatasetUuidFromIdentifierNs(datasetIdCode, datasetIdNs);
    }

    public InspireAtomFeed findByMetadataId(int metadataId) {
        return this._repository.findByMetadataId(metadataId);
    }
}

