/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.BigDate;
import org.geotools.data.postgis.PostgisFilterToSQL;
import org.geotools.data.postgis.WKBAttributeIO;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.CurvedRing;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTWriter2;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostGISDialect
extends BasicSQLDialect {
    public static final String BIGDATE_UDT = "bigdate";
    static final Map<String, Class> TYPE_TO_CLASS_MAP = new HashMap<String, Class>(){
        {
            this.put("GEOMETRY", Geometry.class);
            this.put("GEOGRAPHY", Geometry.class);
            this.put("POINT", Point.class);
            this.put("POINTM", Point.class);
            this.put("LINESTRING", LineString.class);
            this.put("LINESTRINGM", LineString.class);
            this.put("POLYGON", Polygon.class);
            this.put("POLYGONM", Polygon.class);
            this.put("MULTIPOINT", MultiPoint.class);
            this.put("MULTIPOINTM", MultiPoint.class);
            this.put("MULTILINESTRING", MultiLineString.class);
            this.put("MULTILINESTRINGM", MultiLineString.class);
            this.put("MULTIPOLYGON", MultiPolygon.class);
            this.put("MULTIPOLYGONM", MultiPolygon.class);
            this.put("GEOMETRYCOLLECTION", GeometryCollection.class);
            this.put("GEOMETRYCOLLECTIONM", GeometryCollection.class);
            this.put("COMPOUNDCURVE", CompoundCurve.class);
            this.put("MULTICURVE", MultiCurve.class);
            this.put("CURVEPOLYGON", CurvePolygon.class);
            this.put("CIRCULARSTRING", CircularString.class);
            this.put("MULTISURFACE", MultiSurface.class);
            this.put("BYTEA", byte[].class);
        }
    };
    static final Set<Class> NON_CURVED_GEOMETRY_CLASSES = new HashSet<Class>(){
        {
            this.add(Point.class);
            this.add(MultiPoint.class);
            this.add(LineString.class);
            this.add(LinearRing.class);
            this.add(MultiLineString.class);
            this.add(Polygon.class);
            this.add(MultiPolygon.class);
        }
    };
    static final Map<Class, String> CLASS_TO_TYPE_MAP = new HashMap<Class, String>(){
        {
            this.put(Geometry.class, "GEOMETRY");
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINESTRING");
            this.put(Polygon.class, "POLYGON");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINESTRING");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
            this.put(GeometryCollection.class, "GEOMETRYCOLLECTION");
            this.put(CircularString.class, "CIRCULARSTRING");
            this.put(CircularRing.class, "CIRCULARSTRING");
            this.put(MultiCurve.class, "MULTICURVE");
            this.put(CompoundCurve.class, "COMPOUNDCURVE");
            this.put(CompoundRing.class, "COMPOUNDCURVE");
            this.put(byte[].class, "BYTEA");
        }
    };
    static final Version V_1_5_0 = new Version("1.5.0");
    static final Version V_2_0_0 = new Version("2.0.0");
    static final Version V_2_1_0 = new Version("2.1.0");
    static final Version V_2_2_0 = new Version("2.2.0");
    static final Version PGSQL_V_9_0 = new Version("9.0");
    static final Version PGSQL_V_9_1 = new Version("9.1");
    boolean looseBBOXEnabled = false;
    boolean encodeBBOXFilterAsEnvelope = false;
    boolean estimatedExtentsEnabled = false;
    boolean functionEncodingEnabled = false;
    boolean simplifyEnabled = true;
    Version version;
    Version pgsqlVersion;
    ThreadLocal<WKBAttributeIO> wkbReader = new ThreadLocal();

    @Override
    public boolean isAggregatedSortSupported(String function) {
        return "distinct".equalsIgnoreCase(function);
    }

    public PostGISDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEncodeBBOXFilterAsEnvelope() {
        return this.encodeBBOXFilterAsEnvelope;
    }

    public void setEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        this.encodeBBOXFilterAsEnvelope = encodeBBOXFilterAsEnvelope;
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtentsEnabled) {
        this.estimatedExtentsEnabled = estimatedExtentsEnabled;
    }

    public boolean isFunctionEncodingEnabled() {
        return this.functionEncodingEnabled;
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    public boolean isSimplifyEnabled() {
        return this.simplifyEnabled;
    }

    public void setSimplifyEnabled(boolean simplifyEnabled) {
        this.simplifyEnabled = simplifyEnabled;
    }

    @Override
    public void initializeConnection(Connection cx) throws SQLException {
        super.initializeConnection(cx);
        this.getPostgreSQLVersion(cx);
        this.getVersion(cx);
    }

    @Override
    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (tableName.equals("geometry_columns")) {
            return false;
        }
        if (tableName.startsWith("spatial_ref_sys")) {
            return false;
        }
        if (tableName.equals("geography_columns")) {
            return false;
        }
        if (tableName.equals("raster_columns")) {
            return false;
        }
        if (tableName.equals("raster_overviews")) {
            return false;
        }
        return schemaName == null || !schemaName.equals("topology");
    }

    @Override
    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        WKBAttributeIO reader = this.getWKBReader(factory);
        return (Geometry)reader.read(rs, column);
    }

    @Override
    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        WKBAttributeIO reader = this.getWKBReader(factory);
        return (Geometry)reader.read(rs, column);
    }

    private WKBAttributeIO getWKBReader(GeometryFactory factory) {
        WKBAttributeIO reader = this.wkbReader.get();
        if (reader == null) {
            reader = new WKBAttributeIO(factory);
            this.wkbReader.set(reader);
        } else {
            reader.setGeometryFactory(factory);
        }
        return reader;
    }

    @Override
    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql) {
        this.encodeGeometryColumn(gatt, prefix, srid, null, sql);
    }

    @Override
    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        boolean geography = "geography".equals(gatt.getUserData().get("org.geotools.jdbc.nativeTypeName"));
        if (geography) {
            sql.append("encode(ST_AsBinary(");
            this.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append("),'base64')");
        } else {
            boolean force2D;
            boolean bl = force2D = hints != null && hints.containsKey((Object)Hints.FEATURE_2D) && Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D));
            if (force2D) {
                sql.append("encode(ST_AsBinary(" + this.getForce2DFunction() + "(");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append(")),'base64')");
            } else {
                sql.append("encode(ST_AsEWKB(");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append("),'base64')");
            }
        }
    }

    @Override
    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        if (!this.isSimplifyEnabled()) {
            super.encodeGeometryColumnSimplified(gatt, prefix, srid, sql, distance);
        } else {
            String preserveCollapsed = this.version.compareTo(V_2_2_0) >= 0 ? ", true" : "";
            boolean geography = "geography".equals(gatt.getUserData().get("org.geotools.jdbc.nativeTypeName"));
            if (geography) {
                sql.append("encode(ST_AsBinary(");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append("),'base64')");
            } else if (NON_CURVED_GEOMETRY_CLASSES.contains(gatt.getType().getBinding())) {
                sql.append("encode(ST_AsBinary(ST_Simplify(" + this.getForce2DFunction() + "(");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append("), " + distance + preserveCollapsed + ")),'base64')");
            } else {
                sql.append("encode(ST_AsBinary(");
                sql.append("CASE WHEN ST_HasArc(");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append(") THEN ");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append(" ELSE ");
                sql.append("ST_Simplify(" + this.getForce2DFunction() + "(");
                this.encodeColumnName(prefix, gatt.getLocalName(), sql);
                sql.append("), " + distance + preserveCollapsed + ") END),'base64')");
            }
        }
    }

    @Override
    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_AsText(" + this.getForce2DFunction() + "(ST_Envelope(");
        sql.append("ST_Extent(\"" + geometryColumn + "\"::geometry))))");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ArrayList<ReferencedEnvelope> result;
        ResultSet rs;
        Statement st;
        block12: {
            if (!this.estimatedExtentsEnabled) {
                return null;
            }
            String tableName = featureType.getTypeName();
            if (this.dataStore.getVirtualTables().get(tableName) != null) {
                return null;
            }
            st = null;
            rs = null;
            result = new ArrayList<ReferencedEnvelope>();
            Savepoint savePoint = null;
            try {
                st = cx.createStatement();
                if (!cx.getAutoCommit()) {
                    savePoint = cx.setSavepoint();
                }
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    Envelope env;
                    if (!(att instanceof GeometryDescriptor)) continue;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select ST_AsText(" + this.getForce2DFunction() + "(ST_Envelope(" + this.getEstimatedExtentFunction() + "('");
                    if (schema != null) {
                        sql.append(schema);
                        sql.append("', '");
                    }
                    sql.append(tableName);
                    sql.append("', '");
                    sql.append(att.getName().getLocalPart());
                    sql.append("'))))");
                    rs = st.executeQuery(sql.toString());
                    if (rs.next() && !(env = this.decodeGeometryEnvelope(rs, 1, cx)).isNull()) {
                        CoordinateReferenceSystem crs = ((GeometryDescriptor)att).getCoordinateReferenceSystem();
                        result.add(new ReferencedEnvelope(env, crs));
                    }
                    rs.close();
                }
                if (savePoint == null) break block12;
            }
            catch (SQLException e) {
                List<ReferencedEnvelope> list;
                block13: {
                    try {
                        if (savePoint != null) {
                            cx.rollback(savePoint);
                        }
                        LOGGER.log(Level.WARNING, "Failed to use " + this.getEstimatedExtentFunction() + ", falling back on envelope aggregation", e);
                        list = null;
                        if (savePoint == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (savePoint != null) {
                            cx.releaseSavepoint(savePoint);
                        }
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe(st);
                        throw throwable;
                    }
                    cx.releaseSavepoint(savePoint);
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                return list;
            }
            cx.releaseSavepoint(savePoint);
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(st);
        return result;
    }

    @Override
    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        try {
            String envelope = rs.getString(column);
            if (envelope != null) {
                return new WKTReader().read(envelope).getEnvelopeInternal();
            }
            return new Envelope();
        }
        catch (ParseException e) {
            throw (IOException)new IOException("Error occurred parsing the bounds WKT").initCause(e);
        }
    }

    @Override
    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String typeName = columnMetaData.getString("TYPE_NAME");
        if ("uuid".equalsIgnoreCase(typeName)) {
            return UUID.class;
        }
        if ("citext".equalsIgnoreCase(typeName)) {
            return String.class;
        }
        if (BIGDATE_UDT.equalsIgnoreCase(typeName)) {
            return BigDate.class;
        }
        String gType = null;
        if ("geometry".equalsIgnoreCase(typeName)) {
            gType = this.lookupGeometryType(columnMetaData, cx, "geometry_columns", "f_geometry_column");
        } else if ("geography".equalsIgnoreCase(typeName)) {
            gType = this.lookupGeometryType(columnMetaData, cx, "geography_columns", "f_geography_column");
        } else {
            return null;
        }
        if (gType == null) {
            return Geometry.class;
        }
        Class<Geometry> geometryClass = TYPE_TO_CLASS_MAP.get(gType.toUpperCase());
        if (geometryClass == null) {
            geometryClass = Geometry.class;
        }
        return geometryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lookupGeometryType(ResultSet columnMetaData, Connection cx, String gTableName, String gColumnName) throws SQLException {
        String tableName = columnMetaData.getString("TABLE_NAME");
        String columnName = columnMetaData.getString("COLUMN_NAME");
        String schemaName = columnMetaData.getString("TABLE_SCHEM");
        Object conn = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            String sqlStatement = "SELECT TYPE FROM " + gTableName + " WHERE " + "F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND " + gColumnName + " = '" + columnName + "'";
            LOGGER.log(Level.FINE, "Geometry type check; {0} ", sqlStatement);
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                String string = result.getString(1);
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                return string;
            }
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            throw throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUserDefinedType(ResultSet columnMetaData, ColumnMetadata metadata, Connection cx) throws SQLException {
        String tableName = columnMetaData.getString("TABLE_NAME");
        String columnName = columnMetaData.getString("COLUMN_NAME");
        String schemaName = columnMetaData.getString("TABLE_SCHEM");
        String sql = "SELECT udt_name FROM information_schema.columns  WHERE table_schema = '" + schemaName + "' " + "   AND table_name = '" + tableName + "' " + "   AND column_name = '" + columnName + "' ";
        LOGGER.fine(sql);
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    metadata.setTypeName(rs.getString(1));
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sqlStatement;
        Integer srid;
        ResultSet result;
        Statement statement;
        block17: {
            statement = null;
            result = null;
            srid = null;
            try {
                if (schemaName == null) {
                    schemaName = "public";
                }
                if (!this.supportsGeography(cx)) break block17;
                try {
                    sqlStatement = "SELECT SRID FROM GEOGRAPHY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOGRAPHY_COLUMN = '" + columnName + "'";
                    LOGGER.log(Level.FINE, "Geography srid check; {0} ", sqlStatement);
                    statement = cx.createStatement();
                    result = statement.executeQuery(sqlStatement);
                    if (result.next()) {
                        Integer n = 4326;
                        this.dataStore.closeSafe(result);
                        this.dataStore.closeSafe(result);
                        this.dataStore.closeSafe(statement);
                        return n;
                    }
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking geometry_columns instead", e);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                throw throwable;
            }
            this.dataStore.closeSafe(result);
            break block17;
            finally {
                this.dataStore.closeSafe(result);
            }
        }
        try {
            sqlStatement = "SELECT SRID FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOMETRY_COLUMN = '" + columnName + "'";
            LOGGER.log(Level.FINE, "Geometry srid check; {0} ", sqlStatement);
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                srid = result.getInt(1);
            }
            this.dataStore.closeSafe(result);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking the first geometry instead", e);
        }
        finally {
            this.dataStore.closeSafe(result);
        }
        if ((srid == null || this.getVersion(cx).compareTo(V_2_0_0) >= 0 && srid == 0) && (result = statement.executeQuery(sqlStatement = "SELECT ST_SRID(\"" + columnName + "\") " + "FROM \"" + schemaName + "\".\"" + tableName + "\" " + "WHERE \"" + columnName + "\" IS NOT NULL " + "LIMIT 1")).next()) {
            srid = result.getInt(1);
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sqlStatement;
        Integer dimension;
        ResultSet result;
        Statement statement;
        block17: {
            statement = null;
            result = null;
            dimension = null;
            try {
                if (schemaName == null) {
                    schemaName = "public";
                }
                if (!this.supportsGeography(cx)) break block17;
                try {
                    sqlStatement = "SELECT COORD_DIMENSION FROM GEOGRAPHY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOGRAPHY_COLUMN = '" + columnName + "'";
                    LOGGER.log(Level.FINE, "Geography srid check; {0} ", sqlStatement);
                    statement = cx.createStatement();
                    result = statement.executeQuery(sqlStatement);
                    if (result.next()) {
                        int n = result.getInt(1);
                        this.dataStore.closeSafe(result);
                        this.dataStore.closeSafe(result);
                        this.dataStore.closeSafe(statement);
                        return n;
                    }
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geography_columns table, checking geometry_columns instead", e);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                throw throwable;
            }
            this.dataStore.closeSafe(result);
            break block17;
            finally {
                this.dataStore.closeSafe(result);
            }
        }
        try {
            sqlStatement = "SELECT COORD_DIMENSION FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOMETRY_COLUMN = '" + columnName + "'";
            LOGGER.log(Level.FINE, "Geometry srid check; {0} ", sqlStatement);
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                dimension = result.getInt(1);
            }
            this.dataStore.closeSafe(result);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking the first geometry instead", e);
        }
        finally {
            this.dataStore.closeSafe(result);
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        if (dimension == null) {
            dimension = this.getDimensionFromFirstGeo(schemaName, tableName, columnName, cx);
        }
        if (dimension != null) return dimension;
        dimension = 2;
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getDimensionFromFirstGeo(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String dimFunction = this.getVersion(cx).compareTo(V_2_0_0) >= 0 ? "ST_DIMENSION" : "DIMENSION";
        Statement statement = null;
        ResultSet result = null;
        try {
            String sqlStatement = "SELECT " + dimFunction + "(\"" + columnName + "\"::geometry) " + "FROM \"" + schemaName + "\".\"" + tableName + "\" " + "WHERE " + columnName + " IS NOT NULL " + "LIMIT 1";
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                Integer n = result.getInt(1);
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                return n;
            }
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " by examining the first sample geometry", e);
        }
        finally {
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT pg_get_serial_sequence('\"";
            if (schemaName != null && !"".equals(schemaName)) {
                sql = sql + schemaName + "\".\"";
            }
            sql = sql + tableName + "\"', '" + columnName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT " + this.encodeNextSequenceValue(schemaName, sequenceName);
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    @Override
    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        return "nextval('" + sequenceName + "')";
    }

    @Override
    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sequenceName = this.getSequenceForColumn(schemaName, tableName, columnName, cx);
            if (sequenceName == null) {
                Object var7_7 = null;
                return var7_7;
            }
            String sql = "SELECT currval('" + sequenceName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    @Override
    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
        mappings.put(UUID.class, 1111);
        mappings.put(BigDate.class, -5);
    }

    @Override
    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("geometry", Geometry.class);
        mappings.put("geography", Geometry.class);
        mappings.put("text", String.class);
        mappings.put("int8", Long.class);
        mappings.put("int4", Integer.class);
        mappings.put("bool", Boolean.class);
        mappings.put("character", String.class);
        mappings.put("float8", Double.class);
        mappings.put("int", Integer.class);
        mappings.put("float4", Float.class);
        mappings.put("int2", Short.class);
        mappings.put("time", Time.class);
        mappings.put("timetz", Time.class);
        mappings.put("timestamp", Timestamp.class);
        mappings.put("timestamptz", Timestamp.class);
        mappings.put("uuid", UUID.class);
    }

    @Override
    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(12, "VARCHAR");
        overrides.put(16, "BOOL");
        overrides.put(2004, "BYTEA");
    }

    @Override
    public String getGeometryTypeName(Integer type) {
        return "geometry";
    }

    @Override
    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" SERIAL PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        schemaName = schemaName != null ? schemaName : "public";
        String tableName = featureType.getName().getLocalPart();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                String geomType;
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)att;
                int srid = -1;
                if (gd.getUserData().get("nativeSRID") != null) {
                    srid = (Integer)gd.getUserData().get("nativeSRID");
                } else if (gd.getCoordinateReferenceSystem() != null) {
                    try {
                        Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)true);
                        if (result != null) {
                            srid = result;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                    }
                }
                int dimensions = 2;
                if (gd.getUserData().get(Hints.COORDINATE_DIMENSION) != null) {
                    dimensions = (Integer)gd.getUserData().get(Hints.COORDINATE_DIMENSION);
                }
                if ((geomType = CLASS_TO_TYPE_MAP.get(gd.getType().getBinding())) == null) {
                    geomType = "GEOMETRY";
                }
                String sql = null;
                if (this.getVersion(cx).compareTo(V_2_0_0) >= 0) {
                    if (dimensions == 3) {
                        geomType = geomType + "Z";
                    } else if (dimensions == 4) {
                        geomType = geomType + "ZM";
                    } else if (dimensions > 4) {
                        throw new IllegalArgumentException("PostGIS only supports geometries with 2, 3 and 4 dimensions, current value: " + dimensions);
                    }
                    sql = "ALTER TABLE \"" + schemaName + "\".\"" + tableName + "\" " + "ALTER COLUMN \"" + gd.getLocalName() + "\" " + "TYPE geometry (" + geomType + ", " + srid + ");";
                    LOGGER.fine(sql);
                    st.execute(sql);
                } else {
                    sql = "DELETE FROM GEOMETRY_COLUMNS WHERE f_table_catalog='' AND f_table_schema = '" + schemaName + "'" + " AND f_table_name = '" + tableName + "'" + " AND f_geometry_column = '" + gd.getLocalName() + "'";
                    LOGGER.fine(sql);
                    st.execute(sql);
                    sql = "INSERT INTO GEOMETRY_COLUMNS VALUES ('','" + schemaName + "'," + "'" + tableName + "'," + "'" + gd.getLocalName() + "'," + dimensions + "," + srid + "," + "'" + geomType + "')";
                    LOGGER.fine(sql);
                    st.execute(sql);
                    if (srid > -1) {
                        sql = "ALTER TABLE \"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_srid_" + gd.getLocalName() + "\"" + " CHECK (ST_SRID(" + "\"" + gd.getLocalName() + "\"" + ") = " + srid + ")";
                        LOGGER.fine(sql);
                        st.execute(sql);
                    }
                    sql = "ALTER TABLE \"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_dims_" + gd.getLocalName() + "\"" + " CHECK (st_ndims(\"" + gd.getLocalName() + "\")" + " = " + dimensions + ")";
                    LOGGER.fine(sql);
                    st.execute(sql);
                    if (!geomType.equals("GEOMETRY")) {
                        sql = "ALTER TABLE \"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_geotype_" + gd.getLocalName() + "\"" + " CHECK (geometrytype(" + "\"" + gd.getLocalName() + "\"" + ") = '" + geomType + "'::text " + "OR \"" + gd.getLocalName() + "\"" + " IS NULL)";
                        LOGGER.fine(sql);
                        st.execute(sql);
                    }
                }
                sql = "CREATE INDEX \"spatial_" + tableName + "_" + gd.getLocalName().toLowerCase() + "\"" + " ON " + "\"" + schemaName + "\"" + "." + "\"" + tableName + "\"" + " USING GIST (" + "\"" + gd.getLocalName() + "\"" + ")";
                LOGGER.fine(sql);
                st.execute(sql);
            }
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        String tableName = featureType.getTypeName();
        try {
            String sql = "DELETE FROM GEOMETRY_COLUMNS WHERE f_table_catalog='' AND f_table_schema = '" + schemaName + "'" + " AND f_table_name = '" + tableName + "'";
            LOGGER.fine(sql);
            st.execute(sql);
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    @Override
    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        if (value == null || value.isEmpty()) {
            sql.append("NULL");
        } else {
            if (value instanceof LinearRing && !(value instanceof CurvedRing)) {
                value = value.getFactory().createLineString(((LinearRing)value).getCoordinateSequence());
            }
            WKTWriter2 writer = new WKTWriter2(dimension);
            String wkt = writer.write(value);
            sql.append("ST_GeomFromText('" + wkt + "', " + srid + ")");
        }
    }

    @Override
    public FilterToSQL createFilterToSQL() {
        PostgisFilterToSQL sql = new PostgisFilterToSQL(this);
        sql.setLooseBBOXEnabled(this.looseBBOXEnabled);
        sql.setEncodeBBOXFilterAsEnvelope(this.encodeBBOXFilterAsEnvelope);
        sql.setFunctionEncodingEnabled(this.functionEncodingEnabled);
        return sql;
    }

    @Override
    public boolean isLimitOffsetSupported() {
        return true;
    }

    @Override
    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET " + offset);
        }
    }

    @Override
    public void encodeValue(Object value, Class type, StringBuffer sql) {
        if (byte[].class.equals((Object)type)) {
            byte[] input = (byte[])value;
            if (this.pgsqlVersion.compareTo(PGSQL_V_9_1) >= 0) {
                this.encodeByteArrayAsHex(input, sql);
            } else {
                this.encodeByteArrayAsEscape(input, sql);
            }
            return;
        }
        if (BigDate.class.isAssignableFrom(type) && value instanceof Date) {
            super.encodeValue(((Date)value).getTime(), Long.class, sql);
            return;
        }
        super.encodeValue(value, type, sql);
    }

    void encodeByteArrayAsHex(byte[] input, StringBuffer sql) {
        StringBuffer sb = new StringBuffer("\\x");
        for (int i = 0; i < input.length; ++i) {
            sb.append(String.format("%02x", input[i]));
        }
        super.encodeValue(sb.toString(), String.class, sql);
    }

    void encodeByteArrayAsEscape(byte[] input, StringBuffer sql) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            byte b = input[i];
            if (b == 0) {
                sb.append("\\\\000");
                continue;
            }
            if (b == 39) {
                sb.append("\\'");
                continue;
            }
            if (b == 92) {
                sb.append("\\\\134'");
                continue;
            }
            if (b < 31 || b >= 127) {
                sb.append("\\\\");
                String octal = Integer.toOctalString(b);
                if (octal.length() == 1) {
                    sb.append("00");
                } else if (octal.length() == 2) {
                    sb.append("0");
                }
                sb.append(octal);
                continue;
            }
            sb.append((char)b);
        }
        super.encodeValue(sb.toString(), String.class, sql);
    }

    @Override
    public int getDefaultVarcharSize() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion(Connection conn) throws SQLException {
        if (this.version == null) {
            Statement st = null;
            ResultSet rs = null;
            try {
                st = conn.createStatement();
                rs = st.executeQuery("select PostGIS_Lib_Version()");
                if (rs.next()) {
                    this.version = new Version(rs.getString(1));
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                throw throwable;
            }
        }
        return this.version;
    }

    public Version getPostgreSQLVersion(Connection conn) throws SQLException {
        if (this.pgsqlVersion == null) {
            DatabaseMetaData md = conn.getMetaData();
            this.pgsqlVersion = new Version(String.format("%d.%d", md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()));
        }
        return this.pgsqlVersion;
    }

    boolean supportsGeography(Connection cx) throws SQLException {
        return this.getVersion(cx).compareTo(V_1_5_0) >= 0;
    }

    @Override
    protected void addSupportedHints(Set<Hints.Key> hints) {
        if (this.isSimplifyEnabled()) {
            hints.add(Hints.GEOMETRY_SIMPLIFICATION);
        }
    }

    protected String getForce2DFunction() {
        return this.version == null || this.version.compareTo(V_2_1_0) >= 0 ? "ST_Force2D" : "ST_Force_2D";
    }

    protected String getEstimatedExtentFunction() {
        return this.version == null || this.version.compareTo(V_2_1_0) >= 0 ? "ST_EstimatedExtent" : "ST_Estimated_Extent";
    }
}

