/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnDiffEditor
implements ISVNEditor,
ISVNUpdateEditor {
    private SVNDepth depth;
    private SVNWCContext context;
    private ISVNWCDb db;
    private File anchorAbspath;
    private String target;
    private boolean useTextBase;
    private boolean showCopiesAsAdds;
    private ISvnDiffCallback callback;
    private Collection<String> changelists;
    private boolean ignoreAncestry;
    private boolean useGitDiffFormat;
    private ISVNCanceller canceller;
    private boolean reverseOrder;
    private long revision;
    private boolean rootOpened;
    private Entry rootEntry;
    private Entry currentEntry;
    private Collection<File> tempFiles;
    private final SVNDeltaProcessor deltaProcessor;

    public SvnDiffEditor(File anchorAbspath, String target, ISvnDiffCallback callback, SVNDepth depth, SVNWCContext context, boolean reverseOrder, boolean useTextBase, boolean showCopiesAsAdds, boolean ignoreAncestry, Collection<String> changelists, boolean useGitDiffFormat, ISVNCanceller canceller) {
        this.depth = depth;
        this.context = context;
        this.db = context.getDb();
        this.anchorAbspath = anchorAbspath;
        this.target = target;
        this.useTextBase = useTextBase;
        this.showCopiesAsAdds = showCopiesAsAdds;
        this.callback = callback;
        this.changelists = changelists;
        this.ignoreAncestry = ignoreAncestry;
        this.useGitDiffFormat = useGitDiffFormat;
        this.canceller = canceller;
        this.reverseOrder = reverseOrder;
        this.deltaProcessor = new SVNDeltaProcessor();
        this.tempFiles = new ArrayList<File>();
    }

    public SvnDiffEditor() {
        this.deltaProcessor = new SVNDeltaProcessor();
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.revision = revision;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.rootOpened = true;
        this.currentEntry = this.rootEntry = new Entry(false, "", null, false, this.depth, this.anchorAbspath);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        File localAbspath = this.getLocalAbspath(path);
        this.addToCompared(this.currentEntry, path);
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.db.readInfo(localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        if (!this.useTextBase && status == ISVNWCDb.SVNWCDbStatus.Deleted) {
            return;
        }
        switch (kind) {
            case File: 
            case Symlink: {
                if (this.reverseOrder) {
                    File textBase = this.getPristineFile(localAbspath, this.useTextBase);
                    SVNProperties baseProps = this.context.getPristineProps(localAbspath);
                    String baseMimeType = this.getPropMimeType(baseProps);
                    this.callback.fileDeleted(null, localAbspath, textBase, null, baseMimeType, null, baseProps);
                    break;
                }
                this.reportFileAdded(localAbspath, path);
                break;
            }
            case Dir: {
                this.reportDirectoryAdded(localAbspath, path, SVNDepth.INFINITY);
                break;
            }
        }
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNDepth subdirDepth = this.depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : this.depth;
        this.addToCompared(this.currentEntry, path);
        this.currentEntry = new Entry(false, path, this.currentEntry, true, subdirDepth, this.getLocalAbspath(path));
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        SVNDepth subdirDepth = this.depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : this.depth;
        this.addToCompared(this.currentEntry, path);
        this.currentEntry = new Entry(false, path, this.currentEntry, false, subdirDepth, this.getLocalAbspath(path));
    }

    @Override
    public void closeDir() throws SVNException {
        if (!this.currentEntry.propChanges.isEmpty()) {
            SVNProperties originalProps;
            if (this.currentEntry.added) {
                originalProps = new SVNProperties();
            } else if (this.useTextBase) {
                originalProps = this.context.getPristineProps(this.currentEntry.localAbspath);
            } else {
                originalProps = this.context.getActualProps(this.currentEntry.localAbspath);
                SVNProperties baseProps = this.context.getPristineProps(this.currentEntry.localAbspath);
                SVNProperties reposProps = this.applyPropsChanges(baseProps, this.currentEntry.propChanges);
                this.currentEntry.propChanges = SvnDiffEditor.computePropDiff(originalProps, reposProps);
            }
            if (!this.reverseOrder) {
                SvnDiffEditor.reversePropChanges(originalProps, this.currentEntry.propChanges);
            }
            this.callback.dirPropsChanged(null, this.currentEntry.localAbspath, this.currentEntry.added, this.currentEntry.propChanges, originalProps);
            this.addToCompared(this.currentEntry, this.currentEntry.path);
        }
        if (!this.currentEntry.added) {
            this.walkLocalNodesDiff(this.currentEntry.localAbspath, this.currentEntry.path, this.currentEntry.depth, this.currentEntry.compared);
        }
        this.callback.dirClosed(null, this.currentEntry.localAbspath, this.currentEntry.added);
        this.currentEntry = this.currentEntry.parent;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.addToCompared(this.currentEntry, path);
        this.currentEntry = new Entry(true, path, this.currentEntry, true, SVNDepth.UNKNOWN, this.getLocalAbspath(path));
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        this.addToCompared(this.currentEntry, path);
        this.currentEntry = new Entry(true, path, this.currentEntry, false, SVNDepth.UNKNOWN, this.getLocalAbspath(path));
        ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(this.currentEntry.localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
        this.currentEntry.baseChecksum = baseInfo.checksum;
        this.callback.fileOpened(null, this.currentEntry.localAbspath, revision);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        InputStream sourceStream = this.currentEntry.baseChecksum != null ? this.db.readPristine(this.currentEntry.localAbspath, this.currentEntry.baseChecksum) : SVNFileUtil.DUMMY_IN;
        this.currentEntry.file = this.createTempFile(this.db.getWCRootTempDir(this.currentEntry.localAbspath));
        this.deltaProcessor.applyTextDelta(sourceStream, this.currentEntry.file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        try {
            SVNProperties originalProps;
            File localFile;
            boolean modified;
            File reposFile;
            File pristineFile;
            SVNProperties pristineProps;
            boolean hadProps;
            SvnChecksum pristineChecksum;
            ISVNWCDb.SVNWCDbStatus status;
            if (textChecksum != null) {
                SvnChecksum reposChecksum = this.currentEntry.resultChecksum;
                if (reposChecksum == null) {
                    reposChecksum = this.currentEntry.baseChecksum;
                }
                if (reposChecksum.getKind() != SvnChecksum.Kind.md5) {
                    reposChecksum = this.db.getPristineMD5(this.currentEntry.localAbspath, reposChecksum);
                }
                if (!reposChecksum.getDigest().equals(textChecksum)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)this.currentEntry.localAbspath);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
            }
            try {
                Structure<StructureFields.NodeInfo> nodeInfoStructure = this.db.readInfo(this.currentEntry.localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod);
                status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
                pristineChecksum = (SvnChecksum)nodeInfoStructure.get(StructureFields.NodeInfo.checksum);
                hadProps = nodeInfoStructure.is(StructureFields.NodeInfo.hadProps);
                boolean propsMod = nodeInfoStructure.is(StructureFields.NodeInfo.propsMod);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    status = ISVNWCDb.SVNWCDbStatus.NotPresent;
                    pristineChecksum = null;
                    hadProps = false;
                    boolean propsMod = false;
                }
                throw e;
            }
            if (this.currentEntry.added) {
                pristineProps = new SVNProperties();
                pristineFile = null;
            } else {
                if (status != ISVNWCDb.SVNWCDbStatus.Normal) {
                    Structure<StructureFields.NodeInfo> nodeInfoStructure = SvnWcDbShared.getBaseInfo((SVNWCDb)this.db, this.currentEntry.localAbspath, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.hadProps);
                    pristineChecksum = (SvnChecksum)nodeInfoStructure.get(StructureFields.NodeInfo.checksum);
                    hadProps = nodeInfoStructure.is(StructureFields.NodeInfo.hadProps);
                }
                pristineFile = this.db.getPristinePath(this.currentEntry.localAbspath, pristineChecksum);
                pristineProps = hadProps ? this.db.getBaseProps(this.currentEntry.localAbspath) : new SVNProperties();
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                ISVNWCDb.WCDbAdditionInfo wcDbAdditionInfo = this.db.scanAddition(this.currentEntry.localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status);
                status = wcDbAdditionInfo.status;
            }
            SVNProperties reposProps = this.applyPropsChanges(pristineProps, this.currentEntry.propChanges);
            String reposMimeType = this.getPropMimeType(reposProps);
            File file = reposFile = this.currentEntry.file != null ? this.currentEntry.file : pristineFile;
            if (this.currentEntry.added || !this.useTextBase && status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                if (this.reverseOrder) {
                    this.callback.fileAdded(null, this.currentEntry.localAbspath, null, reposFile, 0L, this.revision, null, reposMimeType, null, -1L, this.currentEntry.propChanges, new SVNProperties());
                } else {
                    this.callback.fileDeleted(null, this.currentEntry.localAbspath, reposFile, null, reposMimeType, null, reposProps);
                }
                return;
            }
            if ((status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere) && this.showCopiesAsAdds) {
                this.callback.fileAdded(null, this.currentEntry.localAbspath, null, this.currentEntry.localAbspath, 0L, this.revision, null, reposMimeType, null, -1L, this.currentEntry.propChanges, new SVNProperties());
                return;
            }
            boolean bl = modified = this.currentEntry.file != null;
            if (!modified && !this.useTextBase) {
                modified = this.context.isTextModified(this.currentEntry.localAbspath, false);
            }
            if (modified) {
                localFile = this.useTextBase ? this.getPristineFile(this.currentEntry.localAbspath, false) : this.context.getTranslatedFile(this.currentEntry.localAbspath, this.currentEntry.localAbspath, true, false, false, false, false);
            } else {
                reposFile = null;
                localFile = null;
            }
            if (this.useTextBase) {
                originalProps = pristineProps;
            } else {
                originalProps = this.context.getActualProps(this.currentEntry.localAbspath);
                this.currentEntry.propChanges = SvnDiffEditor.computePropDiff(originalProps, reposProps);
            }
            if (localFile != null || !this.currentEntry.propChanges.isEmpty()) {
                String originalMimeType = this.getPropMimeType(originalProps);
                if (!this.currentEntry.propChanges.isEmpty() && !this.reverseOrder) {
                    SvnDiffEditor.reversePropChanges(originalProps, this.currentEntry.propChanges);
                }
                this.callback.fileChanged(null, this.currentEntry.localAbspath, this.reverseOrder ? localFile : reposFile, this.reverseOrder ? reposFile : localFile, this.reverseOrder ? -1L : this.revision, this.reverseOrder ? this.revision : -1L, this.reverseOrder ? originalMimeType : reposMimeType, this.reverseOrder ? reposMimeType : originalMimeType, this.currentEntry.propChanges, originalProps);
                return;
            }
        }
        finally {
            this.currentEntry = this.currentEntry.parent;
        }
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        this.currentEntry.propChanges.put(name, value);
    }

    @Override
    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        this.currentEntry.propChanges.put(propertyName, propertyValue);
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.rootOpened) {
            this.walkLocalNodesDiff(this.anchorAbspath, "", this.depth, null);
        }
        return null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.deltaProcessor.textDeltaChunk(diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        String checksum = this.deltaProcessor.textDeltaEnd();
        this.currentEntry.resultChecksum = new SvnChecksum(SvnChecksum.Kind.md5, checksum);
    }

    private File getPristineFile(File localAbspath, boolean useTextBase) throws SVNException {
        SvnChecksum checksum;
        if (!useTextBase) {
            Structure<StructureFields.PristineInfo> pristineInfoStructure = this.db.readPristineInfo(localAbspath);
            checksum = (SvnChecksum)pristineInfoStructure.get(StructureFields.PristineInfo.checksum);
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
            checksum = baseInfo.checksum;
        }
        if (checksum != null) {
            return this.db.getPristinePath(localAbspath, checksum);
        }
        return null;
    }

    private String getPropMimeType(SVNProperties baseProps) {
        if (baseProps == null) {
            return null;
        }
        return baseProps.getStringValue("svn:mime-type");
    }

    private void reportFileAdded(File localAbspath, String path) throws SVNException {
        if (!this.context.matchesChangelist(localAbspath, this.changelists)) {
            return;
        }
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.db.readInfo(localAbspath, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.status);
        long revision = nodeInfoStructure.lng(StructureFields.NodeInfo.revision);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo wcDbAdditionInfo = this.db.scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status);
            status = wcDbAdditionInfo.status;
        }
        assert (status != ISVNWCDb.SVNWCDbStatus.Deleted || this.useTextBase);
        if (status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere) {
            if (this.useTextBase) {
                return;
            }
            this.fileDiff(localAbspath, path);
        }
        SVNProperties emptyProps = new SVNProperties();
        SVNProperties wcProps = this.useTextBase ? this.context.getPristineProps(localAbspath) : this.context.getActualProps(localAbspath);
        String mimeType = this.getPropMimeType(wcProps);
        SVNProperties propchanges = SvnDiffEditor.computePropDiff(emptyProps, wcProps);
        File sourceFile = this.useTextBase ? this.getPristineFile(localAbspath, false) : localAbspath;
        File translatedFile = this.context.getTranslatedFile(sourceFile, localAbspath, true, false, false, false, false);
        this.callback.fileAdded(null, localAbspath, null, translatedFile, 0L, revision, null, mimeType, null, -1L, propchanges, emptyProps);
    }

    private void reportDirectoryAdded(File localAbspath, String path, SVNDepth depth) throws SVNException {
        SVNProperties wcProps;
        SVNProperties propChanges;
        SVNProperties emptyProps = new SVNProperties();
        if (this.context.matchesChangelist(localAbspath, this.changelists) && !(propChanges = SvnDiffEditor.computePropDiff(emptyProps, wcProps = this.useTextBase ? this.context.getPristineProps(localAbspath) : this.context.getActualProps(localAbspath))).isEmpty()) {
            this.callback.dirPropsChanged(null, localAbspath, true, propChanges, emptyProps);
        }
        Set<String> children = this.db.readChildren(localAbspath);
        for (String name : children) {
            this.checkCancelled();
            File childAbspath = new File(localAbspath, name);
            Structure<StructureFields.NodeInfo> nodeInfoStructure = this.db.readInfo(childAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
            ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
            ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
            if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || !this.useTextBase && status == ISVNWCDb.SVNWCDbStatus.Deleted) continue;
            String childPath = SVNPathUtil.append(path, name);
            switch (kind) {
                case File: 
                case Symlink: {
                    this.reportFileAdded(childAbspath, childPath);
                    break;
                }
                case Dir: {
                    if (depth.compareTo(SVNDepth.FILES) <= 0 && depth != SVNDepth.UNKNOWN) break;
                    SVNDepth depthBelowHere = depth;
                    if (depthBelowHere == SVNDepth.IMMEDIATES) {
                        depthBelowHere = SVNDepth.EMPTY;
                    }
                    this.reportDirectoryAdded(childAbspath, childPath, depthBelowHere);
                    break;
                }
            }
        }
    }

    private void fileDiff(File localAbspath, String path) throws SVNException {
        boolean useBase = false;
        assert (!this.useTextBase);
        if (!this.context.matchesChangelist(localAbspath, this.changelists)) {
            return;
        }
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.db.readInfo(localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.haveBase);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        long revision = nodeInfoStructure.lng(StructureFields.NodeInfo.revision);
        boolean haveBase = nodeInfoStructure.is(StructureFields.NodeInfo.haveBase);
        ISVNWCDb.SVNWCDbStatus baseStatus = null;
        long revertBaseRevision = -1L;
        if (haveBase) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision);
            baseStatus = baseInfo.status;
            revertBaseRevision = baseInfo.revision;
        }
        boolean replaced = status == ISVNWCDb.SVNWCDbStatus.Added && haveBase && baseStatus != ISVNWCDb.SVNWCDbStatus.NotPresent;
        File originalReposRelpath = null;
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo wcDbAdditionInfo = this.db.scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.originalReposRelPath);
            status = wcDbAdditionInfo.status;
            originalReposRelpath = wcDbAdditionInfo.originalReposRelPath;
        }
        if (replaced && status != ISVNWCDb.SVNWCDbStatus.Copied && status != ISVNWCDb.SVNWCDbStatus.MovedHere) {
            useBase = true;
            revision = revertBaseRevision;
        }
        File textBase = this.getPristineFile(localAbspath, useBase);
        if (!replaced && status == ISVNWCDb.SVNWCDbStatus.Deleted || replaced && !this.ignoreAncestry) {
            SVNProperties baseProps = this.context.getPristineProps(localAbspath);
            String baseMimeType = baseProps != null ? this.getPropMimeType(baseProps) : null;
            this.callback.fileDeleted(null, localAbspath, textBase, null, baseMimeType, null, baseProps);
            if (!replaced || this.ignoreAncestry) {
                return;
            }
        }
        File translatedFile = null;
        if (!replaced && status == ISVNWCDb.SVNWCDbStatus.Added || replaced && !this.ignoreAncestry || (status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere) && (this.showCopiesAsAdds || this.useGitDiffFormat)) {
            SVNProperties workingProps = this.context.getActualProps(localAbspath);
            String workingMimeType = this.getPropMimeType(workingProps);
            SVNProperties baseProps = new SVNProperties();
            SVNProperties propChanges = SvnDiffEditor.computePropDiff(baseProps, workingProps);
            translatedFile = this.context.getTranslatedFile(localAbspath, localAbspath, true, false, false, false, false);
            this.callback.fileAdded(null, localAbspath, !this.showCopiesAsAdds && this.useGitDiffFormat && status != ISVNWCDb.SVNWCDbStatus.Added ? textBase : null, translatedFile, 0L, revision, null, workingMimeType, originalReposRelpath, -1L, propChanges, baseProps);
        } else {
            SVNProperties baseProps;
            boolean modified = this.context.isTextModified(localAbspath, false);
            if (modified) {
                translatedFile = this.context.getTranslatedFile(localAbspath, localAbspath, true, false, false, false, false);
            }
            if (replaced && this.ignoreAncestry) {
                baseProps = this.db.getBaseProps(localAbspath);
            } else {
                assert (!replaced || status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere);
                baseProps = this.context.getPristineProps(localAbspath);
                if (baseProps == null) {
                    baseProps = new SVNProperties();
                }
            }
            String baseMimeType = this.getPropMimeType(baseProps);
            SVNProperties workingProps = this.context.getActualProps(localAbspath);
            String workingMimeType = this.getPropMimeType(workingProps);
            SVNProperties propChanges = SvnDiffEditor.computePropDiff(baseProps, workingProps);
            if (modified || !propChanges.isEmpty()) {
                this.callback.fileChanged(null, localAbspath, modified ? textBase : null, translatedFile, revision, -1L, baseMimeType, workingMimeType, propChanges, baseProps);
            }
        }
    }

    private File getLocalAbspath(String path) {
        return new File(this.anchorAbspath, path);
    }

    private void checkCancelled() throws SVNCancelException {
        this.canceller.checkCancelled();
    }

    private SVNProperties applyPropsChanges(SVNProperties props, SVNProperties propChanges) {
        SVNProperties result = new SVNProperties(props);
        if (propChanges != null) {
            for (String name : propChanges.nameSet()) {
                SVNPropertyValue value = propChanges.getSVNPropertyValue(name);
                if (value == null) {
                    result.remove(name);
                    continue;
                }
                result.put(name, value);
            }
        }
        return result;
    }

    private static void reversePropChanges(SVNProperties base, SVNProperties diff) {
        ArrayList<String> namesList = new ArrayList<String>(diff.nameSet());
        for (String name : namesList) {
            SVNPropertyValue newValue = diff.getSVNPropertyValue(name);
            SVNPropertyValue oldValue = base.getSVNPropertyValue(name);
            if (oldValue == null && newValue != null) {
                base.put(name, newValue);
                diff.put(name, (SVNPropertyValue)null);
                continue;
            }
            if (oldValue != null && newValue == null) {
                base.put(name, (SVNPropertyValue)null);
                diff.put(name, oldValue);
                continue;
            }
            if (oldValue == null || newValue == null) continue;
            base.put(name, newValue);
            diff.put(name, oldValue);
        }
    }

    private void walkLocalNodesDiff(File localAbspath, String path, SVNDepth depth, Set<String> compared) throws SVNException {
        boolean modified;
        boolean inAnchorNotTarget;
        if (this.useTextBase) {
            return;
        }
        boolean bl = inAnchorNotTarget = path.length() == 0 && this.target.length() != 0;
        if (this.context.matchesChangelist(localAbspath, this.changelists) && !inAnchorNotTarget && (compared == null || !compared.contains(path)) && (modified = this.context.isPropsModified(localAbspath))) {
            SVNWCContext.PropDiffs propDiffs = this.context.getPropDiffs(localAbspath);
            SVNProperties baseProps = propDiffs.originalProps;
            SVNProperties propChanges = propDiffs.propChanges;
            this.callback.dirPropsChanged(null, localAbspath, false, propChanges, baseProps);
        }
        if (depth == SVNDepth.EMPTY && !inAnchorNotTarget) {
            return;
        }
        Set<String> children = this.db.readChildren(localAbspath);
        for (String name : children) {
            this.checkCancelled();
            if (inAnchorNotTarget && !name.equals(this.target)) continue;
            File childAbspath = new File(localAbspath, name);
            Structure<StructureFields.NodeInfo> nodeInfoStructure = this.db.readInfo(childAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
            ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
            ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
            if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) continue;
            String childPath = SVNPathUtil.append(path, name);
            if (compared != null && compared.contains(childPath)) continue;
            switch (kind) {
                case File: 
                case Symlink: {
                    this.fileDiff(childAbspath, childPath);
                    break;
                }
                case Dir: {
                    if (!inAnchorNotTarget && depth.compareTo(SVNDepth.FILES) <= 0 && depth != SVNDepth.UNKNOWN) break;
                    SVNDepth depthBelowHere = depth;
                    if (depthBelowHere == SVNDepth.IMMEDIATES) {
                        depthBelowHere = SVNDepth.EMPTY;
                    }
                    this.walkLocalNodesDiff(childAbspath, childPath, depthBelowHere, null);
                    break;
                }
            }
        }
    }

    private File createTempFile(File tempDir) throws SVNException {
        File tempFile = SVNFileUtil.createUniqueFile(tempDir, "diff.", ".tmp", true);
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    private void addToCompared(Entry entry, String path) {
        if (entry.compared == null) {
            this.currentEntry.compared = new HashSet();
        }
        this.currentEntry.compared.add(path);
    }

    public void cleanup() {
        for (File tempFile : this.tempFiles) {
            try {
                SVNFileUtil.deleteFile(tempFile);
            }
            catch (SVNException sVNException) {}
        }
    }

    @Override
    public long getTargetRevision() {
        return this.revision;
    }

    public static SVNProperties computePropDiff(SVNProperties props1, SVNProperties props2) {
        SVNProperties propsDiff = new SVNProperties();
        for (String newPropName : props2.nameSet()) {
            if (props1.containsName(newPropName)) {
                SVNPropertyValue oldValue = props2.getSVNPropertyValue(newPropName);
                SVNPropertyValue value = props1.getSVNPropertyValue(newPropName);
                if (oldValue != null && !oldValue.equals(value)) {
                    propsDiff.put(newPropName, oldValue);
                    continue;
                }
                if (oldValue != null || value == null) continue;
                propsDiff.put(newPropName, oldValue);
                continue;
            }
            propsDiff.put(newPropName, props2.getSVNPropertyValue(newPropName));
        }
        for (String oldPropName : props1.nameSet()) {
            if (props2.containsName(oldPropName)) continue;
            propsDiff.put(oldPropName, (String)null);
        }
        return propsDiff;
    }

    private static class Entry {
        private boolean isFile;
        private Entry parent;
        private String path;
        private boolean added;
        private SVNDepth depth;
        private SVNProperties propChanges;
        private File localAbspath;
        private SvnChecksum baseChecksum;
        private SvnChecksum resultChecksum;
        private File file;
        private Set<String> compared;

        public Entry(boolean file, String path, Entry parent, boolean added, SVNDepth depth, File localAbspath) {
            this.isFile = file;
            this.path = path;
            this.parent = parent;
            this.added = added;
            this.depth = depth;
            this.localAbspath = localAbspath;
            this.propChanges = new SVNProperties();
        }
    }
}

