/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SVNSqlJetTableStatement
extends SVNSqlJetStatement {
    protected ISqlJetTable table;
    protected String tableName;
    private Collection<ISVNSqlJetTrigger> triggers;

    public SVNSqlJetTableStatement(SVNSqlJetDb sDb, Enum<?> tableName) throws SVNException {
        this(sDb, tableName.toString());
    }

    public String getTableName() {
        return this.tableName;
    }

    public SVNSqlJetTableStatement(SVNSqlJetDb sDb, String tableName) throws SVNException {
        super(sDb);
        this.tableName = tableName;
        try {
            this.table = sDb.getDb().getTable(tableName);
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
        }
    }

    public void addTrigger(ISVNSqlJetTrigger trigger) {
        if (trigger != null) {
            if (this.triggers == null) {
                this.triggers = new ArrayList<ISVNSqlJetTrigger>();
            }
            this.triggers.add(trigger);
        }
    }

    protected Collection<ISVNSqlJetTrigger> getTriggers() {
        if (this.triggers == null) {
            return Collections.emptyList();
        }
        return this.triggers;
    }

    public ISqlJetTable getTable() {
        return this.table;
    }

    protected void statementStarted() {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.statementStarted(this.sDb.getDb());
            }
            catch (SqlJetException sqlJetException) {}
        }
    }

    protected void statementCompleted(SqlJetException error) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.statementCompleted(this.sDb.getDb(), error);
            }
            catch (SqlJetException e) {}
        }
    }

    @Override
    public void reset() throws SVNException {
        super.reset();
        if (this.triggers != null) {
            this.triggers.clear();
        }
    }
}

