/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class FlowPanel
extends JPanel
implements Scrollable {
    private int horizGap = 16;
    private int vertGap = 16;

    public void setHorizontalGap(int n) {
        this.horizGap = n;
    }

    public void setVerticalGap(int n) {
        this.vertGap = n;
    }

    public Dimension getPreferredSize() {
        int n = this.getComponentCount();
        if (n == 0) {
            return new Dimension(this.horizGap, this.vertGap);
        }
        Component component = this.getComponent(0);
        Dimension dimension = component.getPreferredSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Insets insets = this.getInsets();
        int n4 = this.getParent().getSize().width - insets.left - insets.right;
        int n5 = Math.max(n4 / (n2 + this.horizGap), 1);
        int n6 = n / n5;
        if (n6 * n5 < n) {
            ++n6;
        }
        int n7 = n5 * (n2 + this.horizGap) - this.horizGap;
        int n8 = n6 * (n3 + this.vertGap) - this.vertGap;
        return new Dimension(n7 + insets.left + insets.right, n8 + insets.top + insets.bottom);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        int n = this.getComponentCount();
        if (n == 0) {
            return;
        }
        Component component = this.getComponent(0);
        Dimension dimension = component.getPreferredSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Insets insets = this.getInsets();
        int n4 = this.getParent().getSize().width - insets.left - insets.right;
        int n5 = Math.max(n4 / (n2 + this.horizGap), 1);
        int n6 = n / n5;
        if (n6 * n5 < n) {
            ++n6;
        }
        int n7 = insets.left;
        int n8 = insets.top;
        int n9 = 0;
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                if (n9 >= n) {
                    return;
                }
                component = this.getComponent(n9++);
                component.setBounds(n7, n8, n2, n3);
                n7 += n2 + this.horizGap;
            }
            n8 += n3 + this.vertGap;
            n7 = insets.left;
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getParent().getWidth() > this.getPreferredSize().width;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getComponentCount() == 0) {
            return this.vertGap;
        }
        return (this.getComponent(0).getHeight() + this.vertGap) / 3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 0 ? rectangle.width : rectangle.height;
    }
}

