/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.language.simple.ast.Block;
import org.apache.camel.language.simple.ast.BlockEnd;
import org.apache.camel.language.simple.ast.BlockStart;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.UnaryExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.SimpleTokenType;
import org.apache.camel.language.simple.types.TokenType;

public abstract class BaseSimpleParser {
    protected final String expression;
    protected final List<SimpleToken> tokens = new ArrayList<SimpleToken>();
    protected final List<SimpleNode> nodes = new ArrayList<SimpleNode>();
    protected SimpleToken token;
    protected int previousIndex;
    protected int index;
    protected boolean allowEscape = true;

    protected BaseSimpleParser(String expression, boolean allowEscape) {
        this.expression = expression;
        this.allowEscape = allowEscape;
    }

    protected void nextToken() {
        if (this.index < this.expression.length()) {
            SimpleToken next = SimpleTokenizer.nextToken(this.expression, this.index, this.allowEscape);
            this.tokens.add(next);
            this.token = next;
            this.previousIndex = this.index;
            this.index += next.getLength();
        } else {
            this.token = new SimpleToken(new SimpleTokenType(TokenType.eol, null), this.index);
        }
    }

    protected void nextToken(TokenType ... filter) {
        if (this.index < this.expression.length()) {
            SimpleToken next = SimpleTokenizer.nextToken(this.expression, this.index, this.allowEscape, filter);
            this.tokens.add(next);
            this.token = next;
            this.previousIndex = this.index;
            this.index += next.getLength();
        } else {
            this.token = new SimpleToken(new SimpleTokenType(TokenType.eol, null), this.index);
        }
    }

    protected void clear() {
        this.token = null;
        this.previousIndex = 0;
        this.index = 0;
        this.tokens.clear();
        this.nodes.clear();
    }

    protected void prepareBlocks() {
        ArrayList<SimpleNode> answer = new ArrayList<SimpleNode>();
        Stack<Block> stack = new Stack<Block>();
        for (SimpleNode token : this.nodes) {
            Block block;
            if (token instanceof BlockStart) {
                stack.push((Block)token);
                continue;
            }
            if (token instanceof BlockEnd) {
                Block block2;
                if (stack.isEmpty()) {
                    throw new SimpleParserException((Object)((Object)token.getToken().getType().getType()) + " has no matching start token", token.getToken().getIndex());
                }
                Block top = (Block)stack.pop();
                Block block3 = block2 = stack.isEmpty() ? null : (Block)stack.peek();
                if (block2 != null) {
                    if (block2.acceptAndAddNode(top)) continue;
                    throw new SimpleParserException(block2.getToken().getType() + " cannot accept " + token.getToken().getType(), token.getToken().getIndex());
                }
                answer.add(top);
                continue;
            }
            Block block4 = block = stack.isEmpty() ? null : (Block)stack.peek();
            if (block != null) {
                if (block.acceptAndAddNode(token)) continue;
                throw new SimpleParserException(block.getToken().getType() + " cannot accept " + token.getToken().getType(), token.getToken().getIndex());
            }
            answer.add(token);
        }
        this.nodes.clear();
        this.nodes.addAll(answer);
    }

    protected void prepareUnaryExpressions() {
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        for (SimpleNode node : this.nodes) {
            if (node instanceof UnaryExpression) {
                SimpleNode previous;
                UnaryExpression token = (UnaryExpression)node;
                String operator = token.getOperator().toString();
                SimpleNode simpleNode = previous = stack.isEmpty() ? null : (SimpleNode)stack.pop();
                if (previous == null) {
                    throw new SimpleParserException("Unary operator " + operator + " has no left hand side token", token.getToken().getIndex());
                }
                token.acceptLeft(previous);
            }
            stack.push(node);
        }
        this.nodes.clear();
        this.nodes.addAll(stack);
    }

    protected boolean accept(TokenType accept) {
        return this.token == null || this.token.getType().getType() == accept;
    }

    protected void expect(TokenType expect) throws SimpleParserException {
        if (this.token != null && this.token.getType().getType() == expect) {
            return;
        }
        if (this.token == null) {
            throw new SimpleParserException("expected symbol " + (Object)((Object)expect) + " but reached eol", this.previousIndex);
        }
        throw new SimpleParserException("expected symbol " + (Object)((Object)expect) + " but was " + (Object)((Object)this.token.getType().getType()), this.previousIndex);
    }

    protected void expectAndAcceptMore(TokenType expect) {
        this.expect(expect);
        while (!this.token.getType().isEol() && this.token.getType().getType() == expect) {
            this.nextToken();
        }
    }
}

