/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.impl.RepGroupProtocol;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

public class GroupService
extends ServiceDispatcher.ExecutingService {
    final RepNode repNode;
    final RepGroupProtocol protocol;
    private final Logger logger;
    public static final String SERVICE_NAME = "Group";

    public GroupService(ServiceDispatcher dispatcher, RepNode repNode) {
        super(SERVICE_NAME, dispatcher);
        this.repNode = repNode;
        this.protocol = new RepGroupProtocol(repNode.getGroup().getName(), repNode.getNameIdPair(), repNode.getRepImpl());
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.GroupRequest groupRequest) {
        RepGroupProtocol repGroupProtocol = this.protocol;
        repGroupProtocol.getClass();
        return new RepGroupProtocol.GroupResponse(repGroupProtocol, this.repNode.getGroup());
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.EnsureNode ensureNode) {
        RepNodeImpl node = ensureNode.getNode();
        try {
            this.repNode.getRepGroupDB().ensureMember(node);
            RepNodeImpl enode = this.repNode.getGroup().getMember(node.getName());
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.EnsureOK(repGroupProtocol, enode.getNameIdPair());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.RemoveMember removeMember) {
        String nodeName = removeMember.getNodeName();
        try {
            this.repNode.removeMember(nodeName);
            return new TextProtocol.OK(this.protocol);
        }
        catch (MemberNotFoundException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.MEMBER_NOT_FOUND, e.getMessage());
        }
        catch (MasterStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.IS_MASTER, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public Runnable getRunnable(SocketChannel socketChannel) {
        return new GroupServiceRunnable(socketChannel, this.protocol);
    }

    class GroupServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        GroupServiceRunnable(SocketChannel socketChannel, RepGroupProtocol protocol) {
            super(socketChannel, protocol, true);
        }

        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            return this.protocol.process(GroupService.this, request);
        }

        protected void logMessage(String message) {
            LoggerUtils.warning(GroupService.this.logger, GroupService.this.repNode.getRepImpl(), message);
        }
    }
}

