/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.ProposerStatDefinition;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Proposer {
    protected final Elections elections;
    private final StatGroup statistics;
    private final IntStat phase1NoQuorum;
    private final IntStat phase1HigherProposal;
    private final IntStat phase2NoQuorum;
    private final IntStat phase2HigherProposal;
    private final IntStat promiseCount;
    private final Logger logger;
    private final Formatter formatter;

    public Proposer(Elections elections, NameIdPair nameIdPair) {
        this.elections = elections;
        this.logger = elections.getRepImpl() != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(nameIdPair);
        this.statistics = new StatGroup("Election Proposer", "Proposals are the first stage of a replication group election.");
        this.phase1NoQuorum = new IntStat(this.statistics, ProposerStatDefinition.PHASE1_NO_QUORUM);
        this.phase1HigherProposal = new IntStat(this.statistics, ProposerStatDefinition.PHASE1_HIGHER_PROPOSAL);
        this.phase2NoQuorum = new IntStat(this.statistics, ProposerStatDefinition.PHASE2_NO_QUORUM);
        this.phase2HigherProposal = new IntStat(this.statistics, ProposerStatDefinition.PHASE2_HIGHER_PROPOSAL);
        this.promiseCount = new IntStat(this.statistics, ProposerStatDefinition.PROMISE_COUNT);
    }

    public void shutDown() {
    }

    public StatGroup getProposerStats() {
        return this.statistics;
    }

    private boolean haveQuorum(QuorumPolicy quorumPolicy, int votes) {
        return votes >= this.elections.getRepNode().getElectionQuorumSize(quorumPolicy);
    }

    private Phase1Result phase1(QuorumPolicy quorumPolicy, Proposal proposal) throws HigherNumberedProposal {
        LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.FINE, "Phase 1 proposal: " + proposal);
        Set<InetSocketAddress> set = this.elections.getAcceptorSockets();
        Protocol protocol = this.elections.getProtocol();
        protocol.getClass();
        List<Future<TextProtocol.MessageExchange>> futures = Utils.broadcastMessage(set, "Acceptor", new Protocol.Propose(protocol, proposal), this.elections.getThreadPool());
        Phase1Result result = this.tallyPhase1Results(proposal, futures);
        if (this.haveQuorum(quorumPolicy, result.promisories.size())) {
            return result;
        }
        this.phase1NoQuorum.increment();
        return null;
    }

    private Phase1Result tallyPhase1Results(Proposal currentProposal, final List<Future<TextProtocol.MessageExchange>> futures) throws HigherNumberedProposal {
        final Phase1Result result = new Phase1Result();
        for (final Future<TextProtocol.MessageExchange> f : futures) {
            new Utils.WithFutureExceptionHandler(){

                protected void processFuture() throws ExecutionException, InterruptedException {
                    TextProtocol.MessageExchange me = (TextProtocol.MessageExchange)f.get();
                    if (me.getResponseMessage() == null) {
                        LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.FINE, "No response from: " + me.target + " reason: " + me.exception);
                        return;
                    }
                    if (me.getResponseMessage().getOp() == Proposer.this.elections.getProtocol().REJECT) {
                        Utils.discardFutures(futures.subList(futures.indexOf(f), futures.size()));
                        Proposer.this.phase1HigherProposal.increment();
                        throw new HigherNumberedProposal(me.target);
                    }
                    if (me.getResponseMessage().getOp() == Proposer.this.elections.getProtocol().PROMISE) {
                        result.promisories.add(me.target);
                        result.promisoryMessages.add(me);
                        Protocol.Promise accept = (Protocol.Promise)me.getResponseMessage();
                        Proposal acceptProposal = accept.getHighestProposal();
                        if (result.acceptProposal == null || acceptProposal != null && acceptProposal.compareTo(result.acceptProposal) > 0) {
                            result.acceptProposal = acceptProposal;
                            result.acceptedValue = accept.getAcceptedValue();
                        }
                    } else {
                        if (me.getResponseMessage().getOp() == Proposer.this.elections.getProtocol().PROTOCOL_ERROR) {
                            TextProtocol.ProtocolError protocolError = (TextProtocol.ProtocolError)me.getResponseMessage();
                            LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.WARNING, "Election protocol error: " + protocolError.getMessage());
                            return;
                        }
                        throw EnvironmentFailureException.unexpectedState("Unknown response: " + me.getResponseMessage().getOp());
                    }
                }
            }.execute(this.logger, this.elections.getRepImpl(), null);
        }
        if (result.promisories.size() > 0 && result.acceptProposal == null) {
            result.acceptProposal = currentProposal;
        }
        this.promiseCount.set(result.promisories.size());
        return result;
    }

    private Phase2Result phase2(QuorumPolicy quorumPolicy, Proposal proposal, Protocol.Value phase2Value, Set<InetSocketAddress> promisories) throws HigherNumberedProposal {
        LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.FINE, "Phase 2 proposal: " + proposal + " Value: " + phase2Value);
        Protocol protocol = this.elections.getProtocol();
        protocol.getClass();
        Protocol.Accept accept = new Protocol.Accept(protocol, proposal, phase2Value);
        List<Future<TextProtocol.MessageExchange>> futures = Utils.broadcastMessage(promisories, "Acceptor", accept, this.elections.getThreadPool());
        Phase2Result result = this.tallyPhase2Results(quorumPolicy, futures);
        if (this.haveQuorum(quorumPolicy, result.accepts.size())) {
            return result;
        }
        this.phase2NoQuorum.increment();
        return null;
    }

    private Phase2Result tallyPhase2Results(final QuorumPolicy quorumPolicy, final List<Future<TextProtocol.MessageExchange>> futures) throws HigherNumberedProposal {
        final Phase2Result result = new Phase2Result();
        try {
            for (final Future<TextProtocol.MessageExchange> f : futures) {
                new Utils.WithFutureExceptionHandler(){

                    protected void processFuture() throws ExecutionException, InterruptedException {
                        TextProtocol.MessageExchange me = (TextProtocol.MessageExchange)f.get();
                        TextProtocol.ResponseMessage responseMessage = me.getResponseMessage();
                        if (responseMessage == null) {
                            LoggerUtils.logMsg(Proposer.this.logger, Proposer.this.elections.getRepImpl(), Proposer.this.formatter, Level.WARNING, "No response from: " + me.target + " reason: " + me.exception);
                            return;
                        }
                        Protocol protocol = Proposer.this.elections.getProtocol();
                        TextProtocol.MessageOp op = responseMessage.getOp();
                        if (op == protocol.REJECT) {
                            Utils.discardFutures(futures.subList(futures.indexOf(f), futures.size()));
                            Proposer.this.phase2HigherProposal.increment();
                            throw new HigherNumberedProposal(me.target);
                        }
                        if (op == protocol.ACCEPTED) {
                            result.accepts.add(me.target);
                            if (Proposer.this.haveQuorum(quorumPolicy, result.accepts.size())) {
                                Utils.discardFutures(futures.subList(futures.indexOf(f), futures.size()));
                                throw new HaveQuorum();
                            }
                        } else {
                            if (op == protocol.PROTOCOL_ERROR) {
                                TextProtocol.ProtocolError errorMessage = (TextProtocol.ProtocolError)responseMessage;
                                throw EnvironmentFailureException.unexpectedState("Protcol error:" + errorMessage.getMessage());
                            }
                            throw EnvironmentFailureException.unexpectedState("Unknown response: " + op);
                        }
                    }
                }.execute(this.logger, this.elections.getRepImpl(), null);
            }
        }
        catch (HaveQuorum hq) {
            // empty catch block
        }
        return result;
    }

    protected abstract Protocol.Value choosePhase2Value(Set<TextProtocol.MessageExchange> var1);

    protected abstract Proposal nextProposal();

    public WinningProposal issueProposal(QuorumPolicy quorumPolicy, RetryPredicate retryPredicate) throws MaxRetriesException, InterruptedException {
        this.statistics.clear();
        while (retryPredicate.retry()) {
            try {
                Protocol.Value phase2Value;
                Phase2Result result2;
                Proposal proposal = this.nextProposal();
                Phase1Result result1 = this.phase1(quorumPolicy, proposal);
                if (result1 == null || (result2 = this.phase2(quorumPolicy, proposal, phase2Value = this.choosePhase2Value(result1.promisoryMessages), result1.promisories)) == null) continue;
                LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.INFO, "Winning proposal: " + proposal + " Value: " + phase2Value);
                return new WinningProposal(proposal, phase2Value, this.statistics);
            }
            catch (HigherNumberedProposal eip) {
            }
        }
        throw new MaxRetriesException(this.statistics);
    }

    public static interface RetryPredicate {
        public boolean retry() throws InterruptedException;

        public int retries();
    }

    public static interface ProposalParser {
        public Proposal parse(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Proposal
    extends Comparable<Proposal> {
        public String wireFormat();
    }

    private static class HaveQuorum
    extends RuntimeException {
        HaveQuorum() {
        }
    }

    public static class MaxRetriesException
    extends Exception {
        final StatGroup proposerStats;

        MaxRetriesException(StatGroup proposerStats) {
            this.proposerStats = proposerStats;
        }
    }

    private static class HigherNumberedProposal
    extends RuntimeException {
        final InetSocketAddress acceptor;

        HigherNumberedProposal(InetSocketAddress acceptor) {
            this.acceptor = acceptor;
        }

        public String getMessage() {
            return "More recent proposal at: " + this.acceptor.getHostName();
        }
    }

    public static class WinningProposal {
        final Proposal proposal;
        final Protocol.Value chosenValue;
        final StatGroup proposerStats;

        WinningProposal(Proposal proposal, Protocol.Value value, StatGroup proposerStats) {
            this.proposal = proposal;
            this.chosenValue = value;
            this.proposerStats = proposerStats;
        }
    }

    private static class Phase2Result {
        Set<InetSocketAddress> accepts = new HashSet<InetSocketAddress>();

        private Phase2Result() {
        }
    }

    private static class Phase1Result {
        Set<InetSocketAddress> promisories = new HashSet<InetSocketAddress>();
        Set<TextProtocol.MessageExchange> promisoryMessages = new HashSet<TextProtocol.MessageExchange>();
        Proposal acceptProposal;
        Protocol.Value acceptedValue;

        private Phase1Result() {
        }
    }
}

