/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.jcs.access.exception.CacheException;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.util.XMLCatalogResolver;
import org.fao.geonet.JeevesJCS;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.ProxyParams;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;
import org.w3c.dom.ls.LSInput;

public class XmlResolver
extends XMLCatalogResolver {
    public static final String XMLRESOLVER_JCS = "XmlResolver";
    private ProxyParams proxyParams;

    public XmlResolver(String[] catalogs, ProxyParams proxyParams) {
        super(catalogs, true);
        this.proxyParams = proxyParams;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (Log.isDebugEnabled("jeeves.xmlresolver")) {
            Log.debug("jeeves.xmlresolver", "Jeeves XmlResolver: Before resolution: Type: " + type + " NamespaceURI :" + namespaceURI + " PublicId :" + publicId + " SystemId :" + systemId + " BaseURI:" + baseURI);
        }
        LSInput result = null;
        try {
            result = this.tryToResolveOnFs(publicId, systemId, baseURI);
            if (result != null) {
                return result;
            }
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        result = super.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
        if (result != null) {
            publicId = result.getPublicId();
            systemId = result.getSystemId();
            baseURI = result.getBaseURI();
        }
        if (Log.isDebugEnabled("jeeves.xmlresolver")) {
            Log.debug("jeeves.xmlresolver", "Jeeves XmlResolver: After resolution: PublicId :" + publicId + " SystemId :" + systemId + " BaseURI:" + baseURI);
        }
        URL externalRef = null;
        try {
            if (publicId != null && publicId.startsWith("http://")) {
                externalRef = new URL(publicId);
            } else if (systemId != null && systemId.startsWith("http://")) {
                externalRef = new URL(systemId);
            } else if (systemId != null && baseURI != null && baseURI.startsWith("http://")) {
                URL ref = new URL(baseURI);
                String thePath = new File(ref.getPath()).getParent().replace('\\', '/');
                externalRef = new URI(ref.getProtocol(), null, ref.getHost(), ref.getPort(), thePath + "/" + systemId, null, null).toURL();
            }
        }
        catch (MalformedURLException e) {
            Log.error("jeeves.xmlresolver", e.getMessage(), e);
            return result;
        }
        catch (URISyntaxException e) {
            Log.error("jeeves.xmlresolver", e.getMessage(), e);
            return result;
        }
        if (externalRef != null) {
            Element elResult = null;
            try {
                elResult = this.isXmlInCache(externalRef.toString());
            }
            catch (CacheException e) {
                Log.error("jeeves.xmlresolver", "Request to cache for " + externalRef + " failed.", e);
            }
            if (elResult == null) {
                XmlRequest xml = new GeonetHttpRequestFactory().createXmlRequest(externalRef);
                if (this.proxyParams.useProxy) {
                    xml.setUseProxy(true);
                    xml.setProxyHost(this.proxyParams.proxyHost);
                    xml.setProxyPort(this.proxyParams.proxyPort);
                    if (this.proxyParams.useProxyAuth) {
                        xml.setProxyCredentials(this.proxyParams.username, this.proxyParams.password);
                    }
                }
                elResult = null;
                try {
                    elResult = xml.execute();
                    this.addXmlToCache(externalRef.toString(), elResult);
                    if (Log.isDebugEnabled("jeeves.xmlresolver")) {
                        Log.debug("jeeves.xmlresolver", "Retrieved: \n" + Xml.getString(elResult));
                    }
                }
                catch (Exception e) {
                    Log.error("jeeves.xmlresolver", "Request on " + externalRef + " failed." + e.getMessage());
                }
            }
            if (result == null) {
                result = new DOMInputImpl(publicId, systemId, baseURI);
            }
            if (elResult != null) {
                result.setStringData(Xml.getString(elResult));
            }
        }
        return result;
    }

    private LSInput tryToResolveOnFs(String publicId, String systemId, String baseURI) {
        if (baseURI != null && systemId != null) {
            try {
                Path basePath = IO.toPath(new URI(baseURI));
                Path parent = basePath.getParent();
                if (parent == null) {
                    throw new RuntimeException(basePath.toUri() + " does not have parent");
                }
                Path resolved = parent.resolve(systemId);
                if (Files.isRegularFile(resolved, new LinkOption[0])) {
                    try {
                        String uri = resolved.normalize().toUri().toASCIIString();
                        return new DOMInputImpl(publicId, uri, uri, (InputStream)new ByteArrayInputStream(Files.readAllBytes(resolved)), null);
                    }
                    catch (IOException e) {
                        Log.error("jeeves", "Error opening resource: " + resolved + " for reading", e);
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void clearCache() throws CacheException {
        JeevesJCS.getInstance(XMLRESOLVER_JCS).clear();
    }

    public void addXmlToCache(String uri, Element xml) throws CacheException {
        JeevesJCS xmlCache = JeevesJCS.getInstance(XMLRESOLVER_JCS);
        Element cachedXml = (Element)xmlCache.get(uri.toLowerCase());
        if (cachedXml == null) {
            Log.info("jeeves.xmlresolver", "Caching " + uri.toLowerCase());
            xmlCache.put(uri.toLowerCase(), xml);
        }
    }

    public Element isXmlInCache(String uri) throws CacheException {
        JeevesJCS xmlCache = JeevesJCS.getInstance(XMLRESOLVER_JCS);
        Element xml = (Element)xmlCache.get(uri.toLowerCase());
        if (xml == null) {
            Log.info("jeeves.xmlresolver", "cache MISS on " + uri.toLowerCase());
        } else {
            Log.info("jeeves.xmlresolver", "cache HIT on " + uri.toLowerCase());
        }
        return xml;
    }
}

