/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Value;

public class QueryResultsTable
implements Serializable {
    private int _colCount = 0;
    private List _rowList = new ArrayList();
    private String[] _columnNames;

    public QueryResultsTable(int colCount) {
        this._colCount = colCount;
    }

    public QueryResultsTable(int colCount, String[] columnNames) {
        this(colCount);
        this._columnNames = columnNames;
    }

    public int getRowCount() {
        return this._rowList.size();
    }

    public int getColumnCount() {
        return this._colCount;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public String getColumnName(int column) {
        if (this._columnNames == null) {
            return null;
        }
        return this._columnNames[column];
    }

    public Value getValue(int row, int column) {
        List columns = (List)this._rowList.get(row);
        return (Value)columns.get(column);
    }

    void _addRow(List values) {
        if (values.size() != this._colCount) {
            throw new IllegalArgumentException("Number of values (" + values.size() + ") in the row is not equal to the number of columns (" + this._colCount + ") of this table");
        }
        this._rowList.add(new ArrayList(values));
    }

    public boolean equals(Object other) {
        if (other instanceof QueryResultsTable) {
            QueryResultsTable otherTable = (QueryResultsTable)other;
            return this._colCount == otherTable._colCount && ((Object)this._rowList).equals(otherTable._rowList);
        }
        return false;
    }

    public int hashCode() {
        if (this._rowList.isEmpty()) {
            return 0;
        }
        List columns = (List)this._rowList.get(this._rowList.size() / 2);
        return ((Object)columns).hashCode();
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(20 * this._rowList.size() * this._colCount + 10);
        if (this._columnNames != null) {
            for (i = 0; i < this._columnNames.length; ++i) {
                if (i > 0) {
                    buf.append("\t| ");
                }
                buf.append(this._columnNames[i]);
            }
            buf.append('\n');
            int dashCount = buf.length() + 7 * (this._columnNames.length - 1);
            for (int i2 = 0; i2 < dashCount; ++i2) {
                buf.append('-');
            }
            buf.append('\n');
        }
        for (i = 0; i < this._rowList.size(); ++i) {
            List columns = (List)this._rowList.get(i);
            for (int j = 0; j < columns.size(); ++j) {
                if (j > 0) {
                    buf.append("\t| ");
                }
                buf.append(columns.get(j).toString());
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

