/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class ProjectionAnalyzer {
    private final Conversion projection;
    private final Matrix geographicScale;
    private final Matrix projectedScale;
    private final MathTransform transform;
    private List<GeneralParameterValue> parameters;

    private ProjectionAnalyzer(ProjectedCRS crs) {
        Matrix geographicScale = null;
        Matrix projectedScale = null;
        this.projection = crs.getConversionFromBase();
        MathTransform candidate = this.projection.getMathTransform();
        while (candidate instanceof ConcatenatedTransform) {
            ConcatenatedTransform ctr = (ConcatenatedTransform)candidate;
            if (ctr.transform1 instanceof LinearTransform) {
                if (geographicScale != null) {
                    throw new IllegalStateException(String.valueOf(candidate));
                }
                geographicScale = ((LinearTransform)ctr.transform1).getMatrix();
                candidate = ctr.transform2;
                continue;
            }
            if (ctr.transform2 instanceof LinearTransform) {
                if (projectedScale != null) {
                    throw new IllegalStateException(String.valueOf(candidate));
                }
                projectedScale = ((LinearTransform)ctr.transform2).getMatrix();
                candidate = ctr.transform1;
                continue;
            }
            candidate = null;
            break;
        }
        ParameterValueGroup group = null;
        if (candidate instanceof AbstractMathTransform) {
            group = ((AbstractMathTransform)candidate).getParameterValues();
        }
        if (group == null) {
            group = this.projection.getParameterValues();
            if (projectedScale == null) {
                CartesianCS cs = crs.getCoordinateSystem();
                projectedScale = AbstractCS.swapAndScaleAxis(AbstractCS.standard((CoordinateSystem)cs), (CoordinateSystem)cs);
            }
        }
        if (group != null) {
            this.parameters = group.values();
        }
        this.geographicScale = geographicScale;
        this.projectedScale = projectedScale;
        this.transform = candidate;
    }

    private ParameterDescriptorGroup getTransformDescriptor() {
        return this.transform instanceof AbstractMathTransform ? ((AbstractMathTransform)this.transform).getParameterDescriptors() : null;
    }

    /*
     * WARNING - void declaration
     */
    private XMatrix normalizedToProjection() {
        this.parameters = new LinkedList<GeneralParameterValue>(this.parameters);
        int sourceDim = this.transform != null ? this.transform.getTargetDimensions() : 2;
        int targetDim = this.projectedScale != null ? this.projectedScale.getNumCol() - 1 : sourceDim;
        XMatrix matrix = MatrixFactory.create(targetDim + 1, sourceDim + 1);
        Unit unit = null;
        String warning = null;
        Iterator<GeneralParameterValue> it = this.parameters.iterator();
        while (it.hasNext()) {
            ParameterValue value;
            ParameterDescriptor descriptor;
            GeneralParameterValue parameter = it.next();
            if (!(parameter instanceof ParameterValue) || !Number.class.isAssignableFrom((descriptor = (value = (ParameterValue)parameter).getDescriptor()).getValueClass())) continue;
            if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, "scale_factor")) {
                double scale = value.doubleValue();
                int i = Math.min(sourceDim, targetDim);
                while (--i >= 0) {
                    matrix.setElement(i, i, matrix.getElement(i, i) * scale);
                }
            } else {
                void var10_11;
                boolean d;
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, "false_easting")) {
                    d = false;
                } else {
                    if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, "false_northing")) continue;
                    d = true;
                }
                double offset = value.doubleValue(SI.METER);
                if (!Double.isNaN(offset) && offset != value.doubleValue()) {
                    unit = value.getUnit();
                    warning = descriptor.getName().getCode();
                }
                matrix.setElement((int)var10_11, sourceDim, matrix.getElement((int)var10_11, sourceDim) + offset);
            }
            it.remove();
        }
        if (warning != null) {
            LogRecord record = Loggings.format(Level.WARNING, 4, warning, unit, SI.METER);
            record.setSourceClassName(this.getClass().getName());
            record.setSourceMethodName("createLinearConversion");
            Logger logger = ReferencingFactory.LOGGER;
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
        return matrix;
    }

    private static boolean parameterValuesEqual(List<GeneralParameterValue> source, List<GeneralParameterValue> target, double errorTolerance) {
        Iterator<GeneralParameterValue> targetIter = target.iterator();
        block0: while (targetIter.hasNext()) {
            GeneralParameterValue targetPrm = targetIter.next();
            Iterator<GeneralParameterValue> sourceIter = source.iterator();
            while (sourceIter.hasNext()) {
                GeneralParameterValue sourcePrm = sourceIter.next();
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)sourcePrm.getDescriptor(), (IdentifiedObject)targetPrm.getDescriptor())) continue;
                if (sourcePrm instanceof ParameterValue && targetPrm instanceof ParameterValue) {
                    ParameterValue sourceValue = (ParameterValue)sourcePrm;
                    ParameterValue targetValue = (ParameterValue)targetPrm;
                    if (Number.class.isAssignableFrom(targetValue.getDescriptor().getValueClass())) {
                        double targetNum;
                        double sourceNum;
                        Unit unit = targetValue.getUnit();
                        if (unit != null) {
                            sourceNum = sourceValue.doubleValue(unit);
                            targetNum = targetValue.doubleValue(unit);
                        } else {
                            sourceNum = sourceValue.doubleValue();
                            targetNum = targetValue.doubleValue();
                        }
                        double error = targetNum - sourceNum;
                        if (targetNum != 0.0) {
                            error /= targetNum;
                        }
                        if (!(Math.abs(error) <= errorTolerance)) {
                            return false;
                        }
                    } else if (!Utilities.equals(sourceValue.getValue(), targetValue.getValue())) {
                        return false;
                    }
                } else if (!Utilities.equals(targetPrm, sourcePrm)) {
                    return false;
                }
                sourceIter.remove();
                targetIter.remove();
                continue block0;
            }
            return false;
        }
        assert (target.isEmpty());
        return source.isEmpty();
    }

    private XMatrix applyProjectedScale(XMatrix normalizedToProjection) {
        if (this.projectedScale == null) {
            return normalizedToProjection;
        }
        XMatrix scale = MatrixFactory.create(this.projectedScale);
        scale.multiply(normalizedToProjection);
        return scale;
    }

    public static Matrix createLinearConversion(ProjectedCRS sourceCRS, ProjectedCRS targetCRS, double errorTolerance) {
        if (!CRS.equalsIgnoreMetadata(sourceCRS.getDatum(), targetCRS.getDatum())) {
            return null;
        }
        ProjectionAnalyzer source = new ProjectionAnalyzer(sourceCRS);
        ProjectionAnalyzer target = new ProjectionAnalyzer(targetCRS);
        if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)source.projection.getMethod(), (IdentifiedObject)target.projection.getMethod())) {
            ParameterDescriptorGroup sourceDsc = source.getTransformDescriptor();
            ParameterDescriptorGroup targetDsc = source.getTransformDescriptor();
            if (sourceDsc == null || targetDsc == null || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)sourceDsc, (IdentifiedObject)targetDsc)) {
                return null;
            }
        }
        if (source.parameters == null || target.parameters == null) {
            return null;
        }
        XMatrix sourceScale = source.normalizedToProjection();
        XMatrix targetScale = target.normalizedToProjection();
        if (!ProjectionAnalyzer.parameterValuesEqual(source.parameters, target.parameters, errorTolerance)) {
            return null;
        }
        targetScale = target.applyProjectedScale(targetScale);
        sourceScale = source.applyProjectedScale(sourceScale);
        sourceScale.invert();
        targetScale.multiply(sourceScale);
        if (targetScale.isIdentity(errorTolerance)) {
            targetScale.setIdentity();
        }
        return targetScale;
    }
}

