/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class NominalType {
    private final ImmutableMap<String, JSType> typeMap;
    private final RawNominalType rawType;
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");

    private NominalType(ImmutableMap<String, JSType> typeMap, RawNominalType rawType) {
        Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll((Collection)rawType.typeParameters) && rawType.typeParameters.containsAll((Collection)typeMap.keySet()) ? 1 : 0) != 0);
        this.typeMap = typeMap;
        this.rawType = rawType;
    }

    public RawNominalType getRawNominalType() {
        Preconditions.checkState((boolean)this.typeMap.isEmpty());
        return this.rawType;
    }

    public JSType getInstanceAsJSType() {
        return this.rawType.isGeneric() && !this.typeMap.isEmpty() ? JSType.fromObjectType(ObjectType.fromNominalType(this)) : this.rawType.getInstanceAsJSType();
    }

    ObjectKind getObjectKind() {
        return this.rawType.objectKind;
    }

    Map<String, JSType> getTypeMap() {
        return this.typeMap;
    }

    boolean isClassy() {
        return !this.isFunction() && !this.isObject();
    }

    boolean isFunction() {
        return "Function".equals(this.rawType.name);
    }

    private boolean isObject() {
        return "Object".equals(this.rawType.name);
    }

    public boolean isStruct() {
        return this.rawType.isStruct();
    }

    public boolean isDict() {
        return this.rawType.isDict();
    }

    public boolean isGeneric() {
        return this.rawType.isGeneric();
    }

    public boolean isUninstantiatedGenericType() {
        return this.rawType.isGeneric() && this.typeMap.isEmpty();
    }

    NominalType instantiateGenerics(List<JSType> types) {
        Preconditions.checkState((types.size() == this.rawType.typeParameters.size() ? 1 : 0) != 0);
        LinkedHashMap<String, JSType> typeMap = new LinkedHashMap<String, JSType>();
        for (int i = 0; i < this.rawType.typeParameters.size(); ++i) {
            typeMap.put((String)this.rawType.typeParameters.get(i), types.get(i));
        }
        return this.instantiateGenerics(typeMap);
    }

    NominalType instantiateGenerics(Map<String, JSType> newTypeMap) {
        ImmutableMap resultMap;
        if (newTypeMap.isEmpty()) {
            return this;
        }
        if (!this.rawType.isGeneric()) {
            return this.rawType.wrappedAsNominal;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this.typeMap.isEmpty()) {
            for (String oldKey : this.typeMap.keySet()) {
                builder.put((Object)oldKey, (Object)((JSType)this.typeMap.get((Object)oldKey)).substituteGenerics(newTypeMap));
            }
            resultMap = builder.build();
        } else {
            for (String newKey : this.rawType.typeParameters) {
                if (!newTypeMap.containsKey(newKey)) continue;
                builder.put((Object)newKey, (Object)newTypeMap.get(newKey));
            }
            resultMap = builder.build();
            if (resultMap.isEmpty()) {
                return this;
            }
            if (resultMap.size() < this.rawType.typeParameters.size()) {
                return this;
            }
        }
        return new NominalType((ImmutableMap<String, JSType>)resultMap, this.rawType);
    }

    public String getName() {
        return this.rawType.name;
    }

    public Node getDefsite() {
        return this.rawType.defSite;
    }

    public RawNominalType getId() {
        return this.rawType;
    }

    public boolean isClass() {
        return this.rawType.isClass();
    }

    public boolean isInterface() {
        return this.rawType.isInterface();
    }

    public boolean isFinalized() {
        return this.rawType.isFinalized;
    }

    public ImmutableSet<String> getAllPropsOfInterface() {
        return this.rawType.getAllPropsOfInterface();
    }

    public ImmutableSet<String> getAllPropsOfClass() {
        return this.rawType.getAllPropsOfClass();
    }

    public ImmutableSet<String> getAllOwnProps() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.rawType.classProps.keySet());
        builder.addAll(this.rawType.protoProps.keySet());
        return builder.build();
    }

    public NominalType getInstantiatedSuperclass() {
        Preconditions.checkState((boolean)this.rawType.isFinalized);
        if (this.rawType.superClass == null) {
            return null;
        }
        return this.rawType.superClass.instantiateGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPrototype() {
        Preconditions.checkState((boolean)this.rawType.isFinalized);
        return this.rawType.getCtorPropDeclaredType("prototype").substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public ImmutableSet<NominalType> getInstantiatedInterfaces() {
        Preconditions.checkState((boolean)this.rawType.isFinalized);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : this.rawType.interfaces) {
            result.add((Object)interf.instantiateGenerics((Map<String, JSType>)this.typeMap));
        }
        return result.build();
    }

    Property getProp(String pname) {
        if (this.rawType.name.equals("Array") && NUMERIC_PATTERN.matcher(pname).matches()) {
            if (this.typeMap.isEmpty()) {
                return Property.make(JSType.UNKNOWN, null);
            }
            Preconditions.checkState((this.typeMap.size() == 1 ? 1 : 0) != 0);
            JSType elmType = (JSType)Iterables.getOnlyElement((Iterable)this.typeMap.values());
            return Property.make(elmType, null);
        }
        Property p = this.rawType.getProp(pname);
        return p == null ? null : p.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public Node getPropDefsite(String pname) {
        return this.getProp(pname).getDefsite();
    }

    public JSType getPropDeclaredType(String pname) {
        JSType type = this.rawType.getInstancePropDeclaredType(pname);
        if (type == null) {
            return null;
        }
        return type.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public boolean hasConstantProp(String pname) {
        Property p = this.rawType.getProp(pname);
        return p != null && p.isConstant();
    }

    static JSType getConstructorObject(FunctionType ctorFn) {
        return ctorFn.nominalType.rawType.getConstructorObject(ctorFn);
    }

    boolean isSubtypeOf(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this.areTypeMapsCompatible(other);
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                if (!i.instantiateGenerics((Map<String, JSType>)this.typeMap).isSubtypeOf(other)) continue;
                return true;
            }
        }
        return this.isClass() && thisRaw.superClass != null && thisRaw.superClass.instantiateGenerics((Map<String, JSType>)this.typeMap).isSubtypeOf(other);
    }

    private boolean areTypeMapsCompatible(NominalType other) {
        Preconditions.checkState((boolean)this.rawType.equals(other.rawType));
        if (this.typeMap.isEmpty()) {
            return other.instantiationIsUnknownOrIdentity();
        }
        if (other.typeMap.isEmpty()) {
            return this.instantiationIsUnknownOrIdentity();
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
            Preconditions.checkState((boolean)other.typeMap.containsKey((Object)typeVar), (String)"Other (%s) doesn't contain mapping (%s->%s) from this (%s)", (Object[])new Object[]{other, typeVar, this.typeMap.get((Object)typeVar), this});
            JSType thisType = (JSType)this.typeMap.get((Object)typeVar);
            JSType otherType = (JSType)other.typeMap.get((Object)typeVar);
            if (!(NominalType.allowCovariantGenerics(this) ? !thisType.isSubtypeOf(otherType) : !thisType.equals(otherType) && JSType.unifyUnknowns(thisType, otherType) == null)) continue;
            return false;
        }
        return true;
    }

    private static boolean allowCovariantGenerics(NominalType nt) {
        return nt.rawType.name.equals("Array");
    }

    private boolean instantiationIsUnknownOrIdentity() {
        if (this.typeMap.isEmpty()) {
            return true;
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
            JSType t = (JSType)this.typeMap.get((Object)typeVar);
            if (t.isUnknown() || t.equals(JSType.fromTypeVar(typeVar))) continue;
            return false;
        }
        return true;
    }

    static NominalType pickSuperclass(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.isSubtypeOf(c2)) {
            return c2;
        }
        return c2.isSubtypeOf(c1) ? c1 : null;
    }

    static NominalType pickSubclass(NominalType c1, NominalType c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isSubtypeOf(c2)) {
            return c1;
        }
        return c2.isSubtypeOf(c1) ? c2 : null;
    }

    boolean unifyWithSubtype(NominalType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        if ((other = other.findMatchingAncestorWith(this)) == null) {
            return false;
        }
        if (!this.isGeneric()) {
            return true;
        }
        Preconditions.checkState((!this.typeMap.isEmpty() ? 1 : 0) != 0);
        if (other.typeMap.isEmpty()) {
            return true;
        }
        boolean hasUnified = true;
        for (String typeParam : this.rawType.typeParameters) {
            JSType fromOtherMap = (JSType)other.typeMap.get((Object)typeParam);
            Preconditions.checkNotNull((Object)fromOtherMap, (String)"Type variable %s not found in map %s", (Object[])new Object[]{typeParam, other.typeMap});
            hasUnified = hasUnified && ((JSType)this.typeMap.get((Object)typeParam)).unifyWithSubtype(fromOtherMap, typeParameters, typeMultimap);
        }
        return hasUnified && (NominalType.allowCovariantGenerics(this) || this.isInvariantWith(typeMultimap, other));
    }

    private NominalType findMatchingAncestorWith(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this;
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.interfaces) {
                NominalType nt = i.instantiateGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
                if (nt == null) continue;
                return nt;
            }
        }
        if (this.isClass() && thisRaw.superClass != null) {
            return thisRaw.superClass.instantiateGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
        }
        return null;
    }

    private boolean isInvariantWith(Multimap<String, JSType> typeMultimap, NominalType other) {
        Preconditions.checkState((boolean)this.isGeneric());
        Preconditions.checkState((this.rawType == other.rawType ? 1 : 0) != 0);
        LinkedHashMap<String, JSType> newTypeMap = new LinkedHashMap<String, JSType>();
        for (String typeVar : typeMultimap.keySet()) {
            Collection c = typeMultimap.get((Object)typeVar);
            if (c.size() != 1) {
                return false;
            }
            newTypeMap.put(typeVar, (JSType)Preconditions.checkNotNull((Object)Iterables.getOnlyElement((Iterable)c)));
        }
        NominalType instantiated = this.instantiateGenerics(newTypeMap);
        return Objects.equals(instantiated.typeMap, other.typeMap);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.rawType.name);
        this.rawType.appendGenericSuffixTo(builder, this.typeMap);
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.typeMap, this.rawType);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Preconditions.checkState((boolean)(other instanceof NominalType));
        NominalType o = (NominalType)other;
        return Objects.equals(this.typeMap, o.typeMap) && this.rawType.equals(o.rawType);
    }

    public static class RawNominalType
    extends Namespace {
        private final String name;
        private final Node defSite;
        private PersistentMap<String, Property> classProps = PersistentMap.create();
        private PersistentMap<String, Property> protoProps = PersistentMap.create();
        boolean isFinalized = false;
        private NominalType superClass = null;
        private ImmutableSet<NominalType> interfaces = null;
        private final boolean isInterface;
        private ImmutableSet<String> allProps = null;
        private final NominalType wrappedAsNominal;
        private final JSType wrappedAsJSType;
        private final JSType wrappedAsNullableJSType;
        private final ImmutableList<String> typeParameters;
        private final ObjectKind objectKind;
        private FunctionType ctorFn;
        private JSType ctorFnWrappedAsJSType;
        private NominalType builtinFunction;

        private RawNominalType(Node defSite, String name, ImmutableList<String> typeParameters, boolean isInterface, ObjectKind objectKind) {
            Preconditions.checkNotNull((Object)objectKind);
            Preconditions.checkState((defSite == null || defSite.isFunction() ? 1 : 0) != 0);
            if (typeParameters == null) {
                typeParameters = ImmutableList.of();
            }
            this.name = name;
            this.defSite = defSite;
            this.typeParameters = typeParameters;
            this.isInterface = isInterface;
            this.objectKind = objectKind;
            this.wrappedAsNominal = new NominalType(ImmutableMap.of(), this);
            ObjectType objInstance = "Function".equals(name) ? ObjectType.fromFunction(FunctionType.TOP_FUNCTION, this.wrappedAsNominal) : ObjectType.fromNominalType(this.wrappedAsNominal);
            this.wrappedAsJSType = JSType.fromObjectType(objInstance);
            this.wrappedAsNullableJSType = JSType.join(JSType.NULL, this.wrappedAsJSType);
        }

        public static RawNominalType makeUnrestrictedClass(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(defSite, name.toString(), typeParameters, false, ObjectKind.UNRESTRICTED);
        }

        public static RawNominalType makeStructClass(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(defSite, name.toString(), typeParameters, false, ObjectKind.STRUCT);
        }

        public static RawNominalType makeDictClass(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(defSite, name.toString(), typeParameters, false, ObjectKind.DICT);
        }

        public static RawNominalType makeInterface(Node defSite, QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(defSite, name.toString(), typeParameters, true, ObjectKind.STRUCT);
        }

        public String getName() {
            return this.name;
        }

        public boolean isClass() {
            return !this.isInterface;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        boolean isGeneric() {
            return !this.typeParameters.isEmpty();
        }

        public boolean isStruct() {
            return this.objectKind.isStruct();
        }

        public boolean isDict() {
            return this.objectKind.isDict();
        }

        ImmutableList<String> getTypeParameters() {
            return this.typeParameters;
        }

        public void setCtorFunction(FunctionType ctorFn, NominalType builtinFunction) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            this.ctorFn = ctorFn;
            this.builtinFunction = builtinFunction;
        }

        private boolean hasAncestorClass(RawNominalType ancestor) {
            Preconditions.checkState((boolean)ancestor.isClass());
            if (this == ancestor) {
                return true;
            }
            if (this.superClass == null) {
                return false;
            }
            return this.superClass.rawType.hasAncestorClass(ancestor);
        }

        public boolean addSuperClass(NominalType superClass) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            Preconditions.checkState((this.superClass == null ? 1 : 0) != 0);
            if (superClass.rawType.hasAncestorClass(this)) {
                return false;
            }
            this.superClass = superClass;
            return true;
        }

        private boolean hasAncestorInterface(RawNominalType ancestor) {
            Preconditions.checkState((boolean)ancestor.isInterface);
            if (this == ancestor) {
                return true;
            }
            if (this.interfaces == null) {
                return false;
            }
            for (NominalType superInter : this.interfaces) {
                if (!superInter.rawType.hasAncestorInterface(ancestor)) continue;
                return true;
            }
            return false;
        }

        public boolean addInterfaces(ImmutableSet<NominalType> interfaces) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            Preconditions.checkState((this.interfaces == null ? 1 : 0) != 0);
            Preconditions.checkNotNull(interfaces);
            if (this.isInterface) {
                for (NominalType interf : interfaces) {
                    if (!interf.rawType.hasAncestorInterface(this)) continue;
                    this.interfaces = ImmutableSet.of();
                    return false;
                }
            }
            this.interfaces = interfaces;
            return true;
        }

        public NominalType getSuperClass() {
            return this.superClass;
        }

        public ImmutableSet<NominalType> getInterfaces() {
            return this.interfaces == null ? ImmutableSet.of() : this.interfaces;
        }

        private Property getOwnProp(String pname) {
            Property p = (Property)this.classProps.get(pname);
            if (p != null) {
                return p;
            }
            return (Property)this.protoProps.get(pname);
        }

        private Property getPropFromClass(String pname) {
            Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
            Property p = this.getOwnProp(pname);
            if (p != null) {
                return p;
            }
            if (this.superClass != null && (p = this.superClass.getProp(pname)) != null) {
                return p;
            }
            return null;
        }

        private Property getPropFromInterface(String pname) {
            Preconditions.checkState((boolean)this.isInterface);
            Property p = (Property)this.protoProps.get(pname);
            if (p != null) {
                return p;
            }
            if (this.interfaces != null) {
                for (NominalType interf : this.interfaces) {
                    p = interf.getProp(pname);
                    if (p == null) continue;
                    return p;
                }
            }
            return null;
        }

        private Property getProp(String pname) {
            if (this.isInterface) {
                return this.getPropFromInterface(pname);
            }
            return this.getPropFromClass(pname);
        }

        public boolean mayHaveOwnProp(String pname) {
            return this.getOwnProp(pname) != null;
        }

        public boolean mayHaveProp(String pname) {
            return this.getProp(pname) != null;
        }

        public JSType getInstancePropDeclaredType(String pname) {
            Property p = this.getProp(pname);
            if (p == null) {
                return null;
            }
            if (p.getDeclaredType() == null && this.superClass != null) {
                return this.superClass.getPropDeclaredType(pname);
            }
            return p.getDeclaredType();
        }

        public Set<String> getAllOwnProps() {
            LinkedHashSet<String> ownProps = new LinkedHashSet<String>();
            ownProps.addAll(this.classProps.keySet());
            ownProps.addAll(this.protoProps.keySet());
            return ownProps;
        }

        private ImmutableSet<String> getAllPropsOfInterface() {
            Preconditions.checkState((boolean)this.isInterface);
            Preconditions.checkState((boolean)this.isFinalized);
            if (this.allProps == null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (this.interfaces != null) {
                    for (NominalType interf : this.interfaces) {
                        builder.addAll(interf.rawType.getAllPropsOfInterface());
                    }
                }
                this.allProps = builder.addAll(this.protoProps.keySet()).build();
            }
            return this.allProps;
        }

        private ImmutableSet<String> getAllPropsOfClass() {
            Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.isFinalized);
            if (this.allProps == null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (this.superClass != null) {
                    builder.addAll(this.superClass.rawType.getAllPropsOfClass());
                }
                this.allProps = builder.addAll(this.classProps.keySet()).addAll(this.protoProps.keySet()).build();
            }
            return this.allProps;
        }

        public void addClassProperty(String pname, Node defSite, JSType type, boolean isConstant) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (type == null && isConstant) {
                type = JSType.UNKNOWN;
            }
            this.classProps = this.classProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
            if (this.protoProps.containsKey(pname)) {
                this.addProtoProperty(pname, defSite, type, isConstant);
            }
        }

        public void addUndeclaredClassProperty(String pname, Node defSite) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (this.mayHaveProp(pname)) {
                return;
            }
            this.classProps = this.classProps.with(pname, Property.makeWithDefsite(defSite, JSType.UNKNOWN, null));
        }

        public void addProtoProperty(String pname, Node defSite, JSType type, boolean isConstant) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (type == null && isConstant) {
                type = JSType.UNKNOWN;
            }
            if (this.classProps.containsKey(pname) && ((Property)this.classProps.get(pname)).getDeclaredType() == null) {
                this.classProps = this.classProps.without(pname);
            }
            this.protoProps = this.protoProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
        }

        public void addUndeclaredProtoProperty(String pname, Node defSite) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (!this.protoProps.containsKey(pname) || ((Property)this.protoProps.get(pname)).getDeclaredType() == null) {
                this.protoProps = this.protoProps.with(pname, Property.makeWithDefsite(defSite, JSType.UNKNOWN, null));
            }
        }

        private JSType createProtoObject() {
            return JSType.fromObjectType(ObjectType.makeObjectType(this.superClass, this.protoProps, null, false, ObjectKind.UNRESTRICTED));
        }

        public boolean hasCtorProp(String pname) {
            return super.hasProp(pname);
        }

        public void addCtorProperty(String pname, Node defSite, JSType type, boolean isConstant) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            super.addProperty(pname, defSite, type, isConstant);
        }

        public void addUndeclaredCtorProperty(String pname, Node defSite) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            super.addUndeclaredProperty(pname, defSite, JSType.UNKNOWN, false);
        }

        public JSType getCtorPropDeclaredType(String pname) {
            return super.getPropDeclaredType(pname);
        }

        private JSType getConstructorObject(FunctionType ctorFn) {
            Preconditions.checkState((boolean)this.isFinalized);
            if (this.ctorFn != ctorFn || this.ctorFnWrappedAsJSType == null) {
                JSType result = this.withNamedTypes(ObjectType.makeObjectType(this.builtinFunction, this.otherProps, ctorFn, ctorFn.isLoose(), ObjectKind.UNRESTRICTED));
                if (this.ctorFn == ctorFn) {
                    this.ctorFnWrappedAsJSType = result;
                }
                return result;
            }
            return this.ctorFnWrappedAsJSType;
        }

        private StringBuilder appendGenericSuffixTo(StringBuilder builder, Map<String, JSType> typeMap) {
            Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll((Collection<?>)this.typeParameters) ? 1 : 0) != 0);
            if (this.typeParameters.isEmpty()) {
                return builder;
            }
            boolean firstIteration = true;
            builder.append("<");
            for (String typeParam : this.typeParameters) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    builder.append(',');
                }
                JSType concrete = typeMap.get(typeParam);
                if (concrete != null) {
                    concrete.appendTo(builder);
                    continue;
                }
                builder.append(typeParam);
            }
            builder.append('>');
            return builder;
        }

        public RawNominalType finalizeNominalType() {
            Preconditions.checkState((this.ctorFn != null ? 1 : 0) != 0);
            if (this.interfaces == null) {
                this.interfaces = ImmutableSet.of();
            }
            this.addCtorProperty("prototype", null, this.createProtoObject(), false);
            this.isFinalized = true;
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.name);
            this.appendGenericSuffixTo(builder, (Map<String, JSType>)ImmutableMap.of());
            return builder.toString();
        }

        @Override
        public JSType toJSType() {
            Preconditions.checkState((boolean)this.isFinalized);
            return this.getConstructorObject(this.ctorFn);
        }

        public NominalType getAsNominalType() {
            return this.wrappedAsNominal;
        }

        public JSType getInstanceAsJSType() {
            return this.wrappedAsJSType;
        }

        public JSType getInstanceAsNullableJSType() {
            return this.wrappedAsNullableJSType;
        }
    }
}

