/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ByteCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.map.FloatKeyByteMap;
import bak.pcj.map.FloatKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractFloatKeyByteMap
implements FloatKeyByteMap {
    protected AbstractFloatKeyByteMap() {
    }

    public void clear() {
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public byte remove(float key) {
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            byte value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultByte();
    }

    public void putAll(FloatKeyByteMap map) {
        FloatKeyByteMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(float key) {
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public byte get(float key) {
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultByte();
    }

    public boolean containsValue(byte value) {
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatKeyByteMap)) {
            return false;
        }
        FloatKeyByteMap map = (FloatKeyByteMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            float k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultFloatHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultByteHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public byte tget(float key) {
        byte value = this.get(key);
        if (value == MapDefaults.defaultByte() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        FloatKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ByteCollection values();

    public abstract byte put(float var1, byte var2);

    public abstract byte lget();

    public abstract FloatSet keySet();

    public abstract FloatKeyByteMapIterator entries();
}

