/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ShortCollection;
import bak.pcj.adapter.CollectionToShortCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyShortMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyShortMap;
import bak.pcj.map.ShortKeyShortMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyShortMapAdapter
extends AbstractShortKeyShortMap
implements ShortKeyShortMap {
    protected Map map;
    protected Short lastValue;

    public MapToShortKeyShortMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyShortMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Short)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(new Short(value));
    }

    public ShortKeyShortMapIterator entries() {
        return new ShortKeyShortMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyShortMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public short getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public short get(short key) {
        Short value = (Short)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public short lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public short put(short key, short value) {
        Short oldValue = this.map.put(new Short(key), new Short(value));
        return oldValue == null ? MapDefaults.defaultShort() : oldValue;
    }

    public short remove(short key) {
        Short value = (Short)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ShortCollection values() {
        return new CollectionToShortCollectionAdapter(this.map.values());
    }

    public short tget(short key) {
        Short value = (Short)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isShortKeyShortAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

