/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.CharCollection;
import bak.pcj.adapter.CollectionToCharCollectionAdapter;
import bak.pcj.adapter.SetToCharSetAdapter;
import bak.pcj.map.AbstractCharKeyCharMap;
import bak.pcj.map.CharKeyCharMap;
import bak.pcj.map.CharKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToCharKeyCharMapAdapter
extends AbstractCharKeyCharMap
implements CharKeyCharMap {
    protected Map map;
    protected Character lastValue;

    public MapToCharKeyCharMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToCharKeyCharMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(char key) {
        this.lastValue = (Character)this.map.get(new Character(key));
        return this.lastValue != null;
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(new Character(value));
    }

    public CharKeyCharMapIterator entries() {
        return new CharKeyCharMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToCharKeyCharMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public char getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getKey()).charValue();
            }

            public char getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getValue()).charValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public char get(char key) {
        Character value = (Character)this.map.get(new Character(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public CharSet keySet() {
        return new SetToCharSetAdapter(this.map.keySet());
    }

    public char lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.charValue();
    }

    public char put(char key, char value) {
        Character oldValue = this.map.put(new Character(key), new Character(value));
        return oldValue == null ? MapDefaults.defaultChar() : oldValue.charValue();
    }

    public char remove(char key) {
        Character value = (Character)this.map.remove(new Character(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public int size() {
        return this.map.size();
    }

    public CharCollection values() {
        return new CollectionToCharCollectionAdapter(this.map.values());
    }

    public char tget(char key) {
        Character value = (Character)this.map.get(new Character(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.charValue();
    }

    public boolean validate() {
        return Adapter.isCharKeyCharAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

