/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.ListIteratorToLongListIteratorAdapter;
import bak.pcj.list.AbstractLongList;
import bak.pcj.list.LongListIterator;
import bak.pcj.util.Exceptions;
import java.util.List;

public class ListToLongListAdapter
extends AbstractLongList {
    protected List list;

    public ListToLongListAdapter(List list) {
        this(list, false);
    }

    public ListToLongListAdapter(List list, boolean validate) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
        if (validate) {
            this.evalidate();
        }
    }

    public void add(int index, long v) {
        this.list.add(index, new Long(v));
    }

    public long get(int index) {
        return (Long)this.list.get(index);
    }

    public LongListIterator listIterator(int index) {
        return new ListIteratorToLongListIteratorAdapter(this.list.listIterator(index));
    }

    public long removeElementAt(int index) {
        return (Long)this.list.remove(index);
    }

    public long set(int index, long v) {
        return this.list.set(index, new Long(v));
    }

    public int size() {
        return this.list.size();
    }

    public boolean validate() {
        return Adapter.isLongAdaptable(this.list);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("list");
        }
    }
}

