/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.FloatCollection;
import bak.pcj.adapter.FloatIteratorToIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class FloatCollectionToCollectionAdapter
extends AbstractCollection {
    protected FloatCollection collection;

    public FloatCollectionToCollectionAdapter(FloatCollection collection) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.collection.add(((Float)o).floatValue());
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.collection.contains(((Float)o).floatValue());
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public Iterator iterator() {
        return new FloatIteratorToIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.collection.remove(((Float)o).floatValue());
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.collection.size();
    }

    public int hashCode() {
        return this.collection.hashCode();
    }
}

